/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io;

import imagelib.io.ImageData;

public class ImageSeries {
    protected String name;
    protected int[] seriesData;
    protected int rows;
    protected int noSlices;
    protected int cols;

    public ImageSeries(String name, int[] seriesData, int noSlices, int rows, int cols) {
        this.name = name;
        this.seriesData = seriesData;
        this.cols = cols;
        this.rows = rows;
        this.noSlices = noSlices;
    }

    public ImageData getSlice(int sliceNum) {
        if (sliceNum < 0 || sliceNum > this.noSlices) {
            return null;
        }
        int[] rawData = new int[this.rows * this.cols];
        System.arraycopy(this.seriesData, (sliceNum - 1) * this.rows * this.cols, rawData, 0, rawData.length);
        ImageData id = new ImageData(rawData, this.cols, this.rows);
        id.setPixelSize(2);
        return id;
    }

    public String getName() {
        return this.name;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getNoSlices() {
        return this.noSlices;
    }

    public int[] getSeriesData() {
        return this.seriesData;
    }
}

