/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.Dataarchive;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DataarchiveDAO
implements clinical.server.dao.DataarchiveDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Connection con, Dataarchive bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_DATAARCHIVE ");
            buf.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,ARCHIVENAME,DESCRIPTION,DATAURI,DATASIZE,DATADESCRIPTION) ");
            buf.append("VALUES ");
            buf.append('(');
            for (int i = 0; i < 10; ++i) {
                buf.append('?');
                if (i >= 9) continue;
                buf.append(',');
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getUniqueid(), 2);
            ps.setObject(2, bean.getTableid(), 2);
            ps.setObject(3, bean.getOwner(), 2);
            ps.setTimestamp(4, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(5, bean.getModuser(), 2);
            ps.setObject(6, bean.getArchivename(), 12);
            ps.setObject(7, bean.getDescription(), 12);
            ps.setObject(8, bean.getDatauri(), 12);
            ps.setObject(9, bean.getDatasize(), 2);
            ps.setObject(10, bean.getDatadescription(), 12);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception x) {}
            }
        }
    }

    protected String prepareColList(Dataarchive bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("ARCHIVENAME");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(',');
        buf.append("DATAURI");
        buf.append(',');
        buf.append("DATASIZE");
        buf.append(',');
        buf.append("DATADESCRIPTION");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Dataarchive bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getArchivename() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("ARCHIVENAME=?");
            qi.values.add(bean.getArchivename());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        if (bean.getDatauri() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATAURI=?");
            qi.values.add(bean.getDatauri());
            valueSet = true;
        }
        if (bean.getDatasize() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATASIZE=?");
            qi.values.add(bean.getDatasize());
            valueSet = true;
        }
        if (bean.getDatadescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DATADESCRIPTION=?");
            qi.values.add(bean.getDatadescription());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Dataarchive bean, Dataarchive criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_DATAARCHIVE SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getArchivename() != null || bean.isNull("archivename")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("ARCHIVENAME=? ");
            uqi.setValues.add(bean.getArchivename());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("archivename"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (bean.getDatauri() != null || bean.isNull("datauri")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATAURI=? ");
            uqi.setValues.add(bean.getDatauri());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("datauri"), uqi);
            valueSet = true;
        }
        if (bean.getDatasize() != null || bean.isNull("datasize")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATASIZE=? ");
            uqi.setValues.add(bean.getDatasize());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("datasize"), uqi);
            valueSet = true;
        }
        if (bean.getDatadescription() != null || bean.isNull("datadescription")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DATADESCRIPTION=? ");
            uqi.setValues.add(bean.getDatadescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("datadescription"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = uqi.query + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Dataarchive createObject(ResultSet rs) throws SQLException {
        Dataarchive obj = new Dataarchive();
        obj.setUniqueid((BigDecimal)rs.getObject(1));
        obj.setTableid((BigDecimal)rs.getObject(2));
        obj.setOwner((BigDecimal)rs.getObject(3));
        if (rs.getTimestamp(4) != null) {
            obj.setModtime(new Date(rs.getTimestamp(4).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(5));
        obj.setArchivename((String)rs.getObject(6));
        obj.setDescription((String)rs.getObject(7));
        obj.setDatauri((String)rs.getObject(8));
        obj.setDatasize((BigDecimal)rs.getObject(9));
        obj.setDatadescription((String)rs.getObject(10));
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Dataarchive> find(Connection con, Dataarchive criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Dataarchive> results = new LinkedList<Dataarchive>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_DATAARCHIVE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Dataarchive item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Connection con, Dataarchive bean, Dataarchive criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection con, Dataarchive criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_DATAARCHIVE ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }
}

