/*
 * Decompiled with CFR 0.152.
 */
package clinical.web;

import clinical.server.dao.DatabaseuserDAO;
import clinical.server.dao.TableidDAO;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Dataclassification;
import clinical.server.vo.Tableid;
import clinical.utils.DBTableInfo;
import clinical.web.DAOFactory;
import clinical.web.IAppConfigService;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;
import clinical.web.services.SimpleSecurityService;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBUtils {
    protected static Log log = LogFactory.getLog(DBUtils.class);
    protected static Map<String, Map<String, DBTableInfo>> dbTableInfoMap = new HashMap<String, Map<String, DBTableInfo>>(5);

    protected DBUtils() {
    }

    public static int getTableID(String dbID, Connection con, String tableName) throws Exception {
        Tableid criteria = new Tableid();
        criteria.setTablename(tableName);
        TableidDAO dao = DAOFactory.createTableidDAO(dbID);
        List<Tableid> results = dao.find(con, criteria);
        if (results.isEmpty()) {
            return -1;
        }
        return results.get(0).getTableid().intValue();
    }

    public static Databaseuser getDatabaseUser(String dbID, Connection con, String userName) throws Exception {
        Databaseuser criteria = new Databaseuser();
        criteria.setName(userName.trim().toUpperCase());
        DatabaseuserDAO dao = DAOFactory.createDatabaseuserDAO(dbID);
        List<Databaseuser> results = dao.find(con, criteria);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, DBTableInfo> prepareTableInfoCache(UserInfo ui, String dbID, boolean force, String dbType) throws Exception {
        String key;
        Map<String, DBTableInfo> map;
        if (!force && (map = dbTableInfoMap.get(key = dbID + "_" + ui.getName())) != null) {
            return map;
        }
        int tableCount = 0;
        LinkedHashMap<String, DBTableInfo> dbTableInfoCache = new LinkedHashMap<String, DBTableInfo>(71);
        IDBPoolService pool = MinimalServiceFactory.getPoolService(dbID);
        ISecurityService secService = null;
        try {
            secService = MinimalServiceFactory.getSecurityService();
        }
        catch (BaseException be) {
            log.error((Object)be);
            log.error((Object)"Using bootstrap security service instead.");
            secService = SimpleSecurityService.getInstance();
        }
        Map<String, User> userMap = secService.getAllUsers(dbID);
        log.info((Object)("retrieving and caching metadata for database " + dbID + " ..."));
        Connection con = null;
        IAppConfigService configService = MinimalServiceFactory.getAppConfigService();
        try {
            con = pool.getConnection(ui.getName());
            User user = userMap.get(ui.getName());
            DatabaseMetaData dmd = con.getMetaData();
            String schemaName = user.getDbUser().getName().toUpperCase();
            String mediatorSchemaName = configService.getParamValue("mediator.schema.name");
            if (mediatorSchemaName != null && mediatorSchemaName.trim().length() > 0) {
                mediatorSchemaName = mediatorSchemaName.trim();
            }
            ResultSet rs = null;
            if (dbType.equals("oracle")) {
                DBTableInfo dbti;
                String tableName;
                boolean gotMetaData = false;
                rs = dmd.getTables(null, schemaName, "NC_%", new String[]{"TABLE", "VIEW"});
                while (rs.next()) {
                    gotMetaData = true;
                    tableName = rs.getString(3);
                    ++tableCount;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding table " + tableName));
                    }
                    dbti = new DBTableInfo(tableName, null);
                    dbTableInfoCache.put(tableName, dbti);
                }
                if (!gotMetaData && mediatorSchemaName.length() > 0) {
                    schemaName = mediatorSchemaName;
                    while (rs.next()) {
                        gotMetaData = true;
                        tableName = rs.getString(3);
                        dbti = new DBTableInfo(tableName, null);
                        dbTableInfoCache.put(tableName, dbti);
                        ++tableCount;
                    }
                }
            } else if (dbType.equals("postgres")) {
                schemaName = null;
                rs = dmd.getTables(null, schemaName, "nc_%", new String[]{"TABLE", "VIEW"});
                while (rs.next()) {
                    String tableName = rs.getString(3);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding table " + tableName));
                    }
                    DBTableInfo dbti = new DBTableInfo(tableName, null);
                    dbTableInfoCache.put(tableName, dbti);
                    ++tableCount;
                }
            } else {
                throw new Exception("Unsupported database type:" + dbType);
            }
            for (DBTableInfo dbti : dbTableInfoCache.values()) {
                rs = dmd.getColumns(null, schemaName, dbti.getTableName(), "%");
                HashMap<String, String> colNames = new HashMap<String, String>(19);
                while (rs.next()) {
                    String colName = rs.getString(4);
                    colNames.put(colName.toLowerCase(), colName.toLowerCase());
                }
                dbti.setColumnNames(colNames);
            }
            log.info((Object)("cached metadata for " + tableCount + " tables"));
        }
        finally {
            pool.releaseConnection(ui.getName(), con);
        }
        dbTableInfoMap.put(dbID + "_" + ui.getName(), dbTableInfoCache);
        return dbTableInfoCache;
    }

    public static Map<Integer, String> getMissingValueReasonMap(UserInfo ui, String dbID) throws Exception {
        IDBCache dbCache = MinimalServiceFactory.getDBCache(dbID);
        List<Dataclassification> dcList = dbCache.getDataClassications(ui, false);
        HashMap<Integer, String> dcMap = new HashMap<Integer, String>(17);
        for (Dataclassification dc : dcList) {
            dcMap.put(new Integer(dc.getUniqueid().intValue()), dc.getName());
        }
        return dcMap;
    }

    public static void close(Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException x) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static <T> String toInList(List<T> list) {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (t instanceof String) {
                buf.append("'").append(t).append("'");
            } else {
                buf.append(t);
            }
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }
}

