/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.helpers;

import clinical.server.vo.ConfParams;
import clinical.server.vo.ConfParamsGroup;
import clinical.utils.GenUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.MinimalServiceFactory;
import clinical.web.services.AppConfigService;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class AppConfigHelper {
    private AppConfigHelper() {
    }

    public static String toJavaVarName(String confPropsName) {
        StringBuffer buf = new StringBuffer();
        char[] cpnArr = confPropsName.toCharArray();
        boolean needsCap = false;
        for (int i = 0; i < cpnArr.length; ++i) {
            if (!needsCap && cpnArr[i] != '.') {
                buf.append(cpnArr[i]);
                continue;
            }
            if (cpnArr[i] == '.') {
                needsCap = true;
                continue;
            }
            if (!needsCap || cpnArr[i] == '.') continue;
            buf.append(Character.toUpperCase(cpnArr[i]));
            needsCap = false;
        }
        return buf.toString();
    }

    public static String toConfPropsName(String javaVarName) {
        StringBuffer buf = new StringBuffer();
        char[] jvnArr = javaVarName.toCharArray();
        for (int i = 0; i < jvnArr.length; ++i) {
            if (Character.isUpperCase(jvnArr[i])) {
                buf.append('.').append(Character.toLowerCase(jvnArr[i]));
                continue;
            }
            buf.append(jvnArr[i]);
        }
        return buf.toString();
    }

    public static int getConfPropsIndexNumber(String confPropsName) {
        int idx = confPropsName.lastIndexOf(46);
        if (idx == -1) {
            return -1;
        }
        String suffix = confPropsName.substring(idx + 1);
        return GenUtils.toInt(suffix, -1);
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz) throws ClassNotFoundException, IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] descriptors = (PropertyDescriptor[])bi.getPropertyDescriptors().clone();
        HashMap<String, PropertyDescriptor> descriptorsMap = new HashMap<String, PropertyDescriptor>(19);
        for (int i = 0; i < descriptors.length; ++i) {
            descriptorsMap.put(descriptors[i].getName(), descriptors[i]);
        }
        return descriptorsMap;
    }

    public static void setProperty(Object object, String value, PropertyDescriptor pd) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Method m = pd.getWriteMethod();
        m.invoke(object, value);
    }

    public static String getProperty(Object object, PropertyDescriptor pd) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Method m = pd.getReadMethod();
        return (String)m.invoke(object, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void confParamsFromXml2DB(String xmlConfFile) throws Exception {
        InputStream is = AppConfigHelper.class.getClassLoader().getResourceAsStream(xmlConfFile);
        SAXBuilder builder = null;
        builder = new SAXBuilder(false);
        Document doc = builder.build(is);
        Element root = doc.getRootElement();
        HashMap<String, Group> groupMap = new HashMap<String, Group>(7);
        ArrayList<Param> paramList = new ArrayList<Param>(20);
        List groupList = root.getChild("groups").getChildren("group");
        for (Element gEl : groupList) {
            Group group = new Group(gEl.getAttributeValue("id"), gEl.getAttributeValue("name"));
            groupMap.put(group.id, group);
            if (gEl.getChild("description") == null) continue;
            group.description = gEl.getChildTextTrim("description");
        }
        List peList = root.getChild("params").getChildren("param");
        for (Element pel : peList) {
            Group g;
            Param p = new Param(pel.getAttributeValue("name"), pel.getAttributeValue("value"), pel.getAttributeValue("type"));
            String gid = pel.getAttributeValue("gid");
            p.group = g = (Group)groupMap.get(gid);
            if (pel.getChild("description") != null) {
                p.description = pel.getChildTextTrim("description");
            }
            paramList.add(p);
        }
        MinimalServiceFactory.setMimimalOpMode(true);
        ConnectionSupportMixin csm = null;
        try {
            csm = new ConnectionSupportMixin("users.xml");
            csm.startup();
            AppConfigService acs = AppConfigService.getInstance(csm.getDbPoolService(), csm.getDbID());
            for (Group g : groupMap.values()) {
                ConfParamsGroup pg = acs.getParamGroup(g.name);
                if (pg != null) continue;
                acs.addParameterGroup(g.name, g.description);
            }
            for (Param p : paramList) {
                ConfParams cp = acs.getParam(p.name);
                if (cp == null) {
                    String value = p.value;
                    if (value == null || value.trim().length() == 0) {
                        value = " ";
                    }
                    acs.addParameter(p.name, value, p.type, p.description, p.group.name);
                    continue;
                }
                if (cp.getValue() == null || !cp.getValue().equals(p.value)) {
                    System.out.println("updating " + p);
                    acs.updateParameter(p.name, p.value);
                    continue;
                }
                System.out.println("****** " + p);
            }
            System.out.println("finished populating HID with default application configuration data.");
        }
        finally {
            if (csm != null) {
                csm.shutdown();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AppConfigHelper.confParamsFromXml2DB("clinical-conf.xml");
    }

    public static class Param {
        String name;
        String value;
        String type;
        Group group;
        String description;

        public Param(String name, String value, String type) {
            this.name = name;
            this.value = value;
            this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Param::[");
            sb.append("name:").append(this.name);
            sb.append(",value:").append(this.value);
            sb.append(']');
            return sb.toString();
        }
    }

    public static class Group {
        String id;
        String name;
        String description;

        public Group(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

