/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.server.dao.ConfParamsDAO;
import clinical.server.dao.ConfParamsGroupDAO;
import clinical.server.vo.ConfParams;
import clinical.server.vo.ConfParamsGroup;
import clinical.server.vo.Databaseuser;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.DAOFactory;
import clinical.web.IAppConfigService;
import clinical.web.ISQLDialect;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.exception.BaseException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppConfigService
implements IAppConfigService {
    private Map<String, ConfParamsGroup> paramGroupMap = Collections.synchronizedMap(new HashMap(11));
    private Map<BigDecimal, ConfParamsGroup> pgByIdMap = Collections.synchronizedMap(new HashMap(11));
    private Map<String, ConfParams> paramMap = Collections.synchronizedMap(new HashMap());
    private String dbID;
    private IDBPoolService poolService;
    private static AppConfigService instance = null;
    private Log log = LogFactory.getLog((String)"app-config");

    private AppConfigService(IDBPoolService poolService, String dbID) throws BaseException {
        this.poolService = poolService;
        this.dbID = dbID;
        Connection con = null;
        try {
            con = poolService.getConnection("admin");
            this.loadAllParams(con);
        }
        catch (Exception e) {
            if (e instanceof BaseException) {
                throw (BaseException)e;
            }
            throw new BaseException(e);
        }
        finally {
            poolService.releaseConnection("admin", con);
        }
    }

    public static synchronized AppConfigService getInstance(IDBPoolService poolService, String dbID) throws BaseException {
        if (instance == null) {
            instance = new AppConfigService(poolService, dbID);
        }
        return instance;
    }

    public static synchronized AppConfigService getInstance() throws BaseException {
        if (instance == null) {
            throw new BaseException("Application Configuration Service is not initialized!");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfParamsGroup addParameterGroup(String groupName, String description) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection("admin");
            con.setAutoCommit(false);
            ConfParamsGroup pg = this.addParameterGroup(con, groupName, description);
            con.commit();
            Object object = this;
            synchronized (object) {
                this.paramGroupMap.put(pg.getGroupName(), pg);
                this.pgByIdMap.put(pg.getUniqueId(), pg);
            }
            object = pg;
            return object;
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
            ConfParamsGroup confParamsGroup = null;
            return confParamsGroup;
        }
        finally {
            this.poolService.releaseConnection("admin", con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameterGroup(String groupName) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection("admin");
            con.setAutoCommit(false);
            this.removeParameterGroup(groupName);
            con.commit();
            AppConfigService appConfigService = this;
            synchronized (appConfigService) {
                this.paramGroupMap.remove(groupName);
                ConfParamsGroup thePG = null;
                for (ConfParamsGroup pg : this.pgByIdMap.values()) {
                    if (!pg.getGroupName().equals(groupName)) continue;
                    thePG = pg;
                    break;
                }
                this.pgByIdMap.remove(thePG.getUniqueId());
            }
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
        }
        finally {
            this.poolService.releaseConnection("admin", con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(String name, String value, String type, String description, String groupName) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection("admin");
            con.setAutoCommit(false);
            ConfParams p = this.addParameter(con, name, value, type, description, groupName);
            con.commit();
            this.paramMap.put(p.getName(), p);
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
        }
        finally {
            this.poolService.releaseConnection("admin", con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateParameter(String name, String value) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection("admin");
            con.setAutoCommit(false);
            this.updateParameter(con, name, value);
            con.commit();
            AppConfigService appConfigService = this;
            synchronized (appConfigService) {
                ConfParams p = this.paramMap.get(name);
                p.setValue(value);
            }
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
        }
        finally {
            this.poolService.releaseConnection("admin", con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParameter(String name) throws Exception {
        Connection con = null;
        try {
            con = this.poolService.getConnection("admin");
            con.setAutoCommit(false);
            this.removeParameter(con, name);
            con.commit();
            this.paramMap.remove(name);
        }
        catch (Exception x) {
            this.handleErrorAndRollBack(con, "", x);
        }
        finally {
            this.poolService.releaseConnection("admin", con);
        }
    }

    public ConfParams getParam(String name) {
        return this.paramMap.get(name);
    }

    @Override
    public String getParamValue(String name) {
        ConfParams cp = this.paramMap.get(name);
        if (cp == null || cp.getValue() == null) {
            return null;
        }
        return cp.getValue().trim();
    }

    @Override
    public String[] getParamValues(String name) {
        ArrayList<ParamOrder> poList = new ArrayList<ParamOrder>(10);
        for (String pn : this.paramMap.keySet()) {
            if (!pn.startsWith(name)) continue;
            ConfParams cp = this.paramMap.get(pn);
            String s = pn.substring(name.length() + 1);
            int idx = GenUtils.toInt(s, -1);
            if (idx == -1) continue;
            ParamOrder po = new ParamOrder(idx, cp.getValue());
            poList.add(po);
        }
        Collections.sort(poList, new Comparator<ParamOrder>(){

            @Override
            public int compare(ParamOrder o1, ParamOrder o2) {
                return o1.idx - o2.idx;
            }
        });
        String[] values = new String[poList.size()];
        int i = 0;
        for (ParamOrder po : poList) {
            values[i++] = po.value;
        }
        return values;
    }

    public synchronized ConfParamsGroup getGroupForParam(String name) {
        ConfParams p = this.paramMap.get(name);
        if (p == null) {
            return null;
        }
        return this.pgByIdMap.get(p.getParamGroupId());
    }

    public List<ConfParamsGroup> getAllParamGroups() {
        return new ArrayList<ConfParamsGroup>(this.pgByIdMap.values());
    }

    public List<ConfParams> getAllParams() {
        return new ArrayList<ConfParams>(this.paramMap.values());
    }

    public ConfParamsGroup getParamGroup(String groupName) {
        return this.paramGroupMap.get(groupName);
    }

    protected ConfParamsGroup addParameterGroup(Connection con, String groupName, String description) throws Exception {
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(this.dbID);
        ConfParamsGroupDAO pgDAO = DAOFactory.createConfParamsGroupDAO(this.dbID);
        Databaseuser d = this.getDatabaseUser(con);
        ConfParamsGroup pg = new ConfParamsGroup();
        pg.setGroupName(groupName);
        pg.setDescription(description);
        pg.setOwner(d.getUniqueid());
        pg.setModUser(d.getUniqueid());
        pg.setModTime(new Date());
        BigDecimal uniqueId = sequenceHelper.getNextUID(con, "nc_conf_params_group", "uniqueId");
        pg.setUniqueId(uniqueId);
        pgDAO.insert(con, pg);
        return pg;
    }

    protected void removeParameterGroup(Connection con, String groupName) throws Exception {
        ConfParamsGroupDAO pgDAO = DAOFactory.createConfParamsGroupDAO(this.dbID);
        ConfParamsDAO pDAO = DAOFactory.createConfParamsDAO(this.dbID);
        ConfParamsGroup cr = new ConfParamsGroup();
        cr.setGroupName(groupName);
        List<ConfParamsGroup> pgList = pgDAO.find(con, cr);
        if (pgList.isEmpty()) {
            return;
        }
        ConfParamsGroup pg = pgList.get(0);
        ConfParams pcr = new ConfParams();
        pcr.setParamGroupId(pg.getUniqueId());
        pDAO.delete(con, pcr);
        pgDAO.delete(con, cr);
    }

    protected ConfParams addParameter(Connection con, String name, String value, String type, String description, String groupName) throws Exception {
        ConfParamsGroupDAO pgDAO = DAOFactory.createConfParamsGroupDAO(this.dbID);
        ConfParamsDAO pDAO = DAOFactory.createConfParamsDAO(this.dbID);
        ConfParamsGroup pgCR = new ConfParamsGroup();
        pgCR.setGroupName(groupName);
        List<ConfParamsGroup> pgList = pgDAO.find(con, pgCR);
        if (pgList.isEmpty() || pgList.size() != 1) {
            throw new Exception("Nonexistent or not unique parameter group name:" + groupName);
        }
        ConfParamsGroup pg = pgList.get(0);
        ConfParams p = new ConfParams();
        p.setName(name);
        p.setValue(value);
        p.setType(type);
        p.setDescription(description);
        p.setParamGroupId(pg.getUniqueId());
        Databaseuser d = this.getDatabaseUser(con);
        p.setOwner(d.getUniqueid());
        p.setModUser(d.getUniqueid());
        p.setModTime(new Date());
        pDAO.insert(con, p);
        return p;
    }

    public void updateParameter(Connection con, String name, String value) throws Exception {
        ConfParamsDAO pDAO = DAOFactory.createConfParamsDAO(this.dbID);
        ConfParams cr = new ConfParams();
        cr.setName(name);
        List<ConfParams> pList = pDAO.find(con, cr);
        if (!pList.isEmpty()) {
            ConfParams p = new ConfParams();
            p.setValue(value);
            pDAO.update(con, p, cr);
        }
    }

    protected void removeParameter(Connection con, String name) throws Exception {
        ConfParamsDAO pDAO = DAOFactory.createConfParamsDAO(this.dbID);
        ConfParams cr = new ConfParams();
        cr.setName(name);
        pDAO.delete(con, cr);
    }

    protected synchronized void loadAllParams(Connection con) throws Exception {
        ConfParamsDAO pDAO = DAOFactory.createConfParamsDAO(this.dbID);
        ConfParamsGroupDAO pgDAO = DAOFactory.createConfParamsGroupDAO(this.dbID);
        List<ConfParamsGroup> pgList = pgDAO.find(con, new ConfParamsGroup());
        List<ConfParams> pList = pDAO.find(con, new ConfParams());
        for (ConfParams p : pList) {
            this.paramMap.put(p.getName(), p);
        }
        for (ConfParamsGroup pg : pgList) {
            this.paramGroupMap.put(pg.getGroupName(), pg);
            this.pgByIdMap.put(pg.getUniqueId(), pg);
        }
    }

    protected Databaseuser getDatabaseUser(Connection con) throws Exception {
        ISQLDialect sqlDialect = MinimalServiceFactory.getSQLDialect(this.dbID);
        TSQLProcessor tsp = new TSQLProcessor(sqlDialect);
        List<?> results = tsp.executeQuery(con, "select u.* from Databaseuser as u where u.name ='ADMIN' and u.isgroup = false");
        Assertion.assertFalse(results.isEmpty());
        Databaseuser dbUser = (Databaseuser)results.get(0);
        return dbUser;
    }

    protected void handleErrorAndRollBack(Connection con, String msg, Exception x) throws BaseException {
        if (con != null) {
            try {
                con.rollback();
            }
            catch (SQLException se) {
                this.log.error((Object)"", (Throwable)se);
                throw new BaseException(se);
            }
        }
        this.log.error((Object)msg, (Throwable)x);
        if (x instanceof BaseException) {
            throw (BaseException)x;
        }
        throw new BaseException(x);
    }

    class ParamOrder {
        int idx;
        String value;

        public ParamOrder(int idx, String value) {
            this.idx = idx;
            this.value = value;
        }
    }
}

