/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.services;

import clinical.web.DBUtils;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.services.AbstractSequenceHelper;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleSequenceHelper
extends AbstractSequenceHelper {
    protected OracleSequenceHelper(String dbID) throws BaseException {
        super(dbID);
    }

    public static synchronized OracleSequenceHelper getInstance(String dbID, String dbType) throws BaseException {
        OracleSequenceHelper seqHelper = (OracleSequenceHelper)instanceMap.get(dbID + "_" + dbType);
        if (seqHelper == null) {
            seqHelper = new OracleSequenceHelper(dbID);
            instanceMap.put(dbID, seqHelper);
        }
        return seqHelper;
    }

    @Override
    public synchronized BigDecimal getNextUID(Connection con, String tableName, String columnName) throws BaseException {
        ResultSet rs;
        Statement st;
        block4: {
            BigDecimal bigDecimal;
            st = null;
            rs = null;
            try {
                st = con.createStatement();
                rs = st.executeQuery("select uid_seq.nextval from dual");
                if (!rs.next()) break block4;
                BigDecimal uid = rs.getBigDecimal(1);
                this.fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
                bigDecimal = uid;
            }
            catch (SQLException x) {
                try {
                    throw new BaseException(x);
                }
                catch (Throwable throwable) {
                    DBUtils.close(st, rs);
                    throw throwable;
                }
            }
            DBUtils.close(st, rs);
            return bigDecimal;
        }
        DBUtils.close(st, rs);
        return null;
    }

    @Override
    public synchronized BigDecimal getNextUID(UserInfo ui, String tableName, String columnName) throws BaseException {
        Statement st;
        Connection con;
        block4: {
            BigDecimal bigDecimal;
            con = null;
            st = null;
            try {
                con = this.dbPoolService.getConnection(ui.getName());
                st = con.createStatement();
                ResultSet rs = st.executeQuery("select uid_seq.nextval from dual");
                if (!rs.next()) break block4;
                BigDecimal uid = rs.getBigDecimal(1);
                this.fireSequenceNumCreateEvent(tableName, columnName, uid.toString());
                bigDecimal = uid;
            }
            catch (Exception x) {
                try {
                    this.log.error((Object)"", (Throwable)x);
                    throw new BaseException(x);
                }
                catch (Throwable throwable) {
                    DBUtils.close(st);
                    this.releaseConnection(con, ui);
                    throw throwable;
                }
            }
            DBUtils.close(st);
            this.releaseConnection(con, ui);
            return bigDecimal;
        }
        DBUtils.close(st);
        this.releaseConnection(con, ui);
        return null;
    }
}

