/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LabelTable;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int LINE_ICODE = 147;
    private static final int SOURCEFILE_ICODE = 148;
    private static final int SHORTNUMBER_ICODE = 149;
    private static final int INTNUMBER_ICODE = 150;
    private static final int RETURN_UNDEF_ICODE = 151;
    private static final int END_ICODE = 152;
    static PrintWriter out;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private VariableTable itsVariableTable;
    private int itsTryDepth = 0;
    private int itsStackDepth = 0;
    private String itsSourceFile;
    private int itsLineNumber = 0;
    private LabelTable itsLabels = new LabelTable();
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private String lastAddString;
    private int version;
    private boolean inLineStepMode;
    private String debugSource;
    private static final Object DBL_MRK;

    public IRFactory createIRFactory(Context cx, TokenStream ts) {
        return new IRFactory(this, ts);
    }

    public FunctionNode createFunctionNode(IRFactory irFactory, String name) {
        return new FunctionNode(name);
    }

    public Node transform(Context cx, IRFactory irFactory, Node tree) {
        tree = new NodeTransformer(irFactory).transform(tree, null);
        return tree;
    }

    public Object compile(Context cx, Scriptable scope, Node tree, SecurityController securityController, Object securityDomain) {
        this.version = cx.getLanguageVersion();
        this.itsData = new InterpreterData(securityDomain);
        if (tree instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)tree;
            this.itsData.itsFunctionType = f.getFunctionType();
            this.generateFunctionICode(cx, scope, f);
            return Interpreter.createFunction(cx, scope, this.itsData, false);
        }
        this.generateScriptICode(cx, scope, (ScriptOrFnNode)tree);
        return new InterpretedScript(cx, this.itsData);
    }

    private void generateScriptICode(Context cx, Scriptable scope, ScriptOrFnNode tree) {
        this.itsData.itsSourceFile = this.itsSourceFile = tree.getSourceName();
        this.debugSource = tree.getOriginalSource();
        this.generateNestedFunctions(cx, scope, tree);
        this.generateRegExpLiterals(cx, scope, tree);
        this.itsVariableTable = tree.getVariableTable();
        this.generateICodeFromTree(tree);
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, this.itsData, this.debugSource);
        }
    }

    private void generateFunctionICode(Context cx, Scriptable scope, FunctionNode theFunction) {
        String savedSource = this.debugSource;
        this.debugSource = theFunction.getOriginalSource();
        if (this.debugSource == null) {
            this.debugSource = savedSource;
        }
        this.generateNestedFunctions(cx, scope, theFunction);
        this.generateRegExpLiterals(cx, scope, theFunction);
        this.itsData.itsNeedsActivation = theFunction.requiresActivation();
        this.itsVariableTable = theFunction.getVariableTable();
        this.generateICodeFromTree(theFunction.getLastChild());
        this.itsData.itsName = theFunction.getFunctionName();
        this.itsData.itsSourceFile = theFunction.getSourceName();
        this.itsData.itsSource = theFunction.getEncodedSource();
        if (cx.debugger != null) {
            cx.debugger.handleCompilationDone(cx, this.itsData, this.debugSource);
        }
        this.debugSource = savedSource;
    }

    private void generateNestedFunctions(Context cx, Scriptable scope, Node tree) {
        ObjArray functionList = (ObjArray)tree.getProp(5);
        if (functionList == null) {
            return;
        }
        int N = functionList.size();
        InterpreterData[] array = new InterpreterData[N];
        int i = 0;
        while (i != N) {
            FunctionNode def = (FunctionNode)functionList.get(i);
            Interpreter jsi = new Interpreter();
            jsi.itsSourceFile = this.itsSourceFile;
            jsi.itsData = new InterpreterData(this.itsData.securityDomain);
            jsi.itsData.itsCheckThis = def.getCheckThis();
            jsi.itsData.itsFunctionType = def.getFunctionType();
            jsi.itsInFunctionFlag = true;
            jsi.debugSource = this.debugSource;
            jsi.generateFunctionICode(cx, scope, def);
            array[i] = jsi.itsData;
            def.putIntProp(5, i);
            ++i;
        }
        this.itsData.itsNestedFunctions = array;
    }

    private void generateRegExpLiterals(Context cx, Scriptable scope, ScriptOrFnNode tree) {
        int N = tree.getRegexpCount();
        if (N == 0) {
            return;
        }
        RegExpProxy rep = cx.getRegExpProxy();
        if (rep == null) {
            throw Context.reportRuntimeError0("msg.no.regexp");
        }
        Object[] array = new Object[N];
        int i = 0;
        while (i != N) {
            String string = tree.getRegexpString(i);
            String flags = tree.getRegexpFlags(i);
            array[i] = rep.newRegExp(cx, scope, string, flags, false);
            ++i;
        }
        this.itsData.itsRegExpLiterals = array;
    }

    private void generateICodeFromTree(Node tree) {
        Object[] tmp;
        int theICodeTop = 0;
        theICodeTop = this.generateICode(tree, theICodeTop);
        this.itsLabels.fixLabelGotos(this.itsData.itsICode);
        if (this.itsData.itsFunctionType == 0) {
            theICodeTop = this.addByte(152, theICodeTop);
        }
        this.itsData.itsICodeTop = theICodeTop;
        if (this.itsData.itsICode.length != theICodeTop) {
            tmp = new byte[theICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, theICodeTop);
            this.itsData.itsICode = tmp;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            ObjToIntMap.Iterator iter = this.itsStrings.newIterator();
            iter.start();
            while (!iter.done()) {
                String str = (String)iter.getKey();
                int index = iter.getValue();
                if (this.itsData.itsStringTable[index] != null) {
                    Context.codeBug();
                }
                this.itsData.itsStringTable[index] = str;
                iter.next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            tmp = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, tmp, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = tmp;
        }
        this.itsData.itsMaxVars = this.itsVariableTable.size();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxTryDepth + this.itsData.itsMaxStack;
        this.itsData.argNames = this.itsVariableTable.getAllVariables();
        this.itsData.argCount = this.itsVariableTable.getParameterCount();
    }

    private int updateLineNumber(Node node, int iCodeTop) {
        int lineno = node.getLineno();
        if (lineno != this.itsLineNumber && lineno >= 0) {
            this.itsLineNumber = lineno;
            iCodeTop = this.addByte(147, iCodeTop);
            iCodeTop = this.addShort(lineno, iCodeTop);
        }
        return iCodeTop;
    }

    private void badTree(Node node) {
        try {
            out = new PrintWriter(new FileOutputStream("icode.txt", true));
            out.println("Un-handled node : " + node.toString());
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Un-handled node : " + node.toString());
    }

    private int generateICode(Node node, int iCodeTop) {
        Node child;
        int type = node.getType();
        Node firstChild = child = node.getFirstChild();
        block0 : switch (type) {
            case 110: {
                FunctionNode fn = (FunctionNode)node.getProp(5);
                if (fn.itsFunctionType == 1) break;
                int index = fn.getExistingIntProp(5);
                iCodeTop = this.addByte(55, iCodeTop);
                iCodeTop = this.addIndex(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 146: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    if (child.getType() != 110) {
                        iCodeTop = this.generateICode(child, iCodeTop);
                    }
                    child = child.getNext();
                }
                break;
            }
            case 116: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                child = child.getNext();
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNext();
                }
                break;
            }
            case 117: 
            case 124: 
            case 128: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNext();
                }
                break;
            }
            case 96: {
                iCodeTop = this.generateICode(child, iCodeTop);
                while (null != (child = child.getNext())) {
                    iCodeTop = this.addByte(57, iCodeTop);
                    --this.itsStackDepth;
                    iCodeTop = this.generateICode(child, iCodeTop);
                }
                break;
            }
            case 115: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                int theLocalSlot = this.itsData.itsMaxLocals++;
                iCodeTop = this.addByte(69, iCodeTop);
                iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                ObjArray cases = (ObjArray)node.getProp(12);
                int i = 0;
                while (i < cases.size()) {
                    Node thisCase = (Node)cases.get(i);
                    Node first = thisCase.getFirstChild();
                    iCodeTop = this.generateICode(first, iCodeTop);
                    iCodeTop = this.addByte(70, iCodeTop);
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte(53, iCodeTop);
                    --this.itsStackDepth;
                    Node target = new Node(137);
                    thisCase.addChildAfter(target, first);
                    iCodeTop = this.addGoto(target, 7, iCodeTop);
                    ++i;
                }
                Node defaultNode = (Node)node.getProp(13);
                if (defaultNode != null) {
                    Node defaultTarget = new Node(137);
                    defaultNode.getFirstChild().addChildToFront(defaultTarget);
                    iCodeTop = this.addGoto(defaultTarget, 6, iCodeTop);
                }
                Node breakTarget = (Node)node.getProp(2);
                iCodeTop = this.addGoto(breakTarget, 6, iCodeTop);
                break;
            }
            case 137: {
                this.markTargetLabel(node, iCodeTop);
                if (node.getProp(18) == null) break;
                this.itsStackDepth = 1;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 102: 
            case 103: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                int op = node.getOperation();
                if (this.version == 120) {
                    if (op == 14) {
                        op = 53;
                    } else if (op == 15) {
                        op = 54;
                    }
                }
                iCodeTop = this.addByte(op, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 30: 
            case 43: {
                if (!(this.itsSourceFile == null || this.itsData.itsSourceFile != null && this.itsSourceFile.equals(this.itsData.itsSourceFile))) {
                    this.itsData.itsSourceFile = this.itsSourceFile;
                }
                iCodeTop = this.addByte(148, iCodeTop);
                int childCount = 0;
                String functionName = null;
                while (child != null) {
                    int childType;
                    iCodeTop = this.generateICode(child, iCodeTop);
                    if (functionName == null && ((childType = child.getType()) == 44 || childType == 39)) {
                        functionName = this.lastAddString;
                    }
                    child = child.getNext();
                    ++childCount;
                }
                if (node.getProp(25) != null) {
                    iCodeTop = this.addByte(67, iCodeTop);
                    iCodeTop = this.addShort(this.itsLineNumber, iCodeTop);
                    iCodeTop = this.addString(this.itsSourceFile, iCodeTop);
                } else {
                    iCodeTop = this.addByte(type, iCodeTop);
                    iCodeTop = this.addString(functionName, iCodeTop);
                }
                this.itsStackDepth -= childCount - 1;
                childCount = type == 30 ? --childCount : (childCount -= 2);
                iCodeTop = this.addIndex(childCount, iCodeTop);
                if (childCount > this.itsData.itsMaxCalleeArgs) {
                    this.itsData.itsMaxCalleeArgs = childCount;
                }
                iCodeTop = this.addByte(148, iCodeTop);
                break;
            }
            case 69: 
            case 144: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(69, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                break;
            }
            case 145: {
                if (node.getProp(1) != null) {
                    iCodeTop = this.addByte(66, iCodeTop);
                } else {
                    iCodeTop = this.addByte(70, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                }
                Node temp = (Node)node.getProp(7);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                break;
            }
            case 70: {
                iCodeTop = this.addByte(70, iCodeTop);
                Node temp = (Node)node.getProp(6);
                iCodeTop = this.addLocalRef(temp, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 7: 
            case 8: {
                iCodeTop = this.generateICode(child, iCodeTop);
                --this.itsStackDepth;
            }
            case 6: {
                Node target = (Node)node.getProp(1);
                iCodeTop = this.addGoto(target, (byte)type, iCodeTop);
                break;
            }
            case 143: {
                Node target = (Node)node.getProp(1);
                target.putProp(18, node);
                iCodeTop = this.addGoto(target, 65, iCodeTop);
                break;
            }
            case 101: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int falseJumpStart = iCodeTop;
                iCodeTop = this.addForwardGoto(8, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.resolveForwardGoto(falseJumpStart, iCodeTop);
                break;
            }
            case 100: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(9, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int trueJumpStart = iCodeTop;
                iCodeTop = this.addForwardGoto(7, iCodeTop);
                iCodeTop = this.addByte(57, iCodeTop);
                --this.itsStackDepth;
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.resolveForwardGoto(trueJumpStart, iCodeTop);
                break;
            }
            case 39: {
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(16);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte(81, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte(86, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(39, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 31: 
            case 41: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 142: {
                iCodeTop = this.generateICode(child, iCodeTop);
                Object toType = node.getProp(15);
                if (toType == ScriptRuntime.NumberClass) {
                    iCodeTop = this.addByte(58, iCodeTop);
                    break;
                }
                this.badTree(node);
                break;
            }
            case 105: {
                iCodeTop = this.generateICode(child, iCodeTop);
                switch (node.getOperation()) {
                    case 132: {
                        iCodeTop = this.addByte(57, iCodeTop);
                        iCodeTop = this.addByte(74, iCodeTop);
                        break block0;
                    }
                    case 129: {
                        int trueJumpStart = iCodeTop;
                        iCodeTop = this.addForwardGoto(7, iCodeTop);
                        int beyondJumpStart = iCodeTop = this.addByte(52, iCodeTop);
                        iCodeTop = this.addForwardGoto(6, iCodeTop);
                        this.resolveForwardGoto(trueJumpStart, iCodeTop);
                        iCodeTop = this.addByte(51, iCodeTop);
                        this.resolveForwardGoto(beyondJumpStart, iCodeTop);
                        break block0;
                    }
                    case 28: {
                        iCodeTop = this.addByte(28, iCodeTop);
                        break block0;
                    }
                    case 32: {
                        iCodeTop = this.addByte(32, iCodeTop);
                        break block0;
                    }
                    case 24: {
                        iCodeTop = this.addByte(29, iCodeTop);
                        break block0;
                    }
                    case 23: {
                        iCodeTop = this.addByte(58, iCodeTop);
                        break block0;
                    }
                }
                this.badTree(node);
                break;
            }
            case 40: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                String s = (String)node.getProp(16);
                if (s != null) {
                    if (s.equals("__proto__")) {
                        iCodeTop = this.addByte(83, iCodeTop);
                        break;
                    }
                    if (s.equals("__parent__")) {
                        iCodeTop = this.addByte(84, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(40, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 42: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 10: {
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(10, iCodeTop);
                iCodeTop = this.addString(firstChild.getString(), iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 32: {
                String name = node.getString();
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.itsVariableTable.getOrdinal(name);
                }
                if (index == -1) {
                    iCodeTop = this.addByte(78, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                } else {
                    iCodeTop = this.addByte(72, iCodeTop);
                    iCodeTop = this.addByte(index, iCodeTop);
                    iCodeTop = this.addByte(32, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 141: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(82, iCodeTop);
                break;
            }
            case 44: 
            case 46: 
            case 61: 
            case 71: {
                iCodeTop = this.addByte(type, iCodeTop);
                iCodeTop = this.addString(node.getString(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 106: 
            case 107: {
                int childType = child.getType();
                switch (childType) {
                    case 72: {
                        String name = child.getString();
                        if (this.itsData.itsNeedsActivation) {
                            iCodeTop = this.addByte(85, iCodeTop);
                            iCodeTop = this.addByte(46, iCodeTop);
                            iCodeTop = this.addString(name, iCodeTop);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            iCodeTop = this.addByte(type == 106 ? 34 : 37, iCodeTop);
                            --this.itsStackDepth;
                            break;
                        }
                        int i = this.itsVariableTable.getOrdinal(name);
                        iCodeTop = this.addByte(type == 106 ? 59 : 60, iCodeTop);
                        iCodeTop = this.addByte(i, iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 39: 
                    case 41: {
                        Node getPropChild = child.getFirstChild();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        getPropChild = getPropChild.getNext();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        iCodeTop = childType == 39 ? this.addByte(type == 106 ? 34 : 37, iCodeTop) : this.addByte(type == 106 ? 35 : 38, iCodeTop);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        iCodeTop = this.addByte(type == 106 ? 33 : 36, iCodeTop);
                        iCodeTop = this.addString(child.getString(), iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 45: {
                double num = node.getDouble();
                int inum = (int)num;
                if ((double)inum == num) {
                    if (inum == 0) {
                        iCodeTop = this.addByte(47, iCodeTop);
                    } else if (inum == 1) {
                        iCodeTop = this.addByte(48, iCodeTop);
                    } else if ((short)inum == inum) {
                        iCodeTop = this.addByte(149, iCodeTop);
                        iCodeTop = this.addShort(inum, iCodeTop);
                    } else {
                        iCodeTop = this.addByte(150, iCodeTop);
                        iCodeTop = this.addInt(inum, iCodeTop);
                    }
                } else {
                    iCodeTop = this.addByte(45, iCodeTop);
                    iCodeTop = this.addDouble(num, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: 
            case 57: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
            }
            case 3: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 68: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(type, iCodeTop);
                break;
            }
            case 77: {
                iCodeTop = this.addByte(type, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 4: {
                iCodeTop = this.addByte(type, iCodeTop);
                break;
            }
            case 75: {
                ++this.itsTryDepth;
                if (this.itsTryDepth > this.itsData.itsMaxTryDepth) {
                    this.itsData.itsMaxTryDepth = this.itsTryDepth;
                }
                Node catchTarget = (Node)node.getProp(1);
                Node finallyTarget = (Node)node.getProp(18);
                int tryStart = iCodeTop;
                if (catchTarget == null) {
                    iCodeTop = this.addByte(75, iCodeTop);
                    iCodeTop = this.addShort(0, iCodeTop);
                } else {
                    iCodeTop = this.addGoto(catchTarget, 75, iCodeTop);
                }
                iCodeTop = this.addShort(0, iCodeTop);
                Node lastChild = null;
                boolean insertedEndTry = false;
                while (child != null) {
                    if (catchTarget != null && lastChild == catchTarget) {
                        this.itsStackDepth = 1;
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                    }
                    Node nextSibling = child.getNext();
                    if (!(insertedEndTry || nextSibling == null || nextSibling != catchTarget && nextSibling != finallyTarget)) {
                        iCodeTop = this.addByte(76, iCodeTop);
                        insertedEndTry = true;
                    }
                    iCodeTop = this.generateICode(child, iCodeTop);
                    lastChild = child;
                    child = child.getNext();
                }
                this.itsStackDepth = 0;
                if (finallyTarget != null) {
                    int skippyJumpStart = iCodeTop;
                    iCodeTop = this.addForwardGoto(6, iCodeTop);
                    int finallyOffset = iCodeTop - tryStart;
                    this.recordJumpOffset(tryStart + 3, finallyOffset);
                    this.itsStackDepth = 1;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    int theLocalSlot = this.itsData.itsMaxLocals++;
                    iCodeTop = this.addByte(69, iCodeTop);
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte(57, iCodeTop);
                    iCodeTop = this.addGoto(finallyTarget, 65, iCodeTop);
                    iCodeTop = this.addByte(70, iCodeTop);
                    iCodeTop = this.addByte(theLocalSlot, iCodeTop);
                    iCodeTop = this.addByte(88, iCodeTop);
                    this.itsStackDepth = 0;
                    this.resolveForwardGoto(skippyJumpStart, iCodeTop);
                }
                --this.itsTryDepth;
                break;
            }
            case 62: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(62, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                if (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    iCodeTop = this.addByte(5, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                iCodeTop = this.addByte(151, iCodeTop);
                break;
            }
            case 72: {
                String name = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    iCodeTop = this.addByte(85, iCodeTop);
                    iCodeTop = this.addByte(46, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addByte(39, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte(72, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 73: {
                if (this.itsData.itsNeedsActivation) {
                    child.setType(61);
                    node.setType(10);
                    iCodeTop = this.generateICode(node, iCodeTop);
                    break;
                }
                String name = child.getString();
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                int index = this.itsVariableTable.getOrdinal(name);
                iCodeTop = this.addByte(73, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                break;
            }
            case 109: {
                iCodeTop = this.addByte(node.getOperation(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 79: {
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addByte(79, iCodeTop);
                iCodeTop = this.addLocalRef(node, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 80: {
                iCodeTop = this.addByte(80, iCodeTop);
                Node init = (Node)node.getProp(4);
                iCodeTop = this.addLocalRef(init, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 139: {
                break;
            }
            case 56: {
                int index = node.getExistingIntProp(11);
                iCodeTop = this.addByte(56, iCodeTop);
                iCodeTop = this.addIndex(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        return iCodeTop;
    }

    private int addLocalRef(Node node, int iCodeTop) {
        int theLocalSlot = node.getIntProp(7, -1);
        if (theLocalSlot == -1) {
            theLocalSlot = this.itsData.itsMaxLocals++;
            node.putIntProp(7, theLocalSlot);
        }
        iCodeTop = this.addByte(theLocalSlot, iCodeTop);
        if (theLocalSlot >= this.itsData.itsMaxLocals) {
            this.itsData.itsMaxLocals = theLocalSlot + 1;
        }
        return iCodeTop;
    }

    private int getTargetLabel(Node target) {
        int targetLabel = target.getIntProp(17, -1);
        if (targetLabel == -1) {
            targetLabel = this.itsLabels.acquireLabel();
            target.putIntProp(17, targetLabel);
        }
        return targetLabel;
    }

    private void markTargetLabel(Node target, int iCodeTop) {
        int label = this.getTargetLabel(target);
        this.itsLabels.markLabel(label, iCodeTop);
    }

    private int addGoto(Node target, int gotoOp, int iCodeTop) {
        int targetLabel = this.getTargetLabel(target);
        int gotoPC = iCodeTop;
        iCodeTop = this.addByte(gotoOp, iCodeTop);
        iCodeTop = this.addShort(0, iCodeTop);
        int targetPC = this.itsLabels.getLabelPC(targetLabel);
        if (targetPC != -1) {
            this.recordJumpOffset(gotoPC + 1, targetPC - gotoPC);
        } else {
            this.itsLabels.addLabelFixup(targetLabel, gotoPC + 1);
        }
        return iCodeTop;
    }

    private int addForwardGoto(int gotoOp, int iCodeTop) {
        iCodeTop = this.addByte(gotoOp, iCodeTop);
        iCodeTop = this.addShort(0, iCodeTop);
        return iCodeTop;
    }

    private void resolveForwardGoto(int jumpStart, int iCodeTop) {
        if (jumpStart + 3 > iCodeTop) {
            Context.codeBug();
        }
        int offset = iCodeTop - jumpStart;
        this.recordJumpOffset(jumpStart + 1, offset);
    }

    private void recordJumpOffset(int pos, int offset) {
        if (offset != (short)offset) {
            throw Context.reportRuntimeError0("msg.too.big.jump");
        }
        this.itsData.itsICode[pos] = (byte)(offset >> 8);
        this.itsData.itsICode[pos + 1] = (byte)offset;
    }

    private int addByte(int b, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop == array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 1);
        }
        array[iCodeTop++] = (byte)b;
        return iCodeTop;
    }

    private int addShort(int s, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 2 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 2);
        }
        array[iCodeTop] = (byte)(s >>> 8);
        array[iCodeTop + 1] = (byte)s;
        return iCodeTop + 2;
    }

    private int addIndex(int index, int iCodeTop) {
        if (index < 0) {
            Context.codeBug();
        }
        if (index > 65535) {
            throw Context.reportRuntimeError0("msg.too.big.index");
        }
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 2 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 2);
        }
        array[iCodeTop] = (byte)(index >>> 8);
        array[iCodeTop + 1] = (byte)index;
        return iCodeTop + 2;
    }

    private int addInt(int i, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 4 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 4);
        }
        array[iCodeTop] = (byte)(i >>> 24);
        array[iCodeTop + 1] = (byte)(i >>> 16);
        array[iCodeTop + 2] = (byte)(i >>> 8);
        array[iCodeTop + 3] = (byte)i;
        return iCodeTop + 4;
    }

    private int addDouble(double num, int iCodeTop) {
        int index = this.itsDoubleTableTop;
        if (index == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, na, 0, index);
            this.itsData.itsDoubleTable = na;
        }
        this.itsData.itsDoubleTable[index] = num;
        this.itsDoubleTableTop = index + 1;
        iCodeTop = this.addIndex(index, iCodeTop);
        return iCodeTop;
    }

    private int addString(String str, int iCodeTop) {
        int index = this.itsStrings.get(str, -1);
        if (index == -1) {
            index = this.itsStrings.size();
            this.itsStrings.put(str, index);
        }
        iCodeTop = this.addIndex(index, iCodeTop);
        this.lastAddString = str;
        return iCodeTop;
    }

    private byte[] increaseICodeCapasity(int iCodeTop, int extraSize) {
        int capacity = this.itsData.itsICode.length;
        if (iCodeTop + extraSize <= capacity) {
            Context.codeBug();
        }
        if (iCodeTop + extraSize > (capacity *= 2)) {
            capacity = iCodeTop + extraSize;
        }
        byte[] array = new byte[capacity];
        System.arraycopy(this.itsData.itsICode, 0, array, 0, iCodeTop);
        this.itsData.itsICode = array;
        return array;
    }

    private static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    private static int getTarget(byte[] iCode, int pc) {
        int displacement = Interpreter.getShort(iCode, pc);
        return pc - 1 + displacement;
    }

    private static String icodeToName(int icode) {
        return "";
    }

    private static void dumpICode(InterpreterData idata) {
    }

    private static int icodeTokenLength(int icodeToken) {
        switch (icodeToken) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 74: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 148: 
            case 151: 
            case 152: {
                return 1;
            }
            case 6: 
            case 7: 
            case 8: 
            case 65: {
                return 3;
            }
            case 75: {
                return 5;
            }
            case 59: 
            case 60: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 79: 
            case 80: {
                return 2;
            }
            case 67: {
                return 7;
            }
            case 56: {
                return 3;
            }
            case 55: {
                return 3;
            }
            case 30: 
            case 43: {
                return 5;
            }
            case 149: {
                return 3;
            }
            case 150: {
                return 5;
            }
            case 45: {
                return 3;
            }
            case 10: 
            case 33: 
            case 36: 
            case 44: 
            case 46: 
            case 61: 
            case 71: 
            case 78: {
                return 3;
            }
            case 147: {
                return 3;
            }
        }
        Context.codeBug();
        return 0;
    }

    static int[] getLineNumbers(InterpreterData data) {
        UintMap presentLines = new UintMap();
        int iCodeLength = data.itsICodeTop;
        byte[] iCode = data.itsICode;
        int pc = 0;
        while (pc != iCodeLength) {
            int icodeToken = iCode[pc] & 0xFF;
            int icodeLength = Interpreter.icodeTokenLength(icodeToken);
            if (icodeToken == 147) {
                if (icodeLength != 3) {
                    Context.codeBug();
                }
                int line = Interpreter.getShort(iCode, pc + 1);
                presentLines.put(line, 0);
            }
            pc += icodeLength;
        }
        return presentLines.getKeys();
    }

    static Object getSourcesTree(InterpreterData idata) {
        InterpreterData[] nested = idata.itsNestedFunctions;
        if (nested == null || nested.length == 0) {
            return idata.itsSource;
        }
        int N = nested.length;
        Object[] result = new Object[N + 1];
        result[0] = idata.itsSource;
        int i = 0;
        while (i != N) {
            result[1 + i] = Interpreter.getSourcesTree(nested[i]);
            ++i;
        }
        return result;
    }

    private static InterpretedFunction createFunction(Context cx, Scriptable scope, InterpreterData idata, boolean fromEvalCode) {
        InterpretedFunction fn = new InterpretedFunction(cx, idata);
        if (cx.hasCompileFunctionsWithDynamicScope() && !(scope instanceof NativeCall) && !(scope instanceof NativeWith)) {
            fn.itsUseDynamicScope = true;
        }
        ScriptRuntime.initFunction(cx, scope, fn, idata.itsFunctionType, fromEvalCode);
        return fn;
    }

    static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, double[] argsDbl, int argShift, int argCount, NativeFunction fnOrScript, InterpreterData idata) throws JavaScriptException {
        int pc;
        if (cx.interpreterSecurityDomain != idata.securityDomain) {
            return Interpreter.execWithNewDomain(cx, scope, thisObj, args, argsDbl, argShift, argCount, fnOrScript, idata);
        }
        Object DBL_MRK = Interpreter.DBL_MRK;
        Scriptable undefined = Undefined.instance;
        boolean VAR_SHFT = false;
        int maxFrameArray = idata.itsMaxFrameArray;
        int maxVars = idata.itsMaxVars;
        int LOCAL_SHFT = 0 + maxVars;
        int TRY_STACK_SHFT = LOCAL_SHFT + idata.itsMaxLocals;
        int STACK_SHFT = TRY_STACK_SHFT + idata.itsMaxTryDepth;
        if (maxFrameArray != STACK_SHFT + idata.itsMaxStack) {
            Context.codeBug();
        }
        Object[] stack = new Object[maxFrameArray];
        double[] sDbl = new double[maxFrameArray];
        int stackTop = STACK_SHFT - 1;
        int tryStackTop = 0;
        int definedArgs = fnOrScript.argCount;
        if (definedArgs > argCount) {
            definedArgs = argCount;
        }
        int i = 0;
        while (i != definedArgs) {
            Object arg;
            stack[0 + i] = arg = args[argShift + i];
            if (arg == DBL_MRK) {
                sDbl[0 + i] = argsDbl[argShift + i];
            }
            ++i;
        }
        int i2 = definedArgs;
        while (i2 != maxVars) {
            stack[0 + i2] = undefined;
            ++i2;
        }
        DebugFrame debuggerFrame = null;
        if (cx.debugger != null) {
            debuggerFrame = cx.debugger.getFrame(cx, idata);
        }
        if (idata.itsFunctionType != 0) {
            InterpretedFunction f = (InterpretedFunction)fnOrScript;
            if (!f.itsUseDynamicScope) {
                scope = fnOrScript.getParentScope();
            }
            if (idata.itsCheckThis) {
                thisObj = ScriptRuntime.getThis(thisObj);
            }
            if (idata.itsNeedsActivation) {
                if (argsDbl != null) {
                    args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
                    argShift = 0;
                    argsDbl = null;
                }
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
        } else {
            scope = ScriptRuntime.initScript(cx, scope, fnOrScript, thisObj, idata.itsFromEvalCode);
        }
        if (idata.itsNestedFunctions != null) {
            if (idata.itsFunctionType != 0 && !idata.itsNeedsActivation) {
                Context.codeBug();
            }
            int i3 = 0;
            while (i3 < idata.itsNestedFunctions.length) {
                InterpreterData fdata = idata.itsNestedFunctions[i3];
                if (fdata.itsFunctionType == 1) {
                    Interpreter.createFunction(cx, scope, fdata, idata.itsFromEvalCode);
                }
                ++i3;
            }
        }
        boolean useActivationVars = false;
        if (debuggerFrame != null) {
            if (argsDbl != null) {
                args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
                argShift = 0;
                argsDbl = null;
            }
            if (idata.itsFunctionType != 0 && !idata.itsNeedsActivation) {
                useActivationVars = true;
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
            debuggerFrame.onEnter(cx, scope, thisObj, args);
        }
        Object result = undefined;
        byte[] iCode = idata.itsICode;
        String[] strings = idata.itsStringTable;
        int pcPrevBranch = pc = 0;
        int instructionThreshold = cx.instructionThreshold;
        int instructionCount = cx.instructionCount;
        int INVOCATION_COST = 100;
        block100: while (true) {
            try {
                block101: while (true) {
                    switch (iCode[pc] & 0xFF) {
                        case 76: {
                            --tryStackTop;
                            break block101;
                        }
                        case 75: {
                            stack[TRY_STACK_SHFT + tryStackTop] = scope;
                            sDbl[TRY_STACK_SHFT + tryStackTop] = pc;
                            ++tryStackTop;
                            pc += 4;
                            break block101;
                        }
                        case 19: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 17: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 18: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 16: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 63: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.in(lhs, rhs, scope)) ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 64: {
                            boolean valBln;
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.instanceOf(scope, lhs, rhs)) ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 14: {
                            boolean valBln = Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 15: {
                            boolean valBln = !Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 53: {
                            boolean valBln = Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 54: {
                            boolean valBln = !Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break block101;
                        }
                        case 8: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? !ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) != valDbl || valDbl == 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block101;
                            }
                            pc += 2;
                            break block101;
                        }
                        case 7: {
                            double valDbl;
                            Object val = stack[stackTop];
                            boolean valBln = val != DBL_MRK ? ScriptRuntime.toBoolean(val) : (valDbl = sDbl[stackTop]) == valDbl && valDbl != 0.0;
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block101;
                            }
                            pc += 2;
                            break block101;
                        }
                        case 6: {
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block101;
                        }
                        case 65: {
                            sDbl[++stackTop] = pc + 3;
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block101;
                        }
                        case 66: {
                            int slot = iCode[pc + 1] & 0xFF;
                            if (instructionThreshold != 0 && (instructionCount += pc + 2 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = (int)sDbl[LOCAL_SHFT + slot];
                            continue block101;
                        }
                        case 57: {
                            --stackTop;
                            break block101;
                        }
                        case 9: {
                            stack[stackTop + 1] = stack[stackTop];
                            sDbl[stackTop + 1] = sDbl[stackTop];
                            ++stackTop;
                            break block101;
                        }
                        case 2: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break block101;
                        }
                        case 5: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break block100;
                        }
                        case 151: {
                            result = undefined;
                            break block100;
                        }
                        case 152: {
                            break block100;
                        }
                        case 28: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ~rIntValue;
                            break block101;
                        }
                        case 13: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue & rIntValue;
                            break block101;
                        }
                        case 11: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue | rIntValue;
                            break block101;
                        }
                        case 12: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue ^ rIntValue;
                            break block101;
                        }
                        case 20: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue << rIntValue;
                            break block101;
                        }
                        case 21: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue >> rIntValue;
                            break block101;
                        }
                        case 22: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop) & 0x1F;
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                            break block101;
                        }
                        case 23: {
                            Interpreter.do_add(stack, sDbl, --stackTop);
                            break block101;
                        }
                        case 24: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl - rDbl;
                            break block101;
                        }
                        case 29: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = -rDbl;
                            break block101;
                        }
                        case 58: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = rDbl;
                            break block101;
                        }
                        case 25: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl * rDbl;
                            break block101;
                        }
                        case 26: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl / rDbl;
                            break block101;
                        }
                        case 27: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl % rDbl;
                            break block101;
                        }
                        case 61: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.bind(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 71: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.getBase(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 10: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Scriptable lhs = (Scriptable)stack[--stackTop];
                            stack[stackTop] = ScriptRuntime.setName(lhs, rhs, scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 31: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.delete(lhs, rhs);
                            break block101;
                        }
                        case 39: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            } else if (lhs == undefined) {
                                int j = pc - 6;
                                while (j > 0 && iCode[j] != 0) {
                                    --j;
                                }
                                int i4 = Interpreter.getShort(iCode, j);
                                if (i4 >= 0 && i4 < strings.length) {
                                    lhs = strings[i4];
                                    throw NativeGlobal.typeError1("msg.is.not.defined", ScriptRuntime.toString(lhs), scope);
                                }
                            }
                            stack[stackTop] = ScriptRuntime.getProp(lhs, name, scope);
                            break block101;
                        }
                        case 40: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            String name = (String)stack[--stackTop];
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProp(lhs, name, rhs, scope);
                            break block101;
                        }
                        case 41: {
                            Interpreter.do_getElem(cx, stack, sDbl, stackTop, scope);
                            --stackTop;
                            break block101;
                        }
                        case 42: {
                            Interpreter.do_setElem(cx, stack, sDbl, stackTop, scope);
                            stackTop -= 2;
                            break block101;
                        }
                        case 34: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrement(lhs, name, scope);
                            break block101;
                        }
                        case 37: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrement(lhs, name, scope);
                            break block101;
                        }
                        case 35: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, scope);
                            break block101;
                        }
                        case 38: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, scope);
                            break block101;
                        }
                        case 68: {
                            Scriptable lhs = (Scriptable)stack[stackTop];
                            stack[stackTop] = ScriptRuntime.getThis(lhs);
                            break block101;
                        }
                        case 69: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[LOCAL_SHFT + slot] = stack[stackTop];
                            sDbl[LOCAL_SHFT + slot] = sDbl[stackTop];
                            break block101;
                        }
                        case 70: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[LOCAL_SHFT + slot];
                            sDbl[stackTop] = sDbl[LOCAL_SHFT + slot];
                            break block101;
                        }
                        case 67: {
                            Object lhs;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int lineNum = Interpreter.getShort(iCode, pc + 1);
                            String name = strings[Interpreter.getIndex(iCode, pc + 3)];
                            int count = Interpreter.getIndex(iCode, pc + 5);
                            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, (stackTop -= count) + 1, count);
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.callSpecial(cx, lhs, rhs, outArgs, thisObj, scope, name, lineNum);
                            pc += 6;
                            instructionCount = cx.instructionCount;
                            break block101;
                        }
                        case 43: {
                            Function f;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            cx.instructionCount = instructionCount;
                            int count = Interpreter.getIndex(iCode, pc + 3);
                            int calleeArgShft = (stackTop -= count) + 1;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Object lhs = stack[--stackTop];
                            Scriptable calleeScope = scope;
                            if (idata.itsNeedsActivation) {
                                calleeScope = ScriptableObject.getTopLevelScope(scope);
                            }
                            Scriptable calleeThis = rhs instanceof Scriptable || rhs == null ? (Scriptable)rhs : ScriptRuntime.toObject(cx, calleeScope, rhs);
                            if (lhs instanceof InterpretedFunction) {
                                f = (InterpretedFunction)lhs;
                                stack[stackTop] = Interpreter.interpret(cx, calleeScope, calleeThis, stack, sDbl, calleeArgShft, count, (NativeFunction)f, ((InterpretedFunction)f).itsData);
                            } else if (lhs instanceof Function) {
                                f = (Function)lhs;
                                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, calleeArgShft, count);
                                stack[stackTop] = f.call(cx, calleeScope, calleeThis, outArgs);
                            } else {
                                if (lhs == DBL_MRK) {
                                    lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                                } else if (lhs == undefined && (lhs = strings[Interpreter.getIndex(iCode, pc + 1)]) == null) {
                                    lhs = undefined;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(lhs), calleeScope);
                            }
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break block101;
                        }
                        case 30: {
                            Function f;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int count = Interpreter.getIndex(iCode, pc + 3);
                            int calleeArgShft = (stackTop -= count) + 1;
                            Object lhs = stack[stackTop];
                            if (lhs instanceof InterpretedFunction) {
                                f = (InterpretedFunction)lhs;
                                Scriptable newInstance = ((BaseFunction)f).createObject(cx, scope);
                                Object callResult = Interpreter.interpret(cx, scope, newInstance, stack, sDbl, calleeArgShft, count, (NativeFunction)f, ((InterpretedFunction)f).itsData);
                                stack[stackTop] = callResult instanceof Scriptable && callResult != undefined ? callResult : newInstance;
                            } else if (lhs instanceof Function) {
                                f = (Function)lhs;
                                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, calleeArgShft, count);
                                stack[stackTop] = f.construct(cx, scope, outArgs);
                            } else {
                                if (lhs == DBL_MRK) {
                                    lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                                } else if (lhs == undefined && (lhs = strings[Interpreter.getIndex(iCode, pc + 1)]) == null) {
                                    lhs = undefined;
                                }
                                throw NativeGlobal.typeError1("msg.isnt.function", ScriptRuntime.toString(lhs), scope);
                            }
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break block101;
                        }
                        case 32: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.typeof(lhs);
                            break block101;
                        }
                        case 78: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.typeofName(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 46: {
                            stack[++stackTop] = strings[Interpreter.getIndex(iCode, pc + 1)];
                            pc += 2;
                            break block101;
                        }
                        case 149: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getShort(iCode, pc + 1);
                            pc += 2;
                            break block101;
                        }
                        case 150: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getInt(iCode, pc + 1);
                            pc += 4;
                            break block101;
                        }
                        case 45: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = idata.itsDoubleTable[Interpreter.getIndex(iCode, pc + 1)];
                            pc += 2;
                            break block101;
                        }
                        case 44: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.name(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 33: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.postIncrement(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 36: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.postDecrement(scope, name);
                            pc += 2;
                            break block101;
                        }
                        case 73: {
                            int slot = iCode[++pc] & 0xFF;
                            if (!useActivationVars) {
                                stack[0 + slot] = stack[stackTop];
                                sDbl[0 + slot] = sDbl[stackTop];
                                break block101;
                            }
                            Object val = stack[stackTop];
                            if (val == DBL_MRK) {
                                val = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break block101;
                        }
                        case 72: {
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                break block101;
                            }
                            stack[stackTop] = Interpreter.activationGet(fnOrScript, scope, slot);
                            break block101;
                        }
                        case 59: {
                            Object val;
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                stack[0 + slot] = DBL_MRK;
                                sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) + 1.0;
                                break block101;
                            }
                            stack[stackTop] = val = Interpreter.activationGet(fnOrScript, scope, slot);
                            val = Interpreter.doubleWrap(ScriptRuntime.toNumber(val) + 1.0);
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break block101;
                        }
                        case 60: {
                            Object val;
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                stack[0 + slot] = DBL_MRK;
                                sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) - 1.0;
                                break block101;
                            }
                            stack[stackTop] = val = Interpreter.activationGet(fnOrScript, scope, slot);
                            val = Interpreter.doubleWrap(ScriptRuntime.toNumber(val) - 1.0);
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break block101;
                        }
                        case 47: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 0.0;
                            break block101;
                        }
                        case 48: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 1.0;
                            break block101;
                        }
                        case 49: {
                            stack[++stackTop] = null;
                            break block101;
                        }
                        case 50: {
                            stack[++stackTop] = thisObj;
                            break block101;
                        }
                        case 87: {
                            stack[++stackTop] = fnOrScript;
                            break block101;
                        }
                        case 51: {
                            stack[++stackTop] = Boolean.FALSE;
                            break block101;
                        }
                        case 52: {
                            stack[++stackTop] = Boolean.TRUE;
                            break block101;
                        }
                        case 74: {
                            stack[++stackTop] = Undefined.instance;
                            break block101;
                        }
                        case 62: {
                            Object exception = stack[stackTop];
                            if (exception == DBL_MRK) {
                                exception = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            throw new JavaScriptException(exception);
                        }
                        case 88: {
                            Object exception = stack[stackTop];
                            --stackTop;
                            if (exception instanceof JavaScriptException) {
                                throw (JavaScriptException)exception;
                            }
                            throw (RuntimeException)exception;
                        }
                        case 3: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            scope = ScriptRuntime.enterWith(lhs, scope);
                            break block101;
                        }
                        case 4: {
                            scope = ScriptRuntime.leaveWith(scope);
                            break block101;
                        }
                        case 77: {
                            stack[++stackTop] = ScriptRuntime.newScope();
                            break block101;
                        }
                        case 79: {
                            int slot = iCode[++pc] & 0xFF;
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            stack[LOCAL_SHFT + slot] = ScriptRuntime.initEnum(lhs, scope);
                            break block101;
                        }
                        case 80: {
                            int slot = iCode[++pc] & 0xFF;
                            Object val = stack[LOCAL_SHFT + slot];
                            stack[++stackTop] = ScriptRuntime.nextEnum(val);
                            break block101;
                        }
                        case 81: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProto(lhs, scope);
                            break block101;
                        }
                        case 82: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs);
                            break block101;
                        }
                        case 86: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs, scope);
                            break block101;
                        }
                        case 83: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProto(lhs, rhs, scope);
                            break block101;
                        }
                        case 84: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setParent(lhs, rhs, scope);
                            break block101;
                        }
                        case 85: {
                            stack[++stackTop] = scope;
                            break block101;
                        }
                        case 55: {
                            int i5 = Interpreter.getIndex(iCode, pc + 1);
                            InterpreterData closureData = idata.itsNestedFunctions[i5];
                            stack[++stackTop] = Interpreter.createFunction(cx, scope, closureData, idata.itsFromEvalCode);
                            pc += 2;
                            break block101;
                        }
                        case 56: {
                            int i6 = Interpreter.getIndex(iCode, pc + 1);
                            stack[++stackTop] = idata.itsRegExpLiterals[i6];
                            pc += 2;
                            break block101;
                        }
                        case 148: {
                            cx.interpreterSourceFile = idata.itsSourceFile;
                            break block101;
                        }
                        case 147: {
                            int line;
                            cx.interpreterLine = line = Interpreter.getShort(iCode, pc + 1);
                            if (debuggerFrame != null) {
                                debuggerFrame.onLineChange(cx, line);
                            }
                            pc += 2;
                            break block101;
                        }
                        default: {
                            Interpreter.dumpICode(idata);
                            throw new RuntimeException("Unknown icode : " + (iCode[pc] & 0xFF) + " @ pc : " + pc);
                        }
                    }
                    break;
                }
                ++pc;
            }
            catch (Throwable ex) {
                int exType;
                Object catchObj;
                block215: {
                    block216: {
                        if (instructionThreshold != 0) {
                            if (instructionCount < 0) {
                                instructionCount = cx.instructionCount;
                            } else {
                                cx.instructionCount = instructionCount += pc - pcPrevBranch;
                            }
                        }
                        boolean SCRIPT_THROW = false;
                        boolean ECMA = true;
                        int RUNTIME = 2;
                        int OTHER = 3;
                        catchObj = ex;
                        while (true) {
                            Object w;
                            if (catchObj instanceof JavaScriptException) {
                                catchObj = ScriptRuntime.unwrapJavaScriptException((JavaScriptException)catchObj);
                                exType = 0;
                                break block215;
                            }
                            if (catchObj instanceof EcmaError) {
                                catchObj = ((EcmaError)catchObj).getErrorObject();
                                exType = 1;
                                break block215;
                            }
                            if (!(catchObj instanceof RuntimeException)) break block216;
                            if (!(catchObj instanceof WrappedException) || !((w = ((WrappedException)catchObj).unwrap()) instanceof Throwable)) break;
                            ex = (Throwable)w;
                            catchObj = ex;
                        }
                        catchObj = null;
                        exType = 2;
                        break block215;
                    }
                    catchObj = null;
                    exType = 3;
                }
                if (exType != 3 && debuggerFrame != null) {
                    debuggerFrame.onExceptionThrown(cx, ex);
                }
                boolean rethrow = true;
                if (exType != 3 && tryStackTop > 0) {
                    int finally_offset;
                    int catch_offset;
                    int try_pc = (int)sDbl[TRY_STACK_SHFT + --tryStackTop];
                    if ((exType == 0 || exType == 1) && (catch_offset = Interpreter.getShort(iCode, try_pc + 1)) != 0) {
                        rethrow = false;
                        pc = try_pc + catch_offset;
                        stackTop = STACK_SHFT;
                        stack[stackTop] = catchObj;
                    }
                    if (rethrow && (finally_offset = Interpreter.getShort(iCode, try_pc + 3)) != 0) {
                        rethrow = false;
                        pc = try_pc + finally_offset;
                        stackTop = STACK_SHFT;
                        stack[stackTop] = ex;
                    }
                }
                if (rethrow) {
                    if (debuggerFrame != null) {
                        debuggerFrame.onExit(cx, true, ex);
                    }
                    if (idata.itsNeedsActivation) {
                        ScriptRuntime.popActivation(cx);
                    }
                    if (exType == 0) {
                        throw (JavaScriptException)ex;
                    }
                    if (exType == 1 || exType == 2) {
                        throw (RuntimeException)ex;
                    }
                    throw (Error)ex;
                }
                if (instructionThreshold != 0 && instructionCount > instructionThreshold) {
                    cx.observeInstructionCount(instructionCount);
                    instructionCount = 0;
                }
                pcPrevBranch = pc;
                scope = (Scriptable)stack[TRY_STACK_SHFT + tryStackTop];
            }
        }
        if (debuggerFrame != null) {
            debuggerFrame.onExit(cx, false, result);
        }
        if (idata.itsNeedsActivation) {
            ScriptRuntime.popActivation(cx);
        }
        if (instructionThreshold != 0) {
            if (instructionCount > instructionThreshold) {
                cx.observeInstructionCount(instructionCount);
                instructionCount = 0;
            }
            cx.instructionCount = instructionCount;
        }
        return result;
    }

    private static Object doubleWrap(double x) {
        return new Double(x);
    }

    private static int stack_int32(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toInt32(x) : ScriptRuntime.toInt32(stackDbl[i]);
    }

    private static double stack_double(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toNumber(x) : stackDbl[i];
    }

    private static void do_add(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                int n = stackTop;
                stackDbl[n] = stackDbl[n] + rDbl;
            } else {
                Interpreter.do_add(lhs, rDbl, stack, stackDbl, stackTop, true);
            }
        } else if (lhs == DBL_MRK) {
            Interpreter.do_add(rhs, stackDbl[stackTop], stack, stackDbl, stackTop, false);
        } else {
            if (lhs instanceof Scriptable) {
                lhs = ((Scriptable)lhs).getDefaultValue(null);
            }
            if (rhs instanceof Scriptable) {
                rhs = ((Scriptable)rhs).getDefaultValue(null);
            }
            if (lhs instanceof String || rhs instanceof String) {
                stack[stackTop] = ScriptRuntime.toString(lhs) + ScriptRuntime.toString(rhs);
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(rhs);
                stack[stackTop] = DBL_MRK;
                stackDbl[stackTop] = lDbl + rDbl;
            }
        }
    }

    private static void do_add(Object lhs, double rDbl, Object[] stack, double[] stackDbl, int stackTop, boolean left_right_order) {
        if (lhs instanceof Scriptable) {
            lhs = lhs == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)lhs).getDefaultValue(null);
        }
        if (lhs instanceof String) {
            stack[stackTop] = left_right_order ? (String)lhs + ScriptRuntime.toString(rDbl) : ScriptRuntime.toString(rDbl) + (String)lhs;
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
            stack[stackTop] = DBL_MRK;
            stackDbl[stackTop] = lDbl + rDbl;
        }
    }

    private static boolean do_eq(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        boolean result = rhs == DBL_MRK ? (lhs == DBL_MRK ? stackDbl[stackTop] == stackDbl[stackTop + 1] : Interpreter.do_eq(stackDbl[stackTop + 1], lhs)) : (lhs == DBL_MRK ? Interpreter.do_eq(stackDbl[stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
        return result;
    }

    private static boolean do_eq(double x, Object y) {
        while (true) {
            if (y instanceof Number) {
                return x == ((Number)y).doubleValue();
            }
            if (y instanceof String) {
                return x == ScriptRuntime.toNumber((String)y);
            }
            if (y instanceof Boolean) {
                return x == ((Boolean)y != false ? 1.0 : 0.0);
            }
            if (!(y instanceof Scriptable)) break;
            if (y == Undefined.instance) {
                return false;
            }
            y = ScriptRuntime.toPrimitive(y);
        }
        return false;
    }

    private static boolean do_sheq(Object[] stack, double[] stackDbl, int stackTop) {
        boolean result;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else if (rhs instanceof Number) {
            double rDbl = ((Number)rhs).doubleValue();
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else {
            result = ScriptRuntime.shallowEq(lhs, rhs);
        }
        return result;
    }

    private static void do_getElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs = stack[stackTop - 1];
        if (lhs == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 1]);
        }
        if ((id = stack[stackTop]) != DBL_MRK) {
            result = ScriptRuntime.getElem(lhs, id, scope);
        } else {
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            double val = stackDbl[stackTop];
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.getElem(obj, index);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.getStrIdElem(obj, s);
            }
        }
        stack[stackTop - 1] = result;
    }

    private static void do_setElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            rhs = Interpreter.doubleWrap(stackDbl[stackTop]);
        }
        if ((lhs = stack[stackTop - 2]) == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 2]);
        }
        if ((id = stack[stackTop - 1]) != DBL_MRK) {
            result = ScriptRuntime.setElem(lhs, id, rhs, scope);
        } else {
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            double val = stackDbl[stackTop - 1];
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.setElem(obj, index, rhs);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.setStrIdElem(obj, s, rhs, scope);
            }
        }
        stack[stackTop - 2] = result;
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, int shift, int count) {
        if (count == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] args = new Object[count];
        int i = 0;
        while (i != count) {
            Object val = stack[shift];
            if (val == DBL_MRK) {
                val = Interpreter.doubleWrap(sDbl[shift]);
            }
            args[i] = val;
            ++i;
            ++shift;
        }
        return args;
    }

    private static Object activationGet(NativeFunction f, Scriptable activation, int slot) {
        String name = f.argNames[slot];
        Object val = activation.get(name, activation);
        if (val == Scriptable.NOT_FOUND) {
            Context.codeBug();
        }
        return val;
    }

    private static void activationPut(NativeFunction f, Scriptable activation, int slot, Object value) {
        String name = f.argNames[slot];
        activation.put(name, activation, value);
    }

    private static Object execWithNewDomain(Context cx, Scriptable scope, final Scriptable thisObj, final Object[] args, final double[] argsDbl, final int argShift, final int argCount, final NativeFunction fnOrScript, final InterpreterData idata) throws JavaScriptException {
        if (cx.interpreterSecurityDomain == idata.securityDomain) {
            Context.codeBug();
        }
        Script code = new Script(){

            public Object exec(Context cx, Scriptable scope) throws JavaScriptException {
                return Interpreter.interpret(cx, scope, thisObj, args, argsDbl, argShift, argCount, fnOrScript, idata);
            }
        };
        Object savedDomain = cx.interpreterSecurityDomain;
        cx.interpreterSecurityDomain = idata.securityDomain;
        try {
            Object object = cx.getSecurityController().execWithDomain(cx, scope, code, idata.securityDomain);
            Object var13_12 = null;
            cx.interpreterSecurityDomain = savedDomain;
            return object;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            cx.interpreterSecurityDomain = savedDomain;
            throw throwable;
        }
    }

    static {
        DBL_MRK = new Object();
    }
}

