/*
 * Decompiled with CFR 0.152.
 */
package imagelib.io.dicom;

import java.io.BufferedOutputStream;
import java.io.IOException;

public class Util {
    public static final boolean DEBUG = false;
    public static int BYTE0_MASK = 255;
    public static int BYTE1_MASK = 65280;
    public static int BYTE2_MASK = 0xFF0000;
    public static int BYTE3_MASK = -16777216;
    public static final int AE = 16709;
    public static final int AS = 16723;
    public static final int AT = 16724;
    public static final int CS = 17235;
    public static final int DA = 17473;
    public static final int DS = 17491;
    public static final int DT = 17492;
    public static final int FD = 17988;
    public static final int FL = 17996;
    public static final int IS = 18771;
    public static final int LO = 19535;
    public static final int LT = 19540;
    public static final int PN = 20558;
    public static final int SH = 21320;
    public static final int SL = 21324;
    public static final int SS = 21331;
    public static final int ST = 21332;
    public static final int TM = 21581;
    public static final int UI = 21833;
    public static final int UL = 21836;
    public static final int US = 21843;
    public static final int UT = 21844;
    public static final int OB = 20290;
    public static final int OW = 20311;
    public static final int SQ = 21329;
    public static final int UN = 21838;
    public static final int QQ = 16191;
    public static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static int bytesWritten = 0;

    protected Util() {
    }

    public static void resetByteCount() {
        bytesWritten = 0;
    }

    public static void dumpOffsets(String desc, int bytesRead) {
    }

    public static int[] convertVRAndLength(int vr, int length, boolean explicit, boolean littleEndian) {
        switch (vr) {
            case 20290: 
            case 20311: 
            case 21329: 
            case 21838: {
                if (explicit) {
                    int[] buf = new int[8];
                    int[] buf1 = Util.convertShortToBytes(vr, true);
                    System.arraycopy(buf1, 0, buf, 0, buf1.length);
                    buf1 = Util.convertIntToBytes(length, littleEndian);
                    System.arraycopy(buf1, 0, buf, 4, buf1.length);
                    return buf;
                }
                return Util.convertIntToBytes(length, littleEndian);
            }
            case 16191: 
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 17988: 
            case 17996: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21324: 
            case 21331: 
            case 21332: 
            case 21581: 
            case 21833: 
            case 21836: 
            case 21843: 
            case 21844: {
                int[] vrBuf = Util.convertShortToBytes(vr, true);
                int[] lengthBuf = Util.convertShortToBytes(length, littleEndian);
                int[] buf = new int[4];
                System.arraycopy(vrBuf, 0, buf, 0, vrBuf.length);
                System.arraycopy(lengthBuf, 0, buf, vrBuf.length, lengthBuf.length);
                return buf;
            }
        }
        return Util.convertIntToBytes(length, littleEndian);
    }

    public static void writeVRAndLength(int vr, int length, boolean explicit, boolean littleEndian, BufferedOutputStream out) throws IOException {
        int[] buf = Util.convertVRAndLength(vr, length, explicit, littleEndian);
        int i = 0;
        while (i < buf.length) {
            out.write(buf[i]);
            ++i;
        }
        bytesWritten += buf.length;
    }

    public static int[] convertIntToBytes(int value, boolean littleEndian) {
        int[] buf = new int[4];
        if (littleEndian) {
            buf[0] = value & BYTE0_MASK;
            buf[1] = (value & BYTE1_MASK) >> 8;
            buf[2] = (value & BYTE2_MASK) >> 16;
            buf[3] = (value & BYTE3_MASK) >> 24;
        } else {
            buf[0] = (value & BYTE3_MASK) >> 24;
            buf[1] = (value & BYTE2_MASK) >> 16;
            buf[2] = (value & BYTE1_MASK) >> 8;
            buf[3] = value & BYTE0_MASK;
        }
        return buf;
    }

    public static int[] convertUIntToBytes(long value, boolean littleEndian) {
        int[] buf = new int[4];
        if (littleEndian) {
            buf[0] = (int)(value & (long)BYTE0_MASK);
            buf[1] = (int)((value & (long)BYTE1_MASK) >> 8);
            buf[2] = (int)((value & (long)BYTE2_MASK) >> 16);
            buf[3] = (int)((value & (long)BYTE3_MASK) >> 24);
        } else {
            buf[0] = (int)((value & (long)BYTE3_MASK) >> 24);
            buf[1] = (int)((value & (long)BYTE2_MASK) >> 16);
            buf[2] = (int)((value & (long)BYTE1_MASK) >> 8);
            buf[3] = (int)(value & (long)BYTE0_MASK);
        }
        return buf;
    }

    public static int getIntValue(int[] buf, boolean littleEndian) {
        if (littleEndian) {
            return (buf[3] << 24) + (buf[2] << 16) + (buf[1] << 8) + buf[0];
        }
        return (buf[0] << 24) + (buf[1] << 16) + (buf[2] << 8) + buf[3];
    }

    public static int getUnsignedShortValue(int[] buf, boolean littleEndian) {
        if (littleEndian) {
            return (buf[1] << 8) + buf[0];
        }
        return (buf[0] << 8) + buf[1];
    }

    public static int writeShort(int value, BufferedOutputStream out, boolean littleEndian) throws IOException {
        int[] buf = Util.convertShortToBytes(value, littleEndian);
        out.write(buf[0]);
        out.write(buf[1]);
        bytesWritten += 2;
        return 2;
    }

    public static int writeInt(int value, BufferedOutputStream out, boolean littleEndian) throws IOException {
        int[] buf = Util.convertIntToBytes(value, littleEndian);
        out.write(buf[0]);
        out.write(buf[1]);
        out.write(buf[2]);
        out.write(buf[3]);
        bytesWritten += 4;
        return 4;
    }

    public static int writeUInt(long value, BufferedOutputStream out, boolean littleEndian) throws IOException {
        int[] buf = Util.convertUIntToBytes(value, littleEndian);
        out.write(buf[0]);
        out.write(buf[1]);
        out.write(buf[2]);
        out.write(buf[3]);
        bytesWritten += 4;
        return 4;
    }

    public static int[] convertShortToBytes(int value, boolean littleEndian) {
        int[] buf = new int[2];
        if (littleEndian) {
            buf[0] = value & BYTE0_MASK;
            buf[1] = (value & BYTE1_MASK) >> 8;
        } else {
            buf[0] = (value & BYTE1_MASK) >> 8;
            buf[1] = value & BYTE0_MASK;
        }
        return buf;
    }

    public static void writeByte(int b, BufferedOutputStream out) throws IOException {
        out.write(b);
        ++bytesWritten;
    }

    public static void writeBytes(int[] buf, int len, BufferedOutputStream out) throws IOException {
        if (len > 0 && buf.length >= len) {
            int i = 0;
            while (i < len) {
                Util.writeByte(buf[i], out);
                ++i;
            }
        }
    }

    public static void writeBytes(byte[] buf, BufferedOutputStream out) throws IOException {
        out.write(buf);
        bytesWritten += buf.length;
    }

    public static int writeString(String s, BufferedOutputStream out) throws IOException {
        byte[] buf = s.getBytes("US-ASCII");
        out.write(buf);
        bytesWritten += buf.length;
        return buf.length;
    }

    public static int writeDICOMTag(int tag, BufferedOutputStream out) throws IOException {
        out.write((tag & BYTE2_MASK) >> 16);
        out.write((tag & BYTE3_MASK) >> 24);
        out.write(tag & BYTE0_MASK);
        out.write((tag & BYTE1_MASK) >> 8);
        bytesWritten += 4;
        return 4;
    }

    public static String tag2Hex(int tag) {
        char[] buf10 = new char[11];
        buf10[4] = 44;
        buf10[9] = 32;
        int pos = 8;
        while (pos >= 0) {
            buf10[pos] = hexDigits[tag & 0xF];
            tag >>>= 4;
            if (--pos != 4) continue;
            --pos;
        }
        return new String(buf10);
    }

    public static String int2Hex(int i) {
        char[] buf8 = new char[8];
        int pos = 7;
        while (pos >= 0) {
            buf8[pos] = hexDigits[i & 0xF];
            i >>>= 4;
            --pos;
        }
        return new String(buf8);
    }

    public static int hex2Tag(String hexStr) {
        String groupWordStr = hexStr.substring(0, 4);
        String elemWordStr = hexStr.substring(4);
        int groupWord = Integer.parseInt(groupWordStr, 16);
        int elemWord = Integer.parseInt(elemWordStr, 16);
        return groupWord << 16 | elemWord;
    }

    public static int tagCompare(int curTag, int tag) {
        int groupWord = tag & 0xFFFF0000;
        int curGroupWord = curTag & 0xFFFF0000;
        if (groupWord == curGroupWord) {
            int elem = tag & 0xFFFF;
            int curElem = curTag & 0xFFFF;
            if (elem > curElem) {
                return 1;
            }
            if (elem < curElem) {
                return -1;
            }
            return 0;
        }
        if (groupWord > curGroupWord) {
            return 1;
        }
        return -1;
    }

    public static void writeDICOMHeaderValue(BufferedOutputStream out, String value, int vr, int length, boolean littleEndian) throws IOException {
        String valueStr = null;
        switch (vr) {
            case 16709: 
            case 16723: 
            case 16724: 
            case 17235: 
            case 17473: 
            case 17491: 
            case 17492: 
            case 18771: 
            case 19535: 
            case 19540: 
            case 20558: 
            case 21320: 
            case 21332: 
            case 21581: 
            case 21833: {
                int len = value.length();
                valueStr = value;
                if (len % 2 != 0) {
                    valueStr = String.valueOf(valueStr) + " ";
                    ++len;
                }
                Util.writeString(valueStr, out);
                break;
            }
            case 21843: {
                if (length == 2) {
                    Util.writeShort(Integer.parseInt(value), out, littleEndian);
                    break;
                }
                throw new UnsupportedOperationException("element length must be 2 for US!");
            }
            case 21836: {
                if (length == 4) {
                    Util.writeUInt(Long.parseLong(value), out, littleEndian);
                    break;
                }
                throw new UnsupportedOperationException("element length must be 4 for UL!");
            }
            default: {
                throw new RuntimeException("Not supported vr:" + vr);
            }
        }
    }

    public static void testTagCompare() {
        int groupWord = 24;
        int elemWord = 4512;
        int elemWord2 = 4514;
        int tag1 = groupWord << 16 | elemWord;
        int tag2 = groupWord << 16 | elemWord2;
        Util.tagCompare(tag1, tag2);
        int tag = Util.hex2Tag("00020010");
        System.out.println(Util.tag2Hex(tag));
    }

    public static int test(int[] buf) {
        buf = new int[6];
        int i = 0;
        while (i < buf.length) {
            buf[i] = i + 1;
            ++i;
        }
        return buf.length;
    }

    public static void main(String[] args) {
        Util.testTagCompare();
    }
}

