/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.ArraySorter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Misc {
    private static Format monthFormat = new SimpleDateFormat("MM");
    private static Format dayOfWeekFormat = new SimpleDateFormat("E");
    private static Format shortDateFormat = new SimpleDateFormat("MM/dd/yy");

    public static String getClassName(Object object) {
        String className = object == null ? "null" : object.getClass().getName();
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static String getDayOfWeek() {
        return Misc.getDayOfWeek(new Date());
    }

    public static String getDayOfWeek(Date date) {
        return dayOfWeekFormat.format(date);
    }

    public static String getFormattedDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getFormattedDateNow(String format) {
        return Misc.getFormattedDate(format, new Date());
    }

    public static String getMonth() {
        return Misc.getMonth(new Date());
    }

    public static String getMonth(Date date) {
        return monthFormat.format(date);
    }

    public static String getShortDate() {
        return Misc.getShortDate(new Date());
    }

    public static String getShortDate(Date date) {
        return shortDateFormat.format(date);
    }

    public static void isObjectString(Object arg) {
        if (!(arg instanceof String)) {
            throw new IllegalArgumentException("Illegal Argument exception: This object must be of type String.");
        }
    }

    public static void main(String[] args) {
        Date date = new Date();
        System.out.println("month=" + Misc.getMonth(date));
        System.out.println("dayofweek=" + Misc.getDayOfWeek(date));
        System.out.println("shortdate=" + Misc.getShortDate(date));
        System.out.println("formatteddate=" + Misc.getFormattedDate("dd-MMM-yy", date));
        System.out.println("month=" + Misc.getMonth());
        System.out.println("dayofweek=" + Misc.getDayOfWeek());
        System.out.println("shortdate=" + Misc.getShortDate());
        SimpleDateFormat formatter = new SimpleDateFormat("yy");
        System.out.println("yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("yyyy");
        System.out.println("yyyy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("M");
        System.out.println("M=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MM");
        System.out.println("MM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MMM");
        System.out.println("MMM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MMMM");
        System.out.println("MMMM=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("d");
        System.out.println("d=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("dd");
        System.out.println("dd=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("E");
        System.out.println("E=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("EEEE");
        System.out.println("EEEE=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("MM/dd/yy");
        System.out.println("MM/dd/yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("dd-MMM-yy");
        System.out.println("dd-MMM-yy=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
        System.out.println("yyyy.MM.dd.HH.mm.ss=" + formatter.format((Object)date));
        formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
        System.out.println("E, dd MMM yyyy HH:mm:ss Z=" + formatter.format((Object)date));
    }

    public static Object[][] sort(Object[][] array, int sortCol, String sortOrder) {
        ArraySorter sorter = new ArraySorter(array, sortCol, sortOrder);
        return sorter.sort();
    }
}

