#include <stdio.h>

#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include <dirent.h>
#define MAX_PATH_LEN 256
#define MAX_CMD_PATH_LEN 2048
#define DESCEND_DIRS  1
#define NO_DESCEND   0
#ifndef WIN
#  define UNIX
#endif

#define MIN(A,B) A<B?A:B
#define JPATHS_SIZE 10
#define TPATHS_SIZE 6
#define STRING_SIZE 256
#ifdef WIN
#  define FILE_SEPARATOR "\\"
#  define JVIEW_INDEX 7

#  define PATH_SEPARATOR ";"

   /* binary sought */
#  define JAVA_BINARY "java.exe"

   /* Directories to descend looking for binary.
      Directories having names that begin with
      the following will be searched (e.g.,
      JavaSoft will be searched). Tests are case
      insensitive. */
#  define DESCENDDIR { "java", "jdk", "j2re", "j2sdk", "jre","sdk","SUNsdk","SUNjdk" }

   /* length of list of directories to descend */
#  define DESCENDLEN 5

  /* places to look for directories to descend */
#  define CHECKDIR { "C:\\", "C:\\Program Files" }

  /* length of list of places to look for directories to
     descend */
#  define CHECKLEN 2

  /* The following have no counterpart in unix */
#  define JVIEW_BINARY "jview.exe"

  /* Directories to descend looking for jview.exe binary.
     Directories having names that begin with
     the following will be searched (e.g.,
     WindowsStuff would be searched if it existed). Tests
     are case insensitive. */
#  define DESCEND_JVIEW { "windows", "winnt" }

  /* length of list of directories to descend */
#  define DESCEND_JVIEW_LEN 2

  /* places to look for directories to descend */
#  define CHECK_JVIEW { "C:\\" }
   /* length of list of places to look for directories to descend */
#  define CHECK_JVIEW_LEN 1
#else
#  define FILE_SEPARATOR "/"
#  define PATH_SEPARATOR ":"

  /* binary sought */
#  define JAVA_BINARY "java"

   /* Directories to descend looking for binary.
      Directories having names that begin with
      the following will be searched (e.g.,
      JavaSoft will be searched). Tests are case
      insensitive. */
#  define DESCENDDIR { "java", "jdk", "j2re", "j2sdk", "jre", "sdk", "bin","SUNjdk","SUNsdk"}

   /* length of list of directories to descend */
#  define DESCENDLEN 7

  /* places to look for directories to descend */
#  define CHECKDIR { "/usr", "/usr/lib", "/usr/local", "/usr/local/lib", "/share", "/usr/share", "/usr/local/share", "/opt" }
  /* length of list of places to look for directories to
     descend */
#  define CHECKLEN 8
#endif

char* TMPDIR;

	/* Search a directory and optionally recurse throught the tree for a file
   	   having the name specified by argument sought. */



int searchDir(char* basedir, char* answer[], int *answerat, int answerlen,
	char* sought, int descend) {
			/* basedir	- directory tree to search
			   answer	- an array of strings that holds
					  the paths of files that are found
			   answerat	- element of answer into which the
					  next discoverd file should be put
			   answerlen	- length of answer
			   sought	- name of file sought
			   descend      - DESCEND_DIRS if descend
					  NO_DESCEND to simply check entries
			*/

	DIR *adir;
	struct dirent *aentry;
	char entrypath[MAX_PATH_LEN];	/* used to construct full path of entry */
	struct stat entrystat;
	int callfind;		/* count returned by a recursive call */
	int count = 0;		/* cumulative total for current call */

	adir = opendir(basedir);	/* open directory */
	if (adir == NULL) return 0;	/* bail on fail   */
	aentry = readdir(adir);		/* read first entry */
	while (aentry != NULL) {
					/* process non . and .. entries */
		if (strcmp(aentry->d_name, ".") != 0
			&& strcmp(aentry->d_name, "..") != 0) {
					/* construct full name, stat the
				   file and test to see if it's
				   a directory */
			strcpy(entrypath, basedir);
			strcat(entrypath, FILE_SEPARATOR);
			strcat(entrypath, aentry->d_name);
			stat(entrypath, &entrystat);
			if (S_ISDIR(entrystat.st_mode)) { /* directory */
				if (descend == DESCEND_DIRS) {	/* descend */
					callfind = searchDir(entrypath,
					answer, answerat, answerlen, sought,
					DESCEND_DIRS);
					count += callfind;
				}
			} else {	/* check for case insensitive match */
				if (strcasecmp(aentry->d_name, sought) == 0){/*MATCH*/
					answer[(*answerat)] = (char*)malloc(MAX_PATH_LEN);
					strcpy(answer[(*answerat)], entrypath);
					(*answerat) ++;
					count ++;
				}
			}
		}
		if (*answerat >= answerlen) {	/* bail if answer is full */
			closedir(adir);
			return count;
		}
		aentry = readdir(adir);		/* get next entry */
	}
	closedir(adir);
	return count;
}



	/* Check a directory for the presence of subdirectories that begin
	   with names that match any element of the array prefix, and
	   recursively search those subdirectories for a file specified
	   by argument sought. */

int checkDirs(char* basedir, char *prefix[], int prefixlen,
	char* answer[], int *answerat, int answerlen,
	char* sought) {
	DIR *adir;
	struct dirent *aentry;
	char entrypath[MAX_PATH_LEN];
	struct stat entrystat;
	int prefixidx;
	int stringlength;
	int found = 0;
	adir = opendir(basedir);
	if (adir == NULL) return 0;
	aentry = readdir(adir);
	while (aentry != NULL) {
		for (prefixidx = 0; prefixidx < prefixlen; prefixidx ++) {
			stringlength = strlen(prefix[prefixidx]);
			if (strncasecmp(aentry->d_name, prefix[prefixidx],
					stringlength) == 0) {
				strcpy(entrypath, basedir);
				strcat(entrypath, FILE_SEPARATOR);
				strcat(entrypath, aentry->d_name);
				stat(entrypath, &entrystat);
				if (S_ISDIR(entrystat.st_mode)) {
					found += searchDir(entrypath,
						answer, answerat, answerlen,
						sought, DESCEND_DIRS);
					if (*answerat >= answerlen) {
						closedir(adir);
						return found;
					}
				}
			}
		}
		aentry = readdir(adir);
	}
	return found;
}

	/* Find all occurences in a search path of a file named by argument
	   sought. Actually, no mor that answerlen occurences will be returned. */
int searchPath(char* searchpath, char* answer[], int *answerat, int answerlen,
	char* sought) {

	char *pathentry;
	char workpath[MAX_CMD_PATH_LEN];
	int found = 0;
	strcpy(workpath, searchpath);
	pathentry = strtok(workpath, PATH_SEPARATOR);
	while (pathentry != NULL) {
		found += searchDir(pathentry, answer, answerat, answerlen,
			sought, NO_DESCEND);
		if (*answerat >= answerlen) {
			return found;
		}
		pathentry = strtok(NULL, PATH_SEPARATOR);
	}
	return found;
}

	/* Present choices to user and return an index that reflects the
		user's answer.
	*/
int userSelect(char *answer[], int *answerat, int answerlen) {
	int VMChosen;
	int i;
	char *VMResp;
	int limit;
    VMResp = (char*)malloc(MAX_PATH_LEN*sizeof(char));
    printf("\nChoose a Java VM by typing its number:\n\n");
    for(i=0; i<answerlen-1; i++) {
      if( answer[i]!=NULL ) {
        printf("[%d] %s\n", i, answer[i]);
      }
    }
    printf("[%d] %s\n\n> ", answerlen, "Other");
    fgets(VMResp, MAX_PATH_LEN, stdin);
    VMResp[strlen(VMResp)-1]=0;
    VMChosen=atoi(VMResp);
    if( VMChosen!=answerlen && answer[VMChosen]==NULL ) {
      printf("Fatal: bad choice!\n");
      return -1;
    }
    if( (VMChosen==answerlen)||(VMChosen==-10) ) {
      printf("Enter path of java VM:\n\n> ");
      fgets(VMResp, MAX_PATH_LEN, stdin);
      VMResp[strlen(VMResp)-1]=0;
      limit = answerlen - 1;
      if ((*answerat) < limit) {
	  VMChosen = (*answerat);
	  (*answerat) ++;
      } else {
	  VMChosen = limit;
      }
      answer[VMChosen] = VMResp;
    }
    return VMChosen;
}

/*
	Return a pointer to a string that points to a java executable.
        If a JVM exists on the search path, the string returned will be
        simply "java" (without quotes).   If no JVM is found on the search
 	path, a series of directories will be searched that are defined
	by macros at the head of the source file.  On windows, C:\
	and C:\Program Files will be checked for directory entries that
	begin with java, j2re, jre, j2sdk, jdk.  Matching directory trees
	will be searched for a java executable named java.exe.  If only,
	one match is found, it will be returned. If multiple matches are
	found, they will be presented to the user, and the user decides which
	to use.  If no match is found, the directories C:\windows and C:\winnt
	are searched for binaries named jview.exe.
*/

char* getJavaVM() {
	char *vmpath;
	char *answer[JPATHS_SIZE];
	int found;
	int i;
	int answerat = 0;

	char program[] = JAVA_BINARY;
	char *descenddir[] = DESCENDDIR;
	char *checkdir[] = CHECKDIR;
	char *searchpath;
#ifdef WIN
	char programjview[] = JVIEW_BINARY;
	char *descendjview[] = DESCEND_JVIEW;
	char *checkjview[] = CHECK_JVIEW;
#endif
	int checkidx = 0;
	int chosenidx = -1;
    	vmpath = (char*)malloc(MAX_PATH_LEN*sizeof(char));
	strcpy(vmpath, "java");

	for (i = 0; i < JPATHS_SIZE; i++) {
		answer[i] = NULL;
	}
	found = 0;
			/* check path. If any found return generic answer. */
	searchpath = getenv("PATH");
	found += searchPath(searchpath, answer, &answerat, JPATHS_SIZE,
			program);
	if (answerat > 0) {
		printf("\nUsing default JVM on program search path.\n\n");
		return vmpath;
	}
 			/* Check possible locations. If one found, return it.
			   If multiple found, present user with alternatives. */
	while (answerat < JPATHS_SIZE && checkidx < CHECKLEN) {
		found +=  checkDirs(checkdir[checkidx], descenddir,
				DESCENDLEN,
				answer, &answerat, JPATHS_SIZE,
				program);
		checkidx ++;
}

#ifdef WIN
if (answerat == 0) {
	checkidx = 0;
	while (answerat < JPATHS_SIZE && checkidx < CHECK_JVIEW_LEN) {
		found +=  checkDirs(checkjview[checkidx], descendjview,
			DESCEND_JVIEW_LEN, answer, &answerat, JPATHS_SIZE,
			programjview);
		checkidx ++;
	}
}
#endif
if (answerat == 1) {
	chosenidx = 0;
} else if (answerat > 1) {
	chosenidx = userSelect(answer, &answerat, JPATHS_SIZE);
}
if (chosenidx > -1) {
	printf("\nUsing JVM %s.\n\n", answer[chosenidx]);
	strcpy(vmpath, answer[chosenidx]);} else {	vmpath = NULL;  }  return vmpath;}
void usage(char* thisFileName)
{
  printf("Usage: %s [options]\n", thisFileName);
  printf("Options:\n");
  printf("      --debug           Can be \"yes\" or \"no\". Prints debugging information.\n");
  printf("      --uimode          Can be \"graphic\", \"text\" or \"ansi\".\n");
  printf("      --bluescreen      Can be \"yes\" or \"no\". If \"no\", the screen in the back is\n");
  printf("                        not displayed.\n");
}

char** parseFlags(int argc, char** argv)
{
  int i=0;
  char* tmp;
  char** jflags;

  jflags=(char**)malloc(argc/2*sizeof(char*));
  tmp=(char*)malloc(STRING_SIZE*sizeof(char));
  for(i=1; i<argc; i+=2) {
    jflags[i/2]=(char*)malloc(STRING_SIZE*sizeof(char));
    if( strcmp("--debug", argv[i])==0 ) {
      if( (i+1)<argc ) {
        sprintf(tmp, "-DDEBUG=%s", argv[i+1]);
        strcpy(jflags[i/2], tmp);
      } else jflags=0;
    } else
    if( strcmp("--uimode", argv[i])==0 ) {
      if( (i+1)<argc ) {
        sprintf(tmp, "-Duimode=%s", argv[i+1]);
        strcpy(jflags[i/2], tmp);
      } else jflags=0;
    } else
    if( strcmp("--bluescreen", argv[i])==0 ) {
      if( (i+1)<argc ) {
        sprintf(tmp, "-Dbluescreen=%s", argv[i+1]);
        strcpy(jflags[i/2], tmp);
      } else jflags=0;
    } else {
      jflags=0;
    }
  }

  free(tmp);
  return jflags;
}

int outputInstallClass(const char* iclassName, const char* thisFileName, long start, long stop)
{
  FILE* destPath;
  FILE* thisFile;
  char* buf;
  char* destPathName;
  int resp;
  int read=0;
  int tot_read=0;
  int to_read=0;

  buf=(char*)malloc(2048*sizeof(char));
  destPathName=(char*)malloc(STRING_SIZE*sizeof(char));
  sprintf(destPathName, "%s%s.class", TMPDIR, iclassName);
  destPath=fopen(destPathName, "wb");
  if( destPath==NULL ) {
    sprintf(buf, "can not write \"%s\"", destPathName);
    perror(buf);
    return 0;
  }
  thisFile=fopen(thisFileName, "rb");
  if( thisFile==NULL ) {
    sprintf(buf, "can not read %s", thisFileName);
    perror(buf);
    fclose(destPath);
    return 0;
  }

  resp=fseek(thisFile, start, SEEK_SET);
  if( resp==-1 ) {
    sprintf(buf, "error while looking for class loader in %s", thisFileName);
    perror(buf);
    fclose(thisFile);
    fclose(destPath);
    return 0;
  }

  to_read=MIN(2048, stop-start-tot_read);
  read=fread(buf, 1, to_read, thisFile);
  tot_read+=read;
  while( to_read>0 ) {
    fwrite(buf, 1, read, destPath);
    to_read=MIN(2048, stop-start-tot_read);
    read=fread(buf, 1, to_read, thisFile);
    if( feof(thisFile) ) {
      printf("reached EOF while reading class loader in %s\n", thisFileName);
      break;
    }
    tot_read+=read;
  }

  free(buf);
  free(destPathName);
  fclose(thisFile);
  fclose(destPath);
  return 1;
}

void setTempSearchPaths(char** jpaths)
{
  int i;
  for(i=0; i<TPATHS_SIZE; i++) jpaths[i]=(char*)malloc(STRING_SIZE*sizeof(char));
#ifdef WIN
  strcpy(jpaths[0],"C:\\windows\\temp\\");
  strcpy(jpaths[1],"C:\\winnt\\temp\\");
  strcpy(jpaths[2],"C:\\temp\\");
  strcpy(jpaths[3],"D:\\windows\\temp\\");
  strcpy(jpaths[4],"D:\\winnt\\temp\\");
  strcpy(jpaths[5],"D:\\temp\\");
#else
  strcpy(jpaths[0],"/tmp/");
  strcpy(jpaths[1],"/opt/tmp/");
  strcpy(jpaths[2],"/usr/tmp/");
  jpaths[3]=NULL;
  jpaths[4]=NULL;
  jpaths[5]=NULL;
#endif
}

char* searchValidPath(char** jpaths, int size, char* mode)
{
  char* firstone;
  FILE* f;
  int i;
  char* tempFile;

  tempFile=(char*)malloc(STRING_SIZE*sizeof(char));
  firstone=NULL;

  for(i=0; i<size; i++) {
    if( jpaths[i]==NULL ) continue;
    strcpy(tempFile, jpaths[i]);
    if( strcmp(mode, "wb")==0 ) {
      strcat(tempFile, "vaitest.tmp");
    }
    f=fopen(tempFile, mode);
    if( f==NULL ) {
      jpaths[i]=NULL;
    } else {
      fclose(f);
      if( strcmp(mode, "wb")==0 ) remove(tempFile);
      if( firstone==NULL ) firstone=jpaths[i];
    }
  }
  return firstone;
}

int exitOnError()
{
  char* c;
  c=(char*)malloc(2*sizeof(char));
  printf("\nPress \"enter\" to exit\n");
  fgets(c, 2, stdin);
  return 1;
}

int main(int argc, char** argv)
{
  char* CL_NAME;
  char* CL_START;
  char* CL_STOP;
  char** jflags;
  char* JAVA_EXE;
  char* JAVA_EXE_NO_QUOTE;
  int resp=0;
  int i;
  char** jargs;
  char* jargsStr;
  char* index;
  char* fileToRemove;
  char** JPATHS;
  char** TPATHS;
  char* VMResp;
  char* pwd;
  char* tmpbuf;
  int VMChosen=-10;
  char* spaceat;
  #ifdef WIN
  printf("windows\n");
  #endif

  jflags=parseFlags(argc, argv);
  if( jflags==NULL ) {
    usage(argv[0]);
    return exitOnError();
  }

  /* allocations */

  /*ces 3 variables sont remplies par l'archiveur.*/
  CL_NAME=(char*)malloc(65*sizeof(char));
  /*Ces 2 l doivent avoir 12 caractres */
  CL_START=(char*)malloc(13*sizeof(char));
  CL_STOP=(char*)malloc(13*sizeof(char));
  strcpy(CL_NAME, "clname_here_####################################################");
  strcpy(CL_START, "clstart_here");
  strcpy(CL_STOP, "clstop_here_");

  JAVA_EXE=(char*)malloc(STRING_SIZE*sizeof(char));
  JPATHS=(char**)malloc(JPATHS_SIZE*sizeof(char*));
  TPATHS=(char**)malloc(TPATHS_SIZE*sizeof(char*));
  VMResp=(char*)malloc(STRING_SIZE*sizeof(char));
  jargsStr=(char*)malloc(STRING_SIZE*sizeof(char));
  jargs=(char**)malloc((5+argc/2)*sizeof(char*));
  jargs[argc/2+4]=(char*)malloc(STRING_SIZE*sizeof(char));
  pwd=(char*)malloc(STRING_SIZE*sizeof(char));
  fileToRemove=(char*)malloc(STRING_SIZE*sizeof(char));

  TMPDIR=getenv("TEMP");
  if( TMPDIR==NULL ) {
    setTempSearchPaths(TPATHS);
    TMPDIR=searchValidPath(TPATHS, TPATHS_SIZE, "wb");
    if( TMPDIR==NULL ) {
      TMPDIR=(char*)malloc(STRING_SIZE*sizeof(char));
      printf("\nCould not find temp directory.\n\n");
      printf("Enter path of writable temp directory:\n\n> ");
      fgets(TMPDIR, STRING_SIZE, stdin);
      TMPDIR[strlen(TMPDIR)-1]=0;
    }
  }
  if( TMPDIR!=NULL ) {
    if( TMPDIR[strlen(TMPDIR)-1]!=FILE_SEPARATOR[0] ) {
      tmpbuf=TMPDIR;
      TMPDIR=(char*)malloc(STRING_SIZE*sizeof(char));
      strcpy(TMPDIR, tmpbuf);
      strcat(TMPDIR, FILE_SEPARATOR);
    }
    printf("\nInfo: using %s as temp directory.\n", TMPDIR);
  } else {
    printf("No temp directory\n");
    exitOnError();
  }


   JAVA_EXE_NO_QUOTE=getJavaVM();
   if (JAVA_EXE_NO_QUOTE == NULL) {
      printf("\nNo Java VM found.\n\n");
      return exitOnError();
  }
   	/* On Windows XP quotes don't seem to work. Quote binary only if
		it contains spaces.  The should work maximize the number of
		platforms on which the code works. */
   spaceat = strchr(JAVA_EXE_NO_QUOTE, ' ');
   if (spaceat != NULL) strcpy(JAVA_EXE, "\"");
   strcat(JAVA_EXE, JAVA_EXE_NO_QUOTE);
   if (spaceat != NULL) strcat(JAVA_EXE, "\"");
   strcat(JAVA_EXE, " -showversion");

  index=strchr(CL_NAME, '.');
  if( index!=NULL ) {
    *index=0;
  }
  resp=outputInstallClass(CL_NAME, argv[0], atoi(CL_START), atoi(CL_STOP));
  if( !resp ) {
    printf("an error occurred: exiting\n");
    return exitOnError();
  }

  jargs[0]=JAVA_EXE;
  for(i=0; i<argc/2; i++) jargs[1+i]=jflags[i];
  jargs[argc/2+1]="-classpath";
#ifdef WIN
  if( VMChosen==JVIEW_INDEX )
    jargs[argc/2+1]="/cp:p";
#endif
  jargs[argc/2+2]=".";
  jargs[argc/2+3]=CL_NAME;
  getcwd(pwd, STRING_SIZE);
  strcpy(jargs[argc/2+4], "\"");
#ifndef WIN
  strcat(jargs[argc/2+4], pwd);
  strcat(jargs[argc/2+4], FILE_SEPARATOR);
#endif
  strcat(jargs[argc/2+4], argv[0]);
  strcat(jargs[argc/2+4], "\"");
  strcpy(jargsStr, jargs[0]);
  for(i=1; i<argc/2+5; i++) {
    strcat(jargsStr, " ");
    strcat(jargsStr, jargs[i]);
  }
  printf("%s\n\n", jargsStr);
  if( chdir(TMPDIR) ) {
    printf("can not cd to %s\n", TMPDIR);
    return exitOnError();
  }
  printf("Starting Java\n\n");
  resp=system(jargsStr);
  if( resp==-1 ) {
    perror(JAVA_EXE);
    return exitOnError();
  }



  sprintf(fileToRemove, "%s%s.class", TMPDIR, CL_NAME);

  remove(fileToRemove);



  return 0;

}
