<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:variable name="newline">
<xsl:text>
</xsl:text>
</xsl:variable>

<xsl:variable name="optionDescribeChecking" select="'F'"/>

<xsl:variable name="lowercase" select="'abcdefghijklmnopqrstuvwxyz'" />
<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
   
<xsl:template name="buildFullPathInInstanceToCurrentNode">
	<xsl:if test="name(.) != 'DicomStructuredReport'">
		<xsl:for-each select="..">
			<xsl:call-template name="buildFullPathInInstanceToCurrentNode"/>
		</xsl:for-each>
		<xsl:value-of select="name(.)"/>
		<xsl:if test="name(.) = 'Item' or name(.) = 'value'">
			<xsl:text>[</xsl:text><xsl:value-of select="@number"/><xsl:text>]</xsl:text>
		</xsl:if>
		<xsl:text>/</xsl:text>
	</xsl:if>
</xsl:template>

<xsl:template name="buildDescriptionOfContentItem">
	<xsl:param name="node"/>
	<xsl:text>content item (</xsl:text><xsl:value-of select="substring($node/@ID,4)"/><xsl:text>: </xsl:text><xsl:value-of select="translate(name($node),$lowercase,$uppercase)"/><xsl:text>)</xsl:text>
</xsl:template>

<xsl:template name="buildDescriptionOfReferencedContentItem">
	<xsl:param name="node"/>
	<xsl:text>content item (</xsl:text><xsl:value-of select="substring(key('idkey',$node/@IDREF)/@ID,4)"/><xsl:text>: </xsl:text><xsl:value-of select="translate(name(key('idkey',$node/@IDREF)),$lowercase,$uppercase)"/><xsl:text>)</xsl:text>
</xsl:template>

<xsl:template name="checkPermittedChildContentItemByValueRelationship">
	<xsl:param name="parent"/>
	<xsl:param name="child"/>
	<xsl:if test="$optionDescribeChecking='T'">
		<xsl:text>Parent </xsl:text>
		<xsl:call-template name="buildDescriptionOfContentItem"><xsl:with-param name="node" select="$parent"/></xsl:call-template>
		<xsl:text> has good relationship </xsl:text><xsl:value-of select="$child/@relationship"/>
		<xsl:text> with child </xsl:text>
		<xsl:call-template name="buildDescriptionOfContentItem"><xsl:with-param name="node" select="$child"/></xsl:call-template>
		<xsl:value-of select="$newline"/>
	</xsl:if>
</xsl:template>

<xsl:template name="checkPermittedChildContentItemByReferenceRelationship">
	<xsl:param name="parent"/>
	<xsl:param name="child"/>
	<xsl:if test="$optionDescribeChecking='T'">
		<xsl:text>Parent </xsl:text>
		<xsl:call-template name="buildDescriptionOfContentItem"><xsl:with-param name="node" select="$parent"/></xsl:call-template>
		<xsl:text> has good relationship R-</xsl:text><xsl:value-of select="$child/@relationship"/>
		<xsl:text> with child </xsl:text>
		<xsl:call-template name="buildDescriptionOfReferencedContentItem"><xsl:with-param name="node" select="$child"/></xsl:call-template>
		<xsl:value-of select="$newline"/>
	</xsl:if>
</xsl:template>

<xsl:template name="describeIllegalChildContentItem">
	<xsl:param name="parent"/>
	<xsl:param name="child"/>
	<xsl:text>Parent </xsl:text>
	<xsl:call-template name="buildDescriptionOfContentItem"><xsl:with-param name="node" select=".."/></xsl:call-template>
	<xsl:text> has illegal relationship </xsl:text>
	<xsl:choose>
	<xsl:when test="name(.) = 'reference'">
		<xsl:text>R-</xsl:text><xsl:value-of select="./@relationship"/>
		<xsl:text> with child </xsl:text>
		<xsl:call-template name="buildDescriptionOfReferencedContentItem"><xsl:with-param name="node" select="."/></xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:value-of select="./@relationship"/>
		<xsl:text> with child </xsl:text>
		<xsl:call-template name="buildDescriptionOfContentItem"><xsl:with-param name="node" select="."/></xsl:call-template>
	</xsl:otherwise>
	</xsl:choose>
	<xsl:value-of select="$newline"/>
</xsl:template>


<xsl:key name="idkey" match="text" use="@ID"/>
<xsl:key name="idkey" match="num" use="@ID"/>
<xsl:key name="idkey" match="code" use="@ID"/>
<xsl:key name="idkey" match="datetime" use="@ID"/>
<xsl:key name="idkey" match="date" use="@ID"/>
<xsl:key name="idkey" match="time" use="@ID"/>
<xsl:key name="idkey" match="uidref" use="@ID"/>
<xsl:key name="idkey" match="pname" use="@ID"/>
<xsl:key name="idkey" match="composite" use="@ID"/>
<xsl:key name="idkey" match="image" use="@ID"/>
<xsl:key name="idkey" match="waveform" use="@ID"/>
<xsl:key name="idkey" match="scoord" use="@ID"/>
<xsl:key name="idkey" match="tcoord" use="@ID"/>
<xsl:key name="idkey" match="container" use="@ID"/>

</xsl:stylesheet>
