import java.util.*;
import java.io.*;
import java.sql.*;

public class SqlRunner {

    public static Properties loadProperties(String propsFilename) throws IOException
    {
	InputStream is = SqlRunner.class.getClassLoader().getResourceAsStream(propsFilename);
	Properties props = new Properties();
	props.load(is);
	return props;
    }
    
    public static void usage() {
	System.err.println("Usage: SqlRunner <i|q> <query>");
	System.err.println("where i- means DDL statement q means SQL query");
	System.exit(1);
    }


    public static String prepTimeStamp(Object value) throws SQLException {
          try {
	    return  ((oracle.sql.TIMESTAMP) value).timestampValue().toString(); 
	  } catch(NullPointerException x) {
            return "NULL";
	  }
    }
    
    public static void doQuery(Connection con,String query, boolean ddl) throws SQLException {
	Statement st = null;
	try {
            st = con.createStatement();
	    if ( !ddl ) { 
		ResultSet rs = st.executeQuery(query);
		ResultSetMetaData rsmt =  rs.getMetaData(); 
		int noCols = rsmt.getColumnCount();
                for(int i = 0; i < noCols; ++i) {
		    System.out.print(rsmt.getColumnName(i + 1) + " ");
		}
		System.out.println();    
		while( rs.next() ) {
		    for(int i=1; i <= noCols; ++i) {
                        Object value = rs.getObject(i);
                        if ( value == null) {
			    value = "NULL";
			}
			if ( value instanceof oracle.sql.TIMESTAMP) {
                          System.out.print("\"" + prepTimeStamp(value) +  "\" ");
			} else {
			  String valueStr = value.toString();
			  System.out.print("\""+ valueStr + "\" ");
			}
		    } 
		    System.out.println();
		} 
		rs.close();
	    } else {
		int rc = st.executeUpdate(query);
		System.out.println("returned " + rc);      
	    }	
	} finally {
	    if (st != null)
		try { st.close(); } catch(Exception x) {}
	}	
    }


 public static void main(String[] args) throws IOException {
   Connection con = null;
   Statement st = null;
   ResultSet rs = null;

   Properties props = loadProperties("sqlrunner.properties"); 
   
 
   String dbType = "o";
    

   String dbURL = "";
   String user = "";
   dbURL = props.getProperty("db_url");
   user = props.getProperty("user"); 
   String pwd = props.getProperty("pwd"); 
   
   try {
     if ( dbType.equals("p") ) {
       Class.forName("org.postgresql.Driver");
     } else {
       Class.forName("oracle.jdbc.driver.OracleDriver");
     }
     
     con = DriverManager.getConnection(dbURL, user, pwd);
   
     BufferedReader consoleIn = new BufferedReader( new InputStreamReader( System.in ) );

     while(true) {
         System.out.print("sql::>> "); 
         String cmdStr = consoleIn.readLine().trim();
         
         if (cmdStr.equals("exit") ) {
	     break;
	 } else if (cmdStr.length() == 0) {
	     continue;
	 }
         int idx = cmdStr.indexOf(' ');
         String cmd = cmdStr.substring(0, idx);
         String query = cmdStr.substring(idx + 1).trim();
         if ( cmd.equals("query") ) {
	     doQuery(con, query, false);
	 } else if ( cmd.equals("ddl") ) {
	     doQuery(con, query, true);
	 }
     }
   
   } catch(Exception ex) {
      ex.printStackTrace();
   } finally {
        if (con != null)
       try { con.close(); } catch(Exception x) {}
   }
 }

}
