package caslayout;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import caslayout.ui.CALMConfig;
import caslayout.ui.CALMHelper;
import caslayout.ui.Document;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.AssessmentMaintenanceHelper;
import caslayout.ui.model.AssociationHelper;

public class CommandLineInterface {
   protected CALMConfig config;
   protected ScoreLayoutPanel slPanel;

   public CommandLineInterface() throws Exception {
      config = new CALMConfig("caslayout.properties");

      Class.forName(Constants.ORACLE_JDBC_DRIVER);
      Class.forName(Constants.POSTGRES_JDBC_DRIVER).newInstance();
      slPanel = new ScoreLayoutPanel("Score Layout", true, null, config);
      slPanel.setMinimumSize(new Dimension(500, 300));
      slPanel.setPreferredSize(new Dimension(600, 500));
      if (config.getPwd() == null || config.getPwd().length() == 0) {
         askForDBPwd();
      }
   }

   public void askForDBPwd() throws IOException {
      BufferedReader console = new BufferedReader(new InputStreamReader(
            System.in));
      while (true) {
         System.out.print("Please enter pwd for dbuser '" + config.getUser()
               + "': >> ");
         String ans = console.readLine().trim();
         if (ans.length() > 0) {
            config.setPwd(ans);
            break;
         }
      }
   }

   public String ask4AssessmentName() throws IOException {
      BufferedReader console = new BufferedReader(new InputStreamReader(
            System.in));
      while (true) {
         System.out.print("Please enter the name of the assessemnt >> ");
         String ans = console.readLine().trim();
         if (ans.length() > 0) {
            return ans;
         }
      }
   }

   public void saveAssessment2DB(String calmAsDocFile) throws Exception {
      File sf = new File(calmAsDocFile);
      if (sf.getName().endsWith(".calm")) {
         CALMHelper.buildDocument(sf.getAbsolutePath(), slPanel, config);
      } else {
         Document.loadDocument(sf.getAbsolutePath(), slPanel);
      }

      AssociationHelper assocHelper = AssociationHelper.getInstance();

      AssessmentInfo newAsInfo = null;
      if (assocHelper.getAsAssoc() != null) {
         AssessmentAssociation aa = assocHelper.getAsAssoc();
         if (aa.getLeft() != null) {
            newAsInfo = aa.getLeft();
         }
      }

      if (newAsInfo != null) {
         String asName = newAsInfo.getName();
         if (asName.equalsIgnoreCase("new assessment"))
            asName = ask4AssessmentName();
         newAsInfo.setName(asName);

         AssessmentInfo dbAsi = AssessmentMaintenanceHelper.loadAssessment(
               config, newAsInfo.getName());

         System.out.println();
         System.out.println();
         if (dbAsi != null) {
            System.err.println("The assessment '" + newAsInfo.getName()
                  + "' already exists in the database!");
         } else {
            AssessmentMaintenanceHelper
                  .saveAssessment(config, newAsInfo, false);
         }
      }
   }

}
