package caslayout.codegen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import caslayout.ui.AbstractDisplayComponent;
import caslayout.ui.CAContainer;
import caslayout.ui.CAGridLayout;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.LogicalGroup;
import caslayout.ui.QuestionGroup;
import caslayout.ui.model.AssociationHelper;
import caslayout.ui.model.ScoreAssociation;
import caslayout.util.CodegenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: QuestionInfo.java,v 1.8 2008/10/14 23:21:16 bozyurt Exp $
 */

public class QuestionInfo {
   protected TDColumn[] tdCols;
   protected QuestionGroup questGroup;
   protected Map<IDisplayComponent, IDisplayComponent> compMap = new LinkedHashMap<IDisplayComponent, IDisplayComponent>(
         17);

   // AbstractDisplayComponent theComp;

   public QuestionInfo(QuestionGroup qg, AbstractDisplayComponent adc) {
      questGroup = qg;
      // theComp = adc;
      if (qg.getMetaDataValue("type").equals(QuestionGroup.MULTI_ANSWER)) {
         prepare(adc);
      }
      for (Object element : qg.getElements()) {
         IDisplayComponent ic = (IDisplayComponent) element;
         compMap.put(ic, ic);
      }
   }

   protected void prepare(AbstractDisplayComponent adc) {
      CAContainer container = (CAContainer) adc.getParent();
      if (container == null)
         throw new RuntimeException("Has no parent!");
      // a multi-answer question needs to be contained within a single container
      // row
      // it can contain as many components and nested containers within the
      // outside single container row.
      CAGridLayout layout = (CAGridLayout) container.getLayoutManager();
      CAGridLayout.Location loc = layout.findLocation(adc);
      int offset = container.findComponentIndex(adc);
      int rowCols = layout.getEffectiveColumnCount(loc.getRow());

      tdCols = CodegenUtils.prepareTableColumns(loc.getRow(), layout, rowCols,
            container, offset);

   }

   public boolean isInQuestion(IDisplayComponent ic) {
      return compMap.get(ic) != null;
   }

   public TDColumn[] getTDColumns() {
      return tdCols;
   }

   public QuestionGroup getQuestionGroup() {
      return questGroup;
   }

   /**
    * for the scores associated with the <code>QuestionGroup</code>, finds
    * the leftmost components to locate the notes icon used to associate reasons
    * for not answering the question.
    *
    * @return an association table of score name - leftmost component (<code>IDisplayComponent</code>.
    */
   public Map<String, IDisplayComponent> findLeftMostComponents() {
      Map<String, IDisplayComponent> lmCompMap = new HashMap<String, IDisplayComponent>(
            7);
      AssociationHelper ah = AssociationHelper.getInstance();

      for (Object element : questGroup.getElements()) {
         IDisplayComponent ic = (IDisplayComponent) element;
         ScoreAssociation sa = (ScoreAssociation) ah
               .findScoreAssociationForDisplayComponent(ic);
         if (sa != null) {
            // TODO limit unneccessary calls to this method
            // System.out.println(">> score name=" + sa.getName());
            if (lmCompMap.get(sa.getName()) != null) {
               continue;
            }
            if (sa.getRight() instanceof LogicalGroup) {
               LogicalGroup lg = (LogicalGroup) sa.getRight();
               lmCompMap.put(sa.getName(), lg.findLeftMostComponent());
            } else {
               lmCompMap.put(sa.getName(), (IDisplayComponent) sa.getRight());
            }
         }
      }

      return lmCompMap;
   }

   public IDisplayComponent findLeftMostComponent() {
      IDisplayComponent leftMost = null;
      CAContainer lmContainer = null;
      Map<CAContainer, IDisplayComponent> leftMostContainersMap = new LinkedHashMap<CAContainer, IDisplayComponent>(
            7);
      for (Object element : questGroup.getElements()) {
         IDisplayComponent ic = (IDisplayComponent) element;
         CAContainer parent = (CAContainer) ic.getParent();
         IDisplayComponent lmc = leftMostContainersMap.get(parent);

         if (lmc == null) {
            leftMostContainersMap.put(parent, ic);
         } else {
            int idx = parent.findComponentIndex(ic);
            int oldIdx = parent.findComponentIndex(lmc);
            if (idx < oldIdx) {
               leftMostContainersMap.put(parent, ic);
            }
         }
      }

      if (leftMostContainersMap.isEmpty()) {
         throw new RuntimeException("No container detected for question "
               + questGroup);
      }

      Iterator<Map.Entry<CAContainer, IDisplayComponent>> iter = leftMostContainersMap
            .entrySet().iterator();
      Map.Entry<CAContainer, IDisplayComponent> entry = iter.next();
      lmContainer = (CAContainer) entry.getKey();
      leftMost = (IDisplayComponent) entry.getValue();
      while (iter.hasNext()) {
         entry = iter.next();
         CAContainer cc = (CAContainer) entry.getKey();
         // CAContainer out = findTheOuterContainer(lmContainer, cc);
         CAContainer out = findTheLeftmostOf(lmContainer, cc);
         if (out == cc) {
            lmContainer = cc;
            leftMost = (IDisplayComponent) entry.getValue();
         }
      }
      System.out.println(">>leftmost compID="
            + ((AbstractDisplayComponent) leftMost).getId() + " question ID="
            + questGroup.getId());
      return leftMost;
   }

   class ComponentLocInfo {
      int level;
      int compIdx;
   }

   protected CAContainer findTheLeftmostOf(CAContainer c, CAContainer c2Find) {
      ComponentLocInfo cli = new ComponentLocInfo();
      CAContainer theLeftMostOuterOne = findContainer(c, c2Find, cli);
      if (theLeftMostOuterOne != null)
         return theLeftMostOuterOne;

      CAContainer parent1 = null;
      parent1 = findContainerParent(c);

      do {
         if (parent1 != null) {
            cli = new ComponentLocInfo();
            CAContainer contained = findContainer(parent1, c2Find, cli);
            if (contained != null) {
               // found c2Find in the common parent container
               // find the location c in parent1 , see which one closest to the
               // top of
               // the parent1
               ComponentLocInfo cli2 = new ComponentLocInfo();
               contained = findContainer(parent1, c, cli2);
               if (cli.level < cli2.level) {
                  return c2Find;
               } else if (cli.level > cli2.level) {
                  return c;
               } else {
                  return cli.compIdx < cli2.compIdx ? c2Find : c;
               }
            }
         }
         if (parent1 == null)
            break;
         parent1 = findContainerParent(parent1);
      } while (parent1 != null);
      return null;
   }

   protected CAContainer findContainerParent(CAContainer c) {
      AbstractDisplayComponent parent1 = (AbstractDisplayComponent) c
            .getParent();
      while (parent1 != null && !(parent1 instanceof CAContainer)) {
         parent1 = (AbstractDisplayComponent) parent1.getParent();
      }
      return (CAContainer) parent1;
   }

   protected CAContainer findContainer(CAContainer c, CAContainer c2Find,
         ComponentLocInfo cli) {
      int idx = 0;
      for (Object element : c.getComponents()) {
         IDisplayComponent ic = (IDisplayComponent) element;
         if (ic instanceof CAContainer) {
            CAContainer cc = (CAContainer) ic;
            if (cc == c2Find) {
               cli.compIdx = idx;
               return cc;
            }
            cli.level++;
            return findContainer(cc, c2Find, cli);
         }
         ++idx;
      }
      return null;
   }

   protected CAContainer findContainer(CAContainer c, CAContainer c2Find) {
      for (Object element : c.getComponents()) {
         IDisplayComponent ic = (IDisplayComponent) element;
         if (ic instanceof CAContainer) {
            CAContainer cc = (CAContainer) ic;
            if (cc == c2Find)
               return cc;
            return findContainer(cc, c2Find);
         }
      }
      return null;
   }

}
