package caslayout.codegen;

import java.io.*;

import caslayout.codegen.struts.*;
import caslayout.ui.*;
import caslayout.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StrutsStyleSheetGenerator.java,v 1.5 2004/09/28 01:26:57 bozyurt Exp $
 */

public class StrutsStyleSheetGenerator extends StyleSheetGenerator {
  // protected String formBeanID;
  protected int pageIdx;
  protected StrutsCodegenConfig config;

  public StrutsStyleSheetGenerator() { super(); }


  public StrutsStyleSheetGenerator(CAContainer root, StrutsCodegenConfig config, int pageIdx)  {
    super(root);
    this.config = config;
    this.pageIdx = pageIdx;
  }

  public void generate(Writer out) throws IOException {
    writeHeader(out);
    generateStaticPart(out,1);
    out.write("\n");
    out.write("<xsl:template match=\"/\">\n");
    writeStrutsHeader(out, 1);

    doIndent(out,2);
    // out.write("<html:form action=\"{//xforms:submission/@action}\">\n\n");
    String suffix =  ( config.getJspPageNames().length == 1 ) ? "" : "_Page" + pageIdx;
    String actionPath = config.getStrutsActionRoot() + suffix;

    out.write("<html:form action=\"");
    out.write(actionPath);
    out.write("\">\n\n");

    generateTemplates(out, root, 3);

    doIndent(out,2);
    out.write("</html:form>\n");
    out.write("</center>\n");
    out.write("</xsl:template>\n");
    writeFooter(out);
  }

  protected void writeHeader(Writer out) throws IOException {
    out.write("<?xml version=\"1.0\"?>\n");
    out.write("<xsl:stylesheet version=\"1.0\"\n");
    out.write("\txmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n");
    out.write("\txmlns:calm=\"http://www.nbirn.net\"\n");
    out.write("\txmlns:html=\"dummy\"\n");
    out.write("\txmlns:bean=\"dummy\"\n");

    out.write("\txmlns:xforms=\"http://www.w3.org/2002/xforms\"\n");
    out.write("\texclude-result-prefixes=\"calm xforms html bean\">\n\n");

    out.write("<xsl:output method=\"html\"/>\n\n");
  }


  protected void writeStrutsHeader(Writer out, int level) throws IOException {
    writeXMLString(out, "<%@ page contentType=\"text/html;charset=UTF-8\" language=\"java\" %>\n");
    writeXMLString(out, "<%@ taglib uri=\"/WEB-INF/struts-bean.tld\" prefix=\"bean\" %>\n");
    writeXMLString(out, "<%@ taglib uri=\"/WEB-INF/struts-html.tld\" prefix=\"html\" %>\n");
    writeXMLString(out, "<%@ taglib uri=\"/WEB-INF/struts-logic.tld\" prefix=\"logic\" %>\n");
    writeXMLString(out, "<html:errors/>\n<br>\n<br>\n\n");
    out.write("<center>\n");

  }

  protected void writeXMLString(Writer out, String str) throws IOException {
    out.write("<xsl:text disable-output-escaping=\"yes\" >");
    out.write( XMLUtils.toXML( str ) );
    out.write("</xsl:text>\n");
  }

  protected void writeXMLString(Writer out, String str, boolean addNewLine) throws IOException {
    out.write("<xsl:text disable-output-escaping=\"yes\" >");
    out.write( XMLUtils.toXML( str ) );
    out.write("</xsl:text>");
    if ( addNewLine)
      out.write("\n");
  }


  protected void writeForEachTag(Writer out, int level, String selectText, boolean startTag) throws IOException
  {
    if ( startTag) {
      doIndent(out, level);
         out.write("<xsl:for-each select=\""); out.write(selectText);  out.write("\">\n");
    } else {
      doIndent(out, level);    out.write("</xsl:for-each>\n");
    }

  }

  protected void writeSpanTag(Writer out, int level, boolean startTag) throws IOException {
   // doIndent(out, level); out.write("<xsl:for-each select=\"calm:css\">\n");
    if ( startTag) {
      doIndent(out, level);
      out.write("<xsl:text disable-output-escaping=\"yes\" >");
      out.write("&lt;span class=\"");
      out.write("</xsl:text>");

      out.write("<xsl:value-of select=\"calm:css/@class\"/>");

      out.write("<xsl:text disable-output-escaping=\"yes\" >");
      out.write("\"&gt;");
      out.write("</xsl:text>\n");
    } else {
      out.write("<xsl:text disable-output-escaping=\"yes\" >");
      out.write("&lt;/span&gt;");
      out.write("</xsl:text>\n");
    }
   // doIndent(out, level); out.write("</xsl:for-each>\n");

  }

  protected void writeChooseTag(Writer out, int level, boolean startTag) throws IOException {
    if ( startTag) {
      doIndent(out, level); out.write("<xsl:choose>\n");
    } else {
      doIndent(out, level); out.write("</xsl:choose>\n");
    }
  }

  protected void writeWhenTag(Writer out, int level, boolean startTag) throws IOException {
    if (startTag) {
     doIndent(out, level); out.write("<xsl:when test=\"calm:css\">\n");
    } else {
      doIndent(out, level); out.write("</xsl:when>\n");
    }
  }

  protected void writeOtherwiseTag(Writer out, int level, boolean startTag) throws IOException {
    if (startTag) {
     doIndent(out, level); out.write("<xsl:otherwise>\n");
    } else {
      doIndent(out, level); out.write("</xsl:otherwise>\n");
    }
  }



  protected void generateStaticPart(Writer out, int level) throws IOException {
   doIndent(out, level); out.write("<xsl:template match=\"xforms:label\">\n");

   writeChooseTag(out, level + 1, true);
   writeWhenTag(out, level + 2, true);
   writeSpanTag(out, level + 3, true);
   doIndent(out, level+3);
   out.write("<xsl:value-of disable-output-escaping=\"yes\" select=\".\"/>\n");
   writeSpanTag(out, level+3, false);
   writeWhenTag(out, level + 2, false);

   writeOtherwiseTag(out, level + 2, true);
   doIndent(out, level+3);
   out.write("<xsl:value-of disable-output-escaping=\"yes\" select=\".\"/>\n");
   writeOtherwiseTag(out, level + 2, false);
   writeChooseTag(out, level + 1, false);

   doIndent(out, level); out.write("</xsl:template>\n");

   generateInputFieldTemplate(out, level);
   generateRadioButtonTemplate(out, level);
   generateSubmitFieldTemplate(out, level);
   generateTextAreaFieldTemplate(out, level);
 }

 protected void generateInputFieldTemplate(Writer out, int level) throws IOException {
   out.write("\n");
   doIndent(out, level); out.write("<xsl:template match=\"xforms:input\">\n");
   doIndent(out, level+1); out.write("<xsl:apply-templates/>");

   doIndent(out, level+1);
   out.write("<xsl:variable name=\"varid\" select=\"@ref\"/>\n");
   doIndent(out, level+1);
   out.write("<xsl:variable name=\"varname\" select=\"//calm:score[@id=$varid]/calm:display-name\"/>\n");
   doIndent(out, level+1); out.write("<xsl:choose>\n");

   doIndent(out, level+2);
   out.write("<xsl:when test=\"string-length($varname) >= 1\">\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, true);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+3); out.write("<html:text name=\"");
   out.write( config.getFormBeanID()); out.write("\" property=\"{$varname}\" ");
   out.write("/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, false);
   writeForEachTag(out, level+3, "calm:css", false);


   doIndent(out, level+2); out.write("</xsl:when>\n");
   doIndent(out, level+2);out.write("<xsl:otherwise>\n");
   doIndent(out, level+3);
   out.write("<xsl:variable name=\"varname\" select=\"//calm:field[@id=$varid]/@name\"/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, true);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+4); out.write("<html:text name=\"");
   out.write( config.getFormBeanID() ); out.write("\" property=\"{$varname}\" ");
   out.write("/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, false);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+2);out.write("</xsl:otherwise>\n");
   doIndent(out, level+1); out.write("</xsl:choose>\n");

   doIndent(out, level); out.write("</xsl:template>\n");
 }


 protected void generateTextAreaFieldTemplate(Writer out, int level) throws IOException {
   out.write("\n");
   doIndent(out, level); out.write("<xsl:template match=\"xforms:textarea\">\n");
   doIndent(out, level+1); out.write("<xsl:apply-templates/>");

   doIndent(out, level+1);
   out.write("<xsl:variable name=\"varid\" select=\"@ref\"/>\n");
   doIndent(out, level+1);
   out.write("<xsl:variable name=\"varname\" select=\"//calm:score[@id=$varid]/calm:display-name\"/>\n");
   doIndent(out, level+1);
   out.write("<xsl:variable name=\"numRows\" select=\"calm:rows/@value\"/>\n");
   doIndent(out, level+1);
   out.write("<xsl:variable name=\"numCols\" select=\"calm:cols/@value\"/>\n");
   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, true);

   doIndent(out, level+4); out.write("<html:textarea name=\"");
   out.write( config.getFormBeanID()); out.write("\" property=\"{$varname}\" ");
   // rows and cols attributes from calm namespace
   out.write("rows=\"{$numRows}\" cols=\"{$numCols}\" ");
   out.write("/>\n");

   writeSpanTag(out, level+4, false);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level); out.write("</xsl:template>\n");
 }



 protected void generateRadioButtonTemplate(Writer out, int level) throws IOException {
   out.write("\n");
   doIndent(out, level); out.write("<xsl:template match=\"xforms:item\">\n");
   doIndent(out, level+1); out.write("<xsl:choose>\n");
   doIndent(out, level+2); out.write("<xsl:when test=\"parent::xforms:select1\">\n");
   doIndent(out, level+3);
   out.write("<xsl:variable name=\"varid\" select=\"parent::xforms:select1/@ref\"/>\n");
   doIndent(out, level+3);
   out.write("<xsl:variable name=\"varname\" select=\"//calm:score[@id=$varid]/calm:display-name\"/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, true);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+3);
   out.write("<html:radio name=\"");  out.write(  config.getFormBeanID());
   out.write("\" property=\"{$varname}\"  title=\"{xforms:label}\" value=\"{xforms:value}\"/> ");
   out.write("<xsl:value-of select=\"xforms:label\"/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, false);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+2); out.write("</xsl:when>\n");

   doIndent(out, level+2); out.write("<xsl:otherwise>\n");
   doIndent(out, level+3);
   out.write("<xsl:variable name=\"varid\" select=\"parent::xforms:select/@ref\"/>\n");
   doIndent(out, level+3);
   out.write("<xsl:variable name=\"varname\" select=\"//calm:score[@id=$varid]/calm:display-name\"/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+4, true);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+3);
   out.write("<html:checkbox name=\""); out.write( config.getFormBeanID() );
   out.write("\" property=\"{$varname}\" title=\"{xforms:label}\" value=\"{xforms:value}\"/>\n");

   writeForEachTag(out, level+3, "calm:css", true);
   writeSpanTag(out, level+3, false);
   writeForEachTag(out, level+3, "calm:css", false);

   doIndent(out, level+2); out.write("</xsl:otherwise>\n");
   doIndent(out, level+1); out.write("</xsl:choose>\n");
   doIndent(out, level); out.write("</xsl:template>\n");
 }


 protected void generateSubmitFieldTemplate(Writer out, int level) throws IOException {
   out.write("\n");
   doIndent(out, level); out.write("<xsl:template match=\"xforms:submit\">\n");
   writeChooseTag(out, level + 1, true);
   writeWhenTag(out, level + 2, true);
   writeSpanTag(out, level+3, true);

   doIndent(out, level+4); out.write("<html:submit property=\"action\"> <xsl:value-of select=\"xforms:label\"/>");
   out.write("</html:submit>\n");

   writeSpanTag(out, level+3, false);
   writeWhenTag(out, level + 2, false);

   writeOtherwiseTag(out, level + 2, true);
   doIndent(out, level+3);

   out.write("<html:submit property=\"action\"> <xsl:value-of select=\"xforms:label\"/>");
   out.write("</html:submit>\n");

   writeOtherwiseTag(out, level + 2, false);
   writeChooseTag(out, level + 1, false);

   doIndent(out, level); out.write("</xsl:template>\n");
 }

}