package caslayout.codegen;

import java.io.*;

import caslayout.ui.*;
import caslayout.util.*;
import caslayout.output.AbstractGenerator;

/**
*
* @author I. Burak Ozyurt
* @version $Id: StyleSheetGenerator.java,v 1.4 2005/09/09 01:28:24 bozyurt Exp $
*/


public class StyleSheetGenerator extends AbstractGenerator {
  protected CAContainer root;

  public StyleSheetGenerator() { super(); }

  public StyleSheetGenerator(CAContainer root) {
    super();
    this.root = root;
  }


  public void initialize(CAContainer root) {
    this.root = root;
  }

  public void generate(Writer out) throws IOException {
    writeHeader(out);
    generateStaticPart(out,1);
    out.write("\n");
    out.write("<xsl:template match=\"/\">\n");
    generateTemplates(out, root, 2);
    out.write("</xsl:template>\n");

    writeFooter(out);
  }

  protected void writeHeader(Writer out) throws IOException {
    out.write("<?xml version=\"1.0\"?>\n");
    out.write("<xsl:stylesheet version=\"1.0\"\n");
    out.write("\txmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n");
    out.write("\txmlns:calm=\"http://www.nbirn.net\"\n");
    out.write("\txmlns:xforms=\"http://www.w3.org/2002/xforms\"\n");
    out.write("\t exclude-result-prefixes=\"calm xforms\">\n\n");

    out.write("<xsl:output method=\"html\"/>\n\n");
  }


  protected void writeFooter(Writer out) throws IOException {
    out.write("</xsl:stylesheet>\n");
  }


  protected void generateTemplates(Writer out, CAContainer container, int level) throws IOException {
    doIndent(out, level);
    if ( container == root) {
      tableStart(out, 1, "80%");
    } else {
      tableStart(out);
    }
    CAGridLayout layout = (CAGridLayout) container.getLayoutManager();
    int rows = layout.getEffectiveRowCount();
    int index = 0;
    for (int i = 0; i < rows; i++) {
      doIndent(out, level + 1);
      tableRowStart(out);
      int cols = layout.getEffectiveColumnCount(i);

      TDColumn[] tdCols = CodegenUtils.prepareTableColumns(i, layout, cols,
          container, index);

      int offset = index;
      for (int j = 0; j < tdCols.length; j++) {

        doIndent(out, level + 2);
        out.write( tdCols[ j ].tagStart() );

        if (index < container.getComponents().size()) {
          IDisplayComponent ic = CodegenUtils.getDisplayComponent( container,  offset + tdCols[ j ].col);

          if (ic != null) {
            if ( ic instanceof CAContainer) {
              out.write("\n");
              generateTemplates(out, (CAContainer) ic, level);
            } else {
              doIndent(out, level + 3);
              out.write("<xsl:apply-templates select=\"//calm:id[@value='");
              out.write( ((AbstractDisplayComponent) ic ).getId() );
              out.write("']/..\"/>");
            }

          } else {
           // no component in the current grid cell
           out.write("<xsl:text disable-output-escaping=\"yes\">&amp;nbsp;</xsl:text>");
          }
        }

        if ( (offset + tdCols[ j ].col) >= container.getComponents().size() ) {
          out.write("<xsl:text disable-output-escaping=\"yes\">&amp;nbsp;</xsl:text>");
        }

        out.write( tdCols[ j ].tagEnd() + "\n");
      }//j

      index = offset + cols;

      doIndent(out, level + 1);
      tableRowEnd(out);
    }//i
    doIndent(out, level);
    tableEnd(out);
  }


  protected boolean areAllColumnSpansEqual(CAGridLayout layout, int row, int colCount) {
    if (colCount == 0) return false;
    MultipleCellSpanConstraint mc =  (MultipleCellSpanConstraint)  layout.getCellConstraint(row,0);
    int theColSpan = mc.getColSpan();
    for (int i = 1; i < colCount; i++) {
      mc = (MultipleCellSpanConstraint)  layout.getCellConstraint(row,i);
      if ( mc.getColSpan() != theColSpan)
        return false;
    }
    return true;
  }

  protected void generateStaticPart(Writer out, int level) throws IOException {
    doIndent(out, level); out.write("<xsl:template match=\"xforms:label\">\n");

    doIndent(out, level+1);

    out.write("<xsl:value-of disable-output-escaping=\"yes\" select=\".\"/>\n");
    doIndent(out, level); out.write("</xsl:template>\n");


    doIndent(out, level); out.write("<xsl:template match=\"xforms:input\">\n");
    doIndent(out, level+1); out.write("<xsl:apply-templates/>");
    doIndent(out, level+1); out.write("<input type=\"text\" name=\"{@ref}\" value=\"\"/>\n");
    doIndent(out, level); out.write("</xsl:template>\n");


    doIndent(out, level); out.write("<xsl:template match=\"xforms:item\">\n");
    doIndent(out, level+1); out.write("<xsl:choose>\n");
    doIndent(out, level+2); out.write("<xsl:when test=\"parent::xforms:select1\">\n");
    doIndent(out, level+3); out.write("<input type=\"radio\" name=\"todo\" value=\"{xforms:value}\">\n");
    doIndent(out, level+4); out.write("<xsl:value-of select=\"xforms:label\"/> </input>\n");
    doIndent(out, level+2); out.write("</xsl:when>\n");
    doIndent(out, level+2); out.write("<xsl:otherwise>\n");
    doIndent(out, level+3); out.write("<input type=\"checkbox\" name=\"todo\" value=\"{xforms:value}\">\n");
    doIndent(out, level+4); out.write("<xsl:value-of select=\"xforms:label\"/> </input>\n");
    doIndent(out, level+2); out.write("</xsl:otherwise>\n");
    doIndent(out, level+1); out.write("</xsl:choose>\n");
    doIndent(out, level); out.write("</xsl:template>\n");
  }


  protected void tableStart(Writer out) throws IOException {
    tableStart(out, 0, "100%");
  }

  protected void tableStart(Writer out, int border, String width) throws IOException {
    StringBuffer buf = new StringBuffer();
    buf.append("<table class=\"as_table\" cellpadding=\"1\" cellspacing=\"1\" border=\"").append(border).append("\" width=\"");
    buf.append(width).append("\">\n");
    out.write(buf.toString());
  }

  protected void tableEnd(Writer out) throws IOException {
    out.write("</table>\n");
  }

  protected void tableRowStart(Writer out) throws IOException {
    out.write("<tr>\n");
  }

  protected void tableRowEnd(Writer out) throws IOException {
    out.write("</tr>\n");
  }

  protected void columnStartWithWidth(Writer out, int colIdx, int totColCount) throws IOException {
    StringBuffer buf = new StringBuffer();
    if ( (colIdx + 1) == totColCount)
    {
      out.write("<td class=\"as_td\">");
    }else {
      int percentage = 100 / totColCount;
      buf.append("<td class=\"as_td\" width=\"").append(percentage).append("%\"> ");
      out.write(buf.toString());
    }
  }

  protected void columnStart(Writer out, int colSpan) throws IOException {
    StringBuffer buf = new StringBuffer();
    buf.append("<td colspan=\"").append(colSpan).append("\"> ");
    out.write(buf.toString());
  }

  protected void columnEnd(Writer out) throws IOException {
    out.write("</td>\n");
  }
}