package caslayout.codegen;

/**
 * Represents a Table column in the online form.
 * @author I. Burak Ozyurt
 * @version $Id: TDColumn.java,v 1.2 2004/11/09 22:18:06 bozyurt Exp $
 */

public class TDColumn {
  protected String width;
  protected String align;
  protected int colSpan = -1;
  protected int col;
  protected int row;

  public TDColumn() {}

  public String tagStart() {
    StringBuffer sb = new StringBuffer();
    sb.append("<td class=\"as_td\"");
    if ( width != null) {
      sb.append(" width=\"").append(width).append("\"");
    }
    if ( colSpan > 0) {
      sb.append(" colSpan=\"").append(colSpan).append("\"");
    }
    if ( align != null)
      sb.append(" align=\"").append(align).append("\"");

    sb.append('>');
    return sb.toString();
  }

  public String tagEnd() { return "</td>"; }


//---------------------- setters --------------
  public void setWidth(String newWidth) { this.width = newWidth; }
  public void setAlign(String newAlign) { this.align = newAlign; }
  public void setColSpan(int newColSpan) { this.colSpan = newColSpan; }
  public void setCol(int newCol) { this.col = newCol; }
  public void setRow(int newRow) { this.row = newRow; }
//---------------------- getters --------------
  public String getWidth() { return this.width; }
  public String getAlign() { return this.align; }
  public int getColSpan() { return this.colSpan; }
  public int getCol() { return this.col; }
  public int getRow() { return this.row; }

}