package caslayout.codegen.struts;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.jdom.Element;
import org.jdom.input.SAXBuilder;

import caslayout.codegen.StrutsStyleSheetGenerator;
import caslayout.codegen.XFormsGenerator;
import caslayout.ui.CAPanel;
import caslayout.ui.Document;
import caslayout.ui.Page;
import caslayout.ui.model.AssessmentAssociation;
import caslayout.ui.model.AssociationHelper;
import caslayout.util.GenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StrutsCodeGenerator.java,v 1.16 2008/10/13 23:58:06 bozyurt Exp $
 */
public class StrutsCodeGenerator {
   protected StrutsCodegenConfig config;
   protected Document doc;
   protected final static String EOL = System.getProperty("line.separator");

   public StrutsCodeGenerator(StrutsCodegenConfig config, Document doc) {
      this.config = config;
      this.doc = doc;
   }

   public void generateFormBean() throws StrutsCodeGeneratorException {
      FormBeanGenerator gen;
      File file = new File(config.getSourceCodeRoot(), config.getPackageName()
            .replace('.', File.separatorChar)
            + File.separator + config.getFormBeanName() + ".java");
      BufferedWriter out = null;
      try {
         gen = new FormBeanGenerator(AssociationHelper.getInstance(), config,
               doc);
         out = new BufferedWriter(new FileWriter(file));

         gen.generate(out);

      } catch (Exception x) {
         x.printStackTrace();
         throw new StrutsCodeGeneratorException(x.getMessage());
      } finally {
         if (out != null)
            try {
               out.close();
            } catch (Exception x) {}
      }
   }

   public void generateXForms() throws StrutsCodeGeneratorException {
      AssessmentAssociation aa = AssociationHelper.getInstance().getAsAssoc();
      String fileNameRoot = GenUtils.toFilename(aa.getLeft().getName());

      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = iter.next();
         CAPanel panel = page.getViewPanel();
         XFormsGenerator gen = new XFormsGenerator(panel);
         String xformFileName = config.getGeneratedCodeDir() + File.separator
               + fileNameRoot + "_" + page.getNumber() + ".xml";
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(xformFileName));
            bout.write(out.toString());
         } catch (Exception x) {
            x.printStackTrace();
            throw new StrutsCodeGeneratorException(x.getMessage());

         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
      }
   }

   public void generateJSPs() throws StrutsCodeGeneratorException {
      BufferedWriter bout = null;
      int idx = 0;
      int pageIdx = 1;
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = iter.next();
         CAPanel panel = page.getViewPanel();

         String jspPath = config.getJspCodeRoot() + File.separator
               + config.getJspPageNames()[idx];

         StrutsJSPGenerator gen = null;
         StringWriter out = new StringWriter(20000);
         try {
            gen = new StrutsJSPGenerator(panel, config, pageIdx);
            gen.generate(out);
            bout = new BufferedWriter(new FileWriter(jspPath), 1024);
            bout.write(out.toString());
         } catch (IOException iox) {
            iox.printStackTrace();
            throw new StrutsCodeGeneratorException(iox.getMessage());

         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }

         ++idx;
         ++pageIdx;
      }
   }

   public void generateStyleSheet() throws StrutsCodeGeneratorException {
      AssessmentAssociation aa = AssociationHelper.getInstance().getAsAssoc();
      String fileNameRoot = GenUtils.toFilename(aa.getLeft().getName());

      int pageIdx = 1;
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page =  iter.next();
         CAPanel panel = page.getViewPanel();
         StrutsStyleSheetGenerator gen = new StrutsStyleSheetGenerator(panel,
               config, pageIdx);
         String xslFileName = config.getGeneratedCodeDir() + File.separator
               + fileNameRoot + "_" + page.getNumber() + ".xsl";
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(xslFileName));
            bout.write(out.toString());
         } catch (Exception x) {
            x.printStackTrace();
            throw new StrutsCodeGeneratorException(x.getMessage());

         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
         ++pageIdx;
      }// for
   }

   public void generateTilesJspPages() throws StrutsCodeGeneratorException {
      for (int i = 0; i < config.getJspPageNames().length; i++) {
         generateJspForTilesFramework(config.getJspPageNames()[i]);
      }
   }

   public void doXSLTransform() throws StrutsCodeGeneratorException {
      AssessmentAssociation aa = AssociationHelper.getInstance().getAsAssoc();
      String fileNameRoot = GenUtils.toFilename(aa.getLeft().getName());

      TransformerFactory factory = TransformerFactory.newInstance();
      BufferedOutputStream out = null;
      int idx = 0;
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = iter.next();
         String xformFileName = config.getGeneratedCodeDir() + File.separator
               + fileNameRoot + "_" + page.getNumber() + ".xml";
         String xslFileName = config.getGeneratedCodeDir() + File.separator
               + fileNameRoot + "_" + page.getNumber() + ".xsl";

         String jspPath = config.getJspCodeRoot() + File.separator
               + config.getJspPageNames()[idx];

         try {
            Transformer transformer = factory.newTransformer(new StreamSource(
                  xslFileName));

            out = new BufferedOutputStream(new FileOutputStream(jspPath));

            transformer.transform(new StreamSource(xformFileName),
                  new StreamResult(out));
         } catch (Exception x) {
            x.printStackTrace();
            throw new StrutsCodeGeneratorException(x.getMessage());
         } finally {
            if (out != null)
               try {
                  out.close();
               } catch (Exception x) {}
         }
         try {
            fixNameSpaceBug(jspPath);
         } catch (IOException iox) {
            iox.printStackTrace();
            throw new StrutsCodeGeneratorException(iox.getMessage());
         }
         ++idx;
      } // for
   }

   protected void fixNameSpaceBug(String jspPath) throws IOException {
      String backupFile = jspPath + ".bak";
      BufferedReader in = null;
      BufferedWriter out = null;
      try {
         in = new BufferedReader(new FileReader(jspPath));
         out = new BufferedWriter(new FileWriter(backupFile));
         String line = null;
         while ((line = in.readLine()) != null) {
            if (line.indexOf("xmlns") != -1) {
               line = line.replaceAll("xmlns:html=\"dummy\"", " ");
            }
            out.write(line);
            out.newLine();
         }
      } finally {
         if (in != null)
            try {
               in.close();
            } catch (Exception x) {}
         if (out != null)
            try {
               out.close();
            } catch (Exception x) {}
      }
      new File(jspPath).delete();
      File f = new File(backupFile);
      f.renameTo(new File(jspPath));

   }

   public void generateJspForTilesFramework(String jspName)
         throws StrutsCodeGeneratorException {
      int idx = jspName.lastIndexOf(".jsp");
      String tilesJSPName = jspName;
      if (idx != -1) {
         tilesJSPName = jspName.substring(0, idx);
         tilesJSPName += "_full.jsp";
      }
      String tilesJSPPath = config.getJspCodeRoot() + "/" + tilesJSPName;
      BufferedWriter out = null;
      try {
         out = new BufferedWriter(new FileWriter(tilesJSPPath));

         out.write("<%@ page language=\"java\" %>");
         out.newLine();
         out
               .write("<%@ taglib uri=\"/WEB-INF/struts-tiles.tld\" prefix=\"tiles\" %>");
         out.newLine();
         out
               .write("<%@ taglib uri=\"/WEB-INF/struts-logic.tld\" prefix=\"logic\" %>");
         out.newLine();
         out
               .write("<%@ taglib uri=\"/WEB-INF/loci-sec.tld\" prefix=\"sec\" %>");
         out.newLine();
         out.write("<sec:checkLogon/>");
         out.newLine();
         out.write("<tiles:insert definition=\".mainLayout\" flush=\"true\">");
         out.newLine();
         out.write("\t<tiles:put name=\"title\" value=\"\"/>");
         out.newLine();
         out.write("  <tiles:put name=\"body\" value=\"");
         out.write(config.getRelativeJspPath() + "/" + jspName);
         out.write("\"/>");
         out.newLine();
         out.write("</tiles:insert>");
         out.newLine();

      } catch (IOException iox) {
         iox.printStackTrace();
         throw new StrutsCodeGeneratorException(iox.getMessage());
      } finally {
         if (out != null)
            try {
               out.close();
            } catch (Exception x) {}
      }
   }

   public void integrateWithWebApp() throws StrutsCodeGeneratorException {
      try {
         StrutsCodegenHelper helper = new StrutsCodegenHelper(config);
         helper.updateConstantsJavaFile();
         helper.updateCADispatcherActionJavaFile();
         helper.updateStrutsConfigTemplateFile();
      } catch (Exception x) {
         throw new StrutsCodeGeneratorException(x);
      }
   }

   public void updateStrutsConfigFile() throws StrutsCodeGeneratorException {
      String configFile = config.getStrutsConfigFile();

      File tempFile = null;
      BufferedReader in = null;
      BufferedWriter out = null;

      boolean allActionsUpdated = false;
      boolean hasDelimiters = hasGeneratedSections(configFile);

      try {
         // check for already existing form beans and/or actions
         ExistingActionFormInfo eai = hasTheConfiguration(configFile);
         // check everything is already there
         if (eai.foundActionMappings.size() == config.getJspPageNames().length
               && eai.foundFormBean) {
            System.out.println("Already updated. Skipping update.");
            return;
         }

         if (eai.foundActionMappings.size() == config.getJspPageNames().length)
            allActionsUpdated = true;

         tempFile = File.createTempFile("calm", ".xml");
         in = new BufferedReader(new FileReader(configFile));
         out = new BufferedWriter(new FileWriter(tempFile));
         System.out.println("writing the config file to tempFile " + tempFile);
         String line = null;
         boolean inFormBeans = false;
         boolean inActionMapping = false;
         boolean inGeneratedSection = false;

         while ((line = in.readLine()) != null) {
            if (line.indexOf("<form-beans>") != -1) {
               inFormBeans = true;
            } else if (line.indexOf("</form-beans>") != -1) {
               inFormBeans = false;
            } else if (line.indexOf("<action-mappings>") != -1) {
               inActionMapping = true;
            } else if (line.indexOf("</action-mappings>") != -1) {
               inActionMapping = false;
            } else if (line.indexOf("<!-- CALM generated start -->") != -1) {
               inGeneratedSection = true;
            }

            if (inFormBeans && inGeneratedSection) {
               out.write(line);
               out.newLine();
               if (!eai.foundFormBean) {
                  out.newLine();
                  // write the form bean declaration
                  prepareFormBeanDeclaration(out, !hasDelimiters);
               }
               inFormBeans = false;
               inGeneratedSection = false;
            } else if (inActionMapping && inGeneratedSection) {
               out.write(line);
               out.newLine();
               if (!allActionsUpdated) {
                  out.newLine();
                  prepareActionMappingDeclarations(out, !hasDelimiters, eai);
               }
               inGeneratedSection = false;
               inActionMapping = false;
            } else if (inFormBeans && !hasDelimiters) {
               if (!eai.foundFormBean) {
                  prepareFormBeanDeclaration(out, !hasDelimiters);
               }
               inFormBeans = false;
            } else if (inActionMapping && !hasDelimiters) {
               if (!allActionsUpdated) {
                  prepareActionMappingDeclarations(out, !hasDelimiters, eai);
               }
               inActionMapping = false;
            } else {
               out.write(line);
               out.newLine();
            }

         } // while

      } catch (Exception x) {
         x.printStackTrace();
         throw new StrutsCodeGeneratorException(x.getMessage());
      } finally {
         if (in != null)
            try {
               in.close();
            } catch (Exception x) {}
         if (out != null)
            try {
               out.close();
            } catch (Exception x) {}
      }

      // rename the original config file and copy the temp file to the struts
      // config file
      File origFile = new File(configFile);
      String bakFilename = origFile.getAbsolutePath() + ".bak";
      if (origFile.renameTo(new File(bakFilename))) {
         try {
            GenUtils.copyFile(tempFile.getAbsolutePath(), configFile);
            tempFile.delete();
         } catch (IOException iox) {
            iox.printStackTrace();
            throw new StrutsCodeGeneratorException(iox.getMessage());
         }
      } else {
         try {
            GenUtils.copyFile(origFile.getAbsolutePath(), bakFilename);
            GenUtils.copyFile(tempFile.getAbsolutePath(), configFile);
            tempFile.delete();
         } catch (IOException iox) {
            iox.printStackTrace();
            throw new StrutsCodeGeneratorException(iox.getMessage());
         }

      }

   }

   protected void prepareFormBeanDeclaration(BufferedWriter out,
         boolean putGeneratedDelimiters) throws IOException {
      if (putGeneratedDelimiters) {
         out.newLine();
         out.write("<!-- CALM generated start -->");
         out.newLine();
         out.newLine();
      }
      out.write(prepareFormBeanDeclaration());
      out.newLine();
      out.newLine();
      if (putGeneratedDelimiters) {
         out.newLine();
         out.write("<!-- CALM generated end -->");
         out.newLine();
         out.newLine();
      }
   }

   protected String prepareFormBeanDeclaration() {
      StringBuffer buf = new StringBuffer(128);
      buf.append("<form-bean name=\"").append(config.formBeanID).append(
            "\" type=\"");
      String fullyQualifiedClassName = config.getPackageName() + "."
            + config.getFormBeanName();
      buf.append(fullyQualifiedClassName);
      buf.append("\"/>");
      return buf.toString();
   }

   protected void prepareActionMappingDeclarations(BufferedWriter out,
         boolean putGeneratedDelimiters, ExistingActionFormInfo eai)
         throws IOException {
      if (putGeneratedDelimiters) {
         out.newLine();
         out.write("<!-- CALM generated start -->");
         out.newLine();
         out.newLine();
      }
      int numPages = config.getJspPageNames().length;
      for (int i = 0; i < config.getJspPageNames().length; i++) {
         String jspName = config.getJspPageNames()[i];
         String prevJSPPage = null;
         String nextJSPPage = null;
         if (i > 0) {
            prevJSPPage = config.getJspPageNames()[i - 1];
         }
         if (i < numPages - 1) {
            nextJSPPage = config.getJspPageNames()[i + 1];
         }
         // only add the nonexistent Struts actions
         if (eai.foundActionMappings.get(jspName) == null) {
            String s = prepareActionMappingDeclaration(i, numPages == 1,
                  prevJSPPage, nextJSPPage);
            out.write(s);
            out.newLine();
            out.newLine();
         }
      }
      if (putGeneratedDelimiters) {
         out.newLine();
         out.write("<!-- CALM generated end -->");
         out.newLine();
         out.newLine();
      }
   }

   protected String prepareActionMappingDeclaration(int pageIdx,
         boolean singlePage, String prevJSPPage, String nextJSPPage) {
      StringBuffer buf = new StringBuffer(256);
      buf.append("\t<action  path=\"");
      String suffix = (singlePage) ? "" : "_Page" + (pageIdx + 1);
      String actionPath = config.getStrutsActionRoot() + suffix;
      buf.append(actionPath).append("\"").append(EOL);
      buf.append("\t\ttype=\"clinical.web.game.AssessmentManagementAction\"")
            .append(EOL);
      buf.append("\t\tname=\"").append(config.getFormBeanID()).append("\"")
            .append(EOL);
      buf.append("\t\tparameter=\"action\"").append(EOL);
      buf.append("\t\tscope=\"session\"").append(EOL);
      String jspName = config.getJspPageNames()[pageIdx];

      String tilesJSPPath = toTilesJSPPath(jspName);

      buf.append("\t\tinput=\"").append(tilesJSPPath).append("\">").append(EOL);

      buf.append("\t\t<forward name=\"success\" path=\"").append(tilesJSPPath)
            .append("\"/>").append(EOL);
      if (prevJSPPage != null) {
         buf.append("\t\t<forward name=\"previous_page\" path=\"");
         buf.append(toTilesJSPPath(prevJSPPage)).append("\"/>").append(EOL);
      }
      if (nextJSPPage != null) {
         buf.append("\t\t<forward name=\"next_page\" path=\"");
         buf.append(toTilesJSPPath(nextJSPPage)).append("\"/>").append(EOL);
      } else {
         // on submit the following forward directive is used by Struts
         buf.append("\t\t<forward name=\"back\" path=\"");
         buf.append(config.getSubmitReturnPage()).append("\"/>").append(EOL);
      }

      buf.append("\t\t<forward name=\"failure\" path=\"").append(tilesJSPPath)
            .append("\"/>").append(EOL);

      buf.append("\t</action>");
      return buf.toString();
   }

   protected String toTilesJSPPath(String jspName) {
      StringBuffer sb = new StringBuffer(80);
      sb.append(config.getRelativeJspPath()).append("/");
      int idx = jspName.lastIndexOf(".jsp");
      if (idx != -1) {
         sb.append(jspName.substring(0, idx));
         sb.append("_full.jsp");
      } else {
         sb.append(jspName);
      }
      return sb.toString();
   }

   protected boolean hasGeneratedSections(String configFile) {
      BufferedReader in = null;
      boolean inFormBeans = false;
      boolean inActionMapping = false;
      boolean inGeneratedSection = false;
      int count = 0;
      try {
         in = new BufferedReader(new FileReader(configFile));
         String line = null;
         while ((line = in.readLine()) != null) {
            if (line.indexOf("<form-beans>") != -1) {
               inFormBeans = true;
            } else if (line.indexOf("</form-beans>") != -1) {
               inFormBeans = false;
            } else if (line.indexOf("<action-mappings>") != -1) {
               inActionMapping = true;
            } else if (line.indexOf("</action-mappings>") != -1) {
               inActionMapping = false;
            } else if (line.indexOf("<!-- CALM generated start -->") != -1) {
               inGeneratedSection = true;
            }

            if (inFormBeans && inGeneratedSection) {
               count++;
               inGeneratedSection = false;
            }
            if (inActionMapping && inGeneratedSection) {
               count++;
               inGeneratedSection = false;
            }
            if (count == 2)
               return true;

         }
      } catch (Exception x) {
         x.printStackTrace();
         return false;
      } finally {
         if (in != null)
            try {
               in.close();
            } catch (Exception x) {}
      }
      return false;
   }

   protected ExistingActionFormInfo hasTheConfiguration(String configFile)
         throws Exception {
      ExistingActionFormInfo eai = new ExistingActionFormInfo();

      SAXBuilder builder = null;

      builder = new SAXBuilder(false);
      // avoid external DTD hickups
      builder.setFeature(
            "http://apache.org/xml/features/nonvalidating/load-external-dtd",
            false);

      org.jdom.Document doc = builder.build(configFile);
      Element rootElem = doc.getRootElement();
      Element fbsElem = rootElem.getChild("form-beans");
      List<?> fbElemList = fbsElem.getChildren("form-bean");

      // String fullyQualifiedClassName = config.getPackageName() + "." +
      // config.getFormBeanName();
      for (Iterator<?> iter = fbElemList.iterator(); iter.hasNext();) {
         Element fbElem = (Element) iter.next();
         if (fbElem.getAttributeValue("name").equals(config.getFormBeanID())) {
            eai.foundFormBean = true;
            break;
         }
      }

      List<?> amElemList = rootElem.getChild("action-mappings").getChildren(
            "action");
      for (Iterator<?> iter = amElemList.iterator(); iter.hasNext();) {
         Element amElem = (Element) iter.next();
         String path = amElem.getAttributeValue("input");
         if (path == null)
            continue;
         int numPages = config.getJspPageNames().length;
         for (int i = 0; i < numPages; i++) {
            String tilesJSPName = getTilesJSPName(i);
            if (path.indexOf(tilesJSPName) != -1) {
               eai.addActionMapping(config.getJspPageNames()[i]);
               break;
            }
         }
      }
      return eai;
   }

   protected String getTilesJSPName(int pageIdx) {
      String jspName = config.getJspPageNames()[pageIdx];
      int idx = jspName.lastIndexOf(".jsp");
      if (idx != -1) {
         jspName = jspName.substring(0, idx);
         jspName += "_full.jsp";
      }
      return jspName;
   }

   public static class ExistingActionFormInfo {
      boolean foundFormBean;
      Map<String, String> foundActionMappings = new LinkedHashMap<String, String>(11);

      public void addActionMapping(String name) {
         foundActionMappings.put(name, name);
      }
   }
}
