package caslayout.codegen.struts;

import java.io.File;
import java.io.IOException;

import caslayout.codegen.SourceFile;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StrutsCodegenHelper.java,v 1.5 2007/10/08 18:00:40 bozyurt Exp $
 */
public class StrutsCodegenHelper {
   protected StrutsCodegenConfig config;

   public StrutsCodegenHelper(StrutsCodegenConfig config) {
      this.config = config;
   }

   public void updateConstantsJavaFile() throws IOException {
      File file = new File(config.getSourceCodeRoot(), "clinical.web".replace(
            '.', File.separatorChar) + File.separatorChar + "Constants.java");
      String dispatcherLabel = "to_"
            + config.getFormBeanID().replaceFirst("Form$", "");
      String dispatcherConstantName = dispatcherLabel.toUpperCase();
      SourceFile sf = new SourceFile(file);
      String constantDef = "public final static String "
            + dispatcherConstantName + " = \"" + dispatcherLabel + "\";";
      sf.load();
      int idx = sf.indexOfRegex("start\\s+of\\s+Dispatcher\\s+Constants");
      if (idx != -1) {
         // System.out.println( sf.getLineAt(idx));
         String regex = toRegex("public final static String "
               + dispatcherConstantName);
         regex += "\\s+";
         int matchIdx = sf.indexOfRegex(regex, idx);
         if (matchIdx == -1) {
            int indent = sf.getLineIndentAt(idx);
            StringBuffer buf = new StringBuffer();
            addIndent(indent, buf);
            buf.append(constantDef);
            sf.insertLineAfter(buf.toString(), idx);
            // make a backup also
            sf.save(true);
            System.out.println("Updated " + file);
         } 
      } else {
    	  System.out.println("No changes necessary for " + file);
      }
   }

   public void updateCADispatcherActionJavaFile() throws IOException {
      File file = new File(config.getSourceCodeRoot(), "clinical.web.actions"
            .replace('.', File.separatorChar) + File.separatorChar 
            + "CADispatcherAction.java");
      String formBeanVarName = config.getFormBeanID();
      SourceFile sf = new SourceFile(file);
      sf.load();
      int idx = sf
            .indexOfRegex("if\\s+\\(formBeanName\\.equals\\(\\s*\"\\w+\"\\)");
      if (idx != -1) {
         int matchIdx = sf.indexOfRegex(
               "if\\s+\\(\\s*formBeanName\\.equals\\(\\s*\"" + formBeanVarName
                     + "\"\\s*\\)", idx);
         if (matchIdx == -1) {
            int elseIdx = sf.indexOfRegex("}\\s+else\\s+\\{");
            assert (elseIdx != -1);
            int indent = sf.getLineIndentAt(elseIdx);
            StringBuffer buf = new StringBuffer();
            String dispatcherConstName = "TO_"
                  + config.getFormBeanID().replaceFirst("Form$", "")
                        .toUpperCase();
            addIndent(indent, buf);
            buf.append("} else if ( formBeanName.equals(\"").append(
                  formBeanVarName).append("\")) {");
            String line = buf.toString();
            sf.insertLineBefore(line, elseIdx);
            buf = new StringBuffer();
            addIndent(indent, buf);
            buf.append("    return mapping.findForward(Constants.").append(
                  dispatcherConstName).append(");");
            line = buf.toString();
            sf.insertLineAfter(line, elseIdx);

            sf.save(true);
            System.out.println("Updated " + file);
         } else {
        	 System.out.println("No changes necessary for " + file);
         }
      }
   }

   public void updateStrutsConfigTemplateFile() throws IOException {
      File file = new File(config.getStrutsConfigFile());
      SourceFile sf = new SourceFile(file);
      sf.load();
      int startIdx = sf.indexOfRegex("<action\\s+path=\"/cadispatcher\"");
      if (startIdx != -1) {
         int endIdx = sf.indexOf("</action>", startIdx + 1);
         assert (endIdx != -1);
         int locIdx = sf.indexOfRegex(
                     "<forward\\s+name=\"failure\"\\s+path=\"/pages/SegmentMan_full\\.jsp\"/>",
                     startIdx + 1);
         assert (locIdx != -1);
         int insertLocIdx = sf.indexOfFirstNonEmptyLineBefore(locIdx);
         assert (insertLocIdx != -1);
         int indent = sf.getLineIndentAt(insertLocIdx);

         // <forward name="to_hematocrit" path="/man_hf.do?action=Display"/>
         boolean singlePage = config.getJspPageNames().length == 1;
         String suffix = (singlePage) ? "" : "_Page1";
         String actionPath = config.getStrutsActionRoot() + suffix
               + ".do?action=Display";
         String dispatcherLabel = "to_"
               + config.getFormBeanID().replaceFirst("Form$", "");
         StringBuffer buf = new StringBuffer();
         addIndent(indent, buf);
         buf.append("<forward name=\"").append(dispatcherLabel).append(
               "\" path=\"");
         buf.append(actionPath).append("\"/>");
         
         // check if the forward definition exists
         String regex = toRegex( buf.toString() );
         int matchIdx = sf.indexOfRegex(regex, startIdx + 1);
         if ( matchIdx == -1) {
            sf.insertLineAfter(buf.toString(), insertLocIdx);
            // save with backup
            sf.save(true);
            System.out.println("Updated " + file);
         }         
      } else {
    	  System.out.println("No changes necessary for " + file);
      }
   }

   private void addIndent(int indent, StringBuffer buf) {
      if (indent > 0) {
         for (int i = 0; i < indent; i++) {
            buf.append(' ');
         }
      }
   }
   
   public static String toRegex(String pattern) {
      StringBuffer buf = new StringBuffer();
      char[] carr = pattern.toCharArray();
      boolean inWS = false;
      for (int i = 0; i < carr.length; i++) {
         if ( Character.isWhitespace(carr[i]) ) {
            if ( !inWS) {
               buf.append("\\s+");
            }
            inWS = true;
         } else if ( carr[i] == '.') {
            inWS = false;
            buf.append("\\.");
         } else if (carr[i] == '?') {
            inWS = false;
            buf.append("\\?");
         } else {
            inWS = false;
            buf.append(carr[i]);
         }
      }
      return buf.toString();
   }
}
