package caslayout.importing.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Assessment.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class Assessment {
   protected String name;
   protected List<Score> scores = new ArrayList<Score>();
   protected Map<String, Score> scoreMap;

   public Assessment(String name) {
      super();
      this.name = name;
   }

   public void addScore(Score score) {
      if (!scores.contains(score)) {
         scores.add(score);
      }
   }

   public String getName() {
      return name;
   }

   public List<Score> getScores() {
      return scores;
   }

   public Score findScore(String scoreName) {
      if (scores.isEmpty())
         return null;
      if (scoreMap == null) {
         scoreMap = new HashMap<String, Score>(17);
         for (Iterator<Score> iter = scores.iterator(); iter.hasNext();) {
            Score score = iter.next();
            scoreMap.put(score.getName(), score);
         }
      }

      return scoreMap.get(scoreName);
   }

   public Score findScoreByQuestion(String question) {
      for (Iterator<Score> iter = scores.iterator(); iter.hasNext();) {
         Score score = iter.next();
         if (score.getQuestion().equals(question)) {
            return score;
         }
      }
      return null;
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      buf.append("Assessment::[");
      buf.append("name=").append(name);
      for (Iterator<Score> iter = scores.iterator(); iter.hasNext();) {
         Score score = iter.next();
         buf.append("\n").append(score);
      }
      buf.append(']');
      return buf.toString();
   }

   public Element toCALM(ImportConfig config) {
      Element calmElem = new Element("calm");
      calmElem.setAttribute("version", "1.0");
      Element asElem = new Element("assessment");
      asElem.setAttribute("version", "1.0");
      calmElem.addContent(asElem);
      Element nameElem = new Element("name");
      nameElem.addContent(name);
      asElem.addContent(nameElem);
      Element pagesElem = new Element("pages");
      asElem.addContent(pagesElem);
      List<Integer> pageNoList = new ArrayList<Integer>(config.getPageScoreMap().keySet());
      Collections.sort(pageNoList);
      Map<String, Score> scoreMap = new HashMap<String, Score>();
      for (Iterator<Score> iter = scores.iterator(); iter.hasNext();) {
         Score score = iter.next();
         scoreMap.put(score.getName(), score);
      }
      int qIdx = 1;
      for (Iterator<Integer> iter = pageNoList.iterator(); iter.hasNext();) {
         Integer pageNo = iter.next();
         Element pageElem = new Element("page");
         pageElem.setAttribute("no", pageNo.toString());
         pagesElem.addContent(pageElem);
         if (config.isHavePageTitle()) {
            Element titleElem = new Element("title");
            titleElem.addContent(name);
            pageElem.addContent(titleElem);
         }
         LinkedHashSet<String> scoreNameSet = config.getScoreSet(pageNo);
         for (String scoreName : scoreNameSet) {
            Score score = scoreMap.get(scoreName);
            assert (score != null) : scoreName;
            String questionID = "q" + qIdx;
            Element qElem = score.toCALM(questionID, config);
            pageElem.addContent(qElem);
            ++qIdx;
         }
      }

      return calmElem;
   }

   public void setName(String asName) {
      this.name = asName;
   }
}
