package caslayout.importing.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import caslayout.ui.builder.Location;
import caslayout.ui.builder.Orientation;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ImportConfig.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class ImportConfig implements Serializable {
   protected String scaFilename;
   protected String importExcelFile;
   protected Location location;
   protected Orientation orientation;
   protected boolean preferDropDown = false;
   protected boolean havePageTitle = true;
   protected String assessmentName;
   protected Map<Integer, Set<String>> pageScoreMap = new HashMap<Integer, Set<String>>(
         17);
   private static final long serialVersionUID = 1L;

   public void addPageScore(int pageNo, String scoreName) {
      Set<String> scoreNameSet = pageScoreMap.get(new Integer(pageNo));
      if (scoreNameSet == null) {
         scoreNameSet = new LinkedHashSet<String>(17);
         pageScoreMap.put(new Integer(pageNo), scoreNameSet);
      }
      scoreNameSet.add(scoreName);
   }

   public LinkedHashSet<String> getScoreSet(Integer pageNo) {
      return (LinkedHashSet<String>) pageScoreMap.get(pageNo);
   }

   public Location getLocation() {
      return location;
   }

   public Orientation getOrientation() {
      return orientation;
   }

   public String getScaFilename() {
      return scaFilename;
   }

   public void setLocation(Location location) {
      this.location = location;
   }

   public void setOrientation(Orientation orientation) {
      this.orientation = orientation;
   }

   public void setScaFilename(String scaFilename) {
      this.scaFilename = scaFilename;
   }

   public Map<Integer, Set<String>> getPageScoreMap() {
      return pageScoreMap;
   }

   public String getImportExcelFile() {
      return importExcelFile;
   }

   public void setImportExcelFile(String importExcelFile) {
      this.importExcelFile = importExcelFile;
   }

   public boolean isPreferDropDown() {
      return preferDropDown;
   }

   public boolean isHavePageTitle() {
      return havePageTitle;
   }

   public void setPreferDropDown(boolean preferDropDown) {
      this.preferDropDown = preferDropDown;
   }

   public void setHavePageTitle(boolean havePageTitle) {
      this.havePageTitle = havePageTitle;
   }

   public String getAssessmentName() {
      return assessmentName;
   }

   public void setAssessmentName(String assessmentName) {
      this.assessmentName = assessmentName;
   }
}// ;
