package caslayout.importing.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Score.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class Score {
   protected String name;
   protected String question;
   protected int scoreSequence;
   protected String scoreType;
   protected LinkedHashMap<String, ScoreCode> scoreCodeMap = new LinkedHashMap<String, ScoreCode>(
         11);

   public Score(String name, String question, int scoreSequence,
         String scoreType) {
      super();
      this.name = name;
      this.question = question;
      this.scoreSequence = scoreSequence;
      this.scoreType = scoreType;
   }

   public String getName() {
      return name;
   }

   public String getQuestion() {
      return question;
   }

   public int getScoreSequence() {
      return scoreSequence;
   }

   public String getScoreType() {
      return scoreType;
   }

   public void addScoreCode(ScoreCode sc) {
      scoreCodeMap.put(sc.getScoreCode(), sc);
   }

   public boolean hasScoreCodes() {
      return !scoreCodeMap.isEmpty();
   }

   public List<ScoreCode> getScoreCodes() {
      return new ArrayList<ScoreCode>(scoreCodeMap.values());
   }

   public Element toCALM(String questionID, ImportConfig config) {
      Element scoreElem = new Element("q");
      scoreElem.setAttribute("id", questionID);
      scoreElem.setAttribute("bindingScore", name);
      scoreElem.setAttribute("scoreType", scoreType);
      Element textElem = new Element("text");
      scoreElem.addContent(textElem);
      if (question == null) {
         textElem.addContent(name + " :");
      } else {
         textElem.addContent(question);
      }
      Element agElem = new Element("answerGroup");
      scoreElem.addContent(agElem);
      agElem.setAttribute("location", config.getLocation().toString()
            .toLowerCase());
      agElem.setAttribute("orientation", config.getOrientation().toString()
            .toLowerCase());
      if (scoreCodeMap.isEmpty()) {
         agElem.setAttribute("compType", "text");
      } else {
         if (config.isPreferDropDown()) {
            agElem.setAttribute("compType", "dropdown");
            Element ansElem = new Element("answer");
            ansElem.setAttribute("label", "");
            agElem.addContent(ansElem);
            Element compElem = new Element("component");
            ansElem.addContent(compElem);
            Element lvSetElem = new Element("labelValueSet");
            compElem.addContent(lvSetElem);
            for (Iterator<ScoreCode> iter = scoreCodeMap.values().iterator(); iter
                  .hasNext();) {
               ScoreCode sc = iter.next();
               Element lvElem = new Element("lv");
               lvElem.setAttribute("label", sc.getScoreLabel());
               lvElem.setAttribute("value", sc.getScoreCode());
               lvSetElem.addContent(lvElem);
            }
         } else {
            agElem.setAttribute("compType", "radio");
            for (Iterator<ScoreCode> iter = scoreCodeMap.values().iterator(); iter
                  .hasNext();) {
               ScoreCode sc = iter.next();
               Element ansElem = new Element("answer");
               agElem.addContent(ansElem);
               ansElem.setAttribute("label", sc.getScoreLabel());
               ansElem.setAttribute("code", sc.getScoreCode());
            }
         }

      }

      return scoreElem;
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      buf.append("Score::[");
      buf.append("name=").append(name);
      buf.append(",scoreType=").append(scoreType);
      buf.append("\nquestion=").append(question);
      List<ScoreCode> scList = new ArrayList<ScoreCode>(scoreCodeMap.values());
      Collections.sort(scList, new Comparator<ScoreCode>() {
         public int compare(ScoreCode sc1, ScoreCode sc2) {
            return sc1.scoreCode.compareTo(sc2.scoreCode);
         }
      });
      for (Iterator<ScoreCode> iter = scList.iterator(); iter.hasNext();) {
         ScoreCode sc = iter.next();
         buf.append("\n").append(sc);
      }
      buf.append("\n]");
      return buf.toString();
   }
}
