package caslayout.importing.ui;

import guilib.common.BaseDialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.JButton;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.DataRow;
import caslayout.ui.db.services.AssessmentDataService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AsDataImportDialog.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class AsDataImportDialog extends BaseDialog {
   private static final long serialVersionUID = 1L;
   protected AsDataImportPanel mainPanel;

   public AsDataImportDialog(Frame owner, String title,
         AssessmentDataService ads) {
      super(owner, title, new String[] { "Cancel", "Upload" });
      super.setDefaultButton("Cancel");

      mainPanel = new AsDataImportPanel(ads);
      getContentPane().add(mainPanel);
      pack();
   }

   public List<DataRow> getDataRowList() {
      return mainPanel.getDataRowList();
   }

   public String getSelectedProtocol() {
      return mainPanel.getSelectedProtocol();
   }

   public String getImportedFile() {
      return mainPanel.getImportedFile();
   }

   public Assessment getAssessment() {
      return mainPanel.getAssessment();
   }

   public String[] getAsDataHeaders() {
      return mainPanel.getAsDataHeaders();
   }

   public void actionPerformed(ActionEvent event) {
      returnCode = BaseDialog.CANCEL_PRESSED;
      if (event.getSource() instanceof JButton) {
         JButton button = (JButton) event.getSource();
         if (button.getText().equalsIgnoreCase("upload")) {
            returnCode = BaseDialog.OK_PRESSED;
         }
      }
      setVisible(false);
   }

}
