package caslayout.importing.ui;

import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.DataRow;
import caslayout.importing.common.Score;
import caslayout.importing.excel.ExcelImporter;
import caslayout.ui.CALMHelper;
import caslayout.ui.db.Protocol;
import caslayout.ui.db.services.AssessmentDataService;
import caslayout.ui.wizard.IWizardUsable;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AsDataImportPanel.java,v 1.1.2.1 2007/08/08 00:39:45 bozyurt
 *          Exp $
 */
public class AsDataImportPanel extends JPanel implements ActionListener,
      IWizardUsable, PropertyChangeListener {
   private static final long serialVersionUID = 1L;
   protected FileNameValueField importedFileField;
   protected JLabel summaryLabel;
   protected JTextField expNameField;
   protected JTextField studyNameField;
   protected JComboBox protocolCB;
   protected JComboBox asNameCB;
   protected JLabel asNameLabel;
   protected DefaultComboBoxModel cbModel;
   protected DefaultComboBoxModel asNameCBModel;

   protected JButton importButton;
   protected AssessmentDataService ads;
   protected List<DataRow> dataRowList;
   protected Assessment assessment;
   protected String[] asDataHeaders;

   public AsDataImportPanel(AssessmentDataService ads) {
      setLayout(new BorderLayout(5, 5));
      setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

      this.ads = ads;
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      JPanel labelPanel = new JPanel(new GridLayout(4, 1, 5, 5));
      JPanel fieldPanel = new JPanel(new GridLayout(4, 1, 5, 5));
      asNameLabel = new JLabel("Assessment Name:", JLabel.RIGHT);
      labelPanel.add(asNameLabel);
      labelPanel.add(new JLabel("Experiment Name: ", JLabel.RIGHT));
      labelPanel.add(new JLabel("Study Name: ", JLabel.RIGHT));
      labelPanel.add(new JLabel("Protocol: ", JLabel.RIGHT));

      asNameCBModel = new DefaultComboBoxModel();
      fieldPanel.add(asNameCB = new JComboBox(asNameCBModel));
      asNameCB.setEditable(false);

      fieldPanel.add(expNameField = new JTextField(20));
      fieldPanel.add(studyNameField = new JTextField(20));
      studyNameField.setText("FMRI");
      studyNameField.setEditable(false);
      expNameField.setEditable(false);
      cbModel = new DefaultComboBoxModel();
      protocolCB = new JComboBox(cbModel);
      protocolCB.setEditable(false);
      fieldPanel.add(protocolCB);

      panel.add(labelPanel, BorderLayout.WEST);
      panel.add(fieldPanel);

      panel.add(summaryLabel = new JLabel("     "), BorderLayout.NORTH);

      add(panel);
      enableControlPanel(false);
      add(createImportPanel(), BorderLayout.NORTH);
   }

   protected void enableControlPanel(boolean value) {
      expNameField.setEnabled(value);
      studyNameField.setEnabled(value);
      protocolCB.setEnabled(value);
   }

   public void propertyChange(PropertyChangeEvent evt) {
      if (evt.getPropertyName().equals("value")) {
         String s = (String) evt.getNewValue();
         if (new File(s).isFile()) {
            importButton.setEnabled(true);
         }
      }
   }

   protected JPanel createImportPanel() {
      JPanel importPanel = new JPanel(new BorderLayout(5, 5));
      importPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

      JPanel labelPanel = new JPanel(new GridLayout(1, 1, 5, 5));
      JPanel fieldPanel = new JPanel(new GridLayout(1, 1, 5, 5));

      FileFilter excelFileFilter = new FileFilter() {
         public boolean accept(File f) {
            return f.getName().endsWith(".xls") || f.isDirectory();
         }

         public String getDescription() {
            return ".xls Files (Excel Assessment Worksheet Format)";
         }
      };

      labelPanel.add(new JLabel("Import: ", JLabel.RIGHT));
      importedFileField = new FileNameValueField(null, 20,
            FileNameValueField.BOTH_FILE_AND_DIR, excelFileFilter);
      importedFileField.addPropertyChangeListener(this);
      importButton = new JButton("Import");
      importButton.addActionListener(this);
      importButton.setEnabled(false);

      JPanel p = new JPanel();
      p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
      p.add(importedFileField);
      p.add(Box.createHorizontalStrut(5));
      p.add(importButton);
      p.add(Box.createHorizontalGlue());
      fieldPanel.add(p);

      importPanel.add(labelPanel, BorderLayout.WEST);
      importPanel.add(fieldPanel);

      return importPanel;
   }

   public void actionPerformed(ActionEvent e) {
      if (e.getSource() == importButton) {
         String xlsFile = importedFileField.getValue();
         if (new File(xlsFile).exists()) {
            try {
               ExcelImporter importer = new ExcelImporter(xlsFile);
               this.assessment = importer.importFromWorkSheet();
               if (!importer.getHasAssessmentData()) {
                  throw new Exception("No data for assessment '"
                        + assessment.getName() + "' has found!");
               }
               this.dataRowList = importer.loadAssessmentData();
               assert (!dataRowList.isEmpty());
               DataRow dr = (DataRow) dataRowList.get(0);
               this.asDataHeaders = prepHeaderColumns(dr);

               expNameField.setText(dr.getExperimentName());

               Map<Object, Object> protocolMap = ads.getProtocolMap();
               cbModel.removeAllElements();
               List<String> protocolIdList = new ArrayList<String>(protocolMap
                     .size());
               for (Iterator<Object> it = protocolMap.values().iterator(); it
                     .hasNext();) {
                  Protocol pr = (Protocol) it.next();
                  if (pr.getProtocolKey().getProtocolId() != null) {
                     protocolIdList.add(pr.getProtocolKey().getProtocolId());
                  }
               }
               Collections.sort(protocolIdList);
               for (Iterator<String> it = protocolIdList.iterator(); it
                     .hasNext();) {
                  String protocolId = it.next();
                  cbModel.addElement(protocolId);
               }

               summaryLabel.setText(dataRowList.size()
                     + " assessments to upload.");

               handleAsNameCB(importer);

               enableControlPanel(true);
            } catch (Exception x) {
               x.printStackTrace();
            }
         }
      }
   }

   protected void handleAsNameCB(ExcelImporter importer) {
      Map<Object, Object> asMap = ads.getAssessmentMap();

      List<String> asNames = new ArrayList<String>(asMap.size());
      for (Object o : asMap.keySet())
         asNames.add((String) o);
      Collections.sort(asNames);
      for (String asName : asNames) {
         asNameCBModel.addElement(asName);
      }

      if (asMap.get(importer.getAssessment().getName()) != null) {
         asNameCB.setSelectedItem(importer.getAssessment().getName());
      } else {
         String closestMatch = findClosestMatch(new ArrayList<String>(asNames),
               importer.getAssessment().getName());
         if (closestMatch == null) {
            CALMHelper.showError(this, "The assessment with name '"
                  + importer.getAssessment().getName()
                  + "' does not exists in the database!");
         } else {
            asNameCB.setSelectedItem(closestMatch);
            CALMHelper.showWarning(this,
                  "The closest matching assessment is shown.\nNo exact match for '"
                        + importer.getAssessment().getName() + "'!",
                  "No exact match");
            importer.getAssessment().setName(closestMatch);
         }
      }
   }

   protected String[] prepHeaderColumns(DataRow dr) {
      String[] header = new String[dr.getScores().length + 6];
      header[0] = "Site";
      header[1] = "subjectID";
      header[2] = "subjectType";
      header[3] = "experimentName";
      header[4] = "timeStamp";
      Score[] scores = dr.getScores();
      for (int i = 0; i < scores.length; i++) {
         header[i + 5] = scores[i].getName();
      }
      header[header.length - 1] = "errorText";

      return header;
   }

   public static String findClosestMatch(List<String> list, String toMatch) {
      for (Iterator<String> it = list.iterator(); it.hasNext();) {
         String s = it.next();
         if (s.startsWith(toMatch) || toMatch.startsWith(s)) {
            return s;
         }
      }
      return null;
   }

   public void beforeLeave() {
   // TODO Auto-generated method stub
   }

   public JPanel getMainPanel() {
      // TODO Auto-generated method stub
      return null;
   }

   public Object getPayload() {
      // TODO Auto-generated method stub
      return null;
   }

   public boolean hasNext() {
      return false;
   }

   public boolean hasPrevious() {
      // TODO Auto-generated method stub
      return false;
   }

   public void setPayload(Object payload) {
   // TODO Auto-generated method stub

   }

   public List<DataRow> getDataRowList() {
      return dataRowList;
   }

   public String getSelectedProtocol() {
      return (String) protocolCB.getSelectedItem();
   }

   public Assessment getAssessment() {
      return assessment;
   }

   public String getImportedFile() {
      return importedFileField.getValue();
   }

   public String[] getAsDataHeaders() {
      return asDataHeaders;
   }

}
