package caslayout.importing.ui;

import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.ImportConfig;
import caslayout.importing.common.ImportValidationException;
import caslayout.importing.common.Score;
import caslayout.importing.excel.ExcelImportInfo;
import caslayout.importing.excel.ExcelImporter;
import caslayout.ui.builder.Location;
import caslayout.ui.builder.Orientation;
import caslayout.ui.wizard.IWizardListener;
import caslayout.ui.wizard.IWizardUsable;
import caslayout.util.GUIUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CommonOptionsPanel.java,v 1.1.2.3 2007/07/13 00:56:45 bozyurt
 *          Exp $
 */
public class CommonOptionsPanel extends JPanel implements ActionListener,
      IWizardUsable {
   private static final long serialVersionUID = 1L;

   protected FileNameValueField importedFileField;
   // protected FileNameValueField scaFileField;
   protected JTextField scaFileField;

   protected JTextField asNameField;
   protected JToggleButton eastHorizTB, eastVertTB, westHorizTB, westVertTB,
         northHorizTB, northVertTB, southHorizTB, southVertTB;
   protected JCheckBox preferDropdownCB;
   protected JCheckBox havePageTitlesCB;
   protected boolean importedFileProvided, asNameProvided, scaFileProvided,
         layoutInfoProvided;
   protected FieldDocumentListener importFileFieldListener,
         scaFileFieldListener, asNameFieldListener;
   protected IWizardListener wizardListener;
   protected JToggleButton selectedLayout;
   protected List<String> questionList;
   protected PropertyChangeSupport pcs;
   protected ExcelImportInfo eii;
   protected String scaGenDir;

   public CommonOptionsPanel() {
      this(null, null);
   }

   public CommonOptionsPanel(String defaultDir, String scaGenDir) {
      this.scaGenDir = scaGenDir;

      setLayout(new BorderLayout(5, 5));
      setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

      ButtonGroup bg = new ButtonGroup();

      eastHorizTB = prepTB("east_horiz.png", "East-Horizontal", bg,
            "east_horiz_sel.png");
      eastVertTB = prepTB("east_vert.png", "East-Vertical", bg,
            "east_vert_sel.png");
      westHorizTB = prepTB("west_horiz.png", "West-Horizontal", bg,
            "west_horiz_sel.png");
      westVertTB = prepTB("west_vert.png", "West-Vertical", bg,
            "west_vert_sel.png");
      northHorizTB = prepTB("north_horiz.png", "North-Horizontal", bg,
            "north_horiz_sel.png");
      northVertTB = prepTB("north_vert.png", "North-Vertical", bg,
            "north_vert_sel.png");
      southVertTB = prepTB("south_vert.png", "South-Vertical", bg,
            "south_vert_sel.png");
      southHorizTB = prepTB("south_horiz.png", "South-Horizontal", bg,
            "south_horiz_sel.png");

      JPanel layoutPanel = new JPanel(new GridLayout(4, 2, 5, 5));
      layoutPanel.setBorder(GUIUtils.createTitledBorder("Question Layout"));

      layoutPanel.add(eastHorizTB);
      layoutPanel.add(eastVertTB);
      layoutPanel.add(westHorizTB);
      layoutPanel.add(westVertTB);
      layoutPanel.add(southHorizTB);
      layoutPanel.add(southVertTB);
      layoutPanel.add(northHorizTB);
      layoutPanel.add(northVertTB);

      JPanel asPanel = createAssesmentCommonOptionsPanel(defaultDir);
      JPanel preferencesPanel = createPreferencesPanel();

      add(asPanel, BorderLayout.NORTH);
      add(layoutPanel);
      add(preferencesPanel, BorderLayout.SOUTH);

      pcs = new PropertyChangeSupport(this);
   }

   public void addPropertyChangeListener(PropertyChangeListener pcl) {
      pcs.addPropertyChangeListener(pcl);
   }

   protected JPanel createAssesmentCommonOptionsPanel(String defaultDir) {
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      JPanel labelPanel = new JPanel(new GridLayout(3, 1, 5, 5));
      JPanel fieldPanel = new JPanel(new GridLayout(3, 1, 5, 5));

      labelPanel.add(new JLabel("Import: ", JLabel.RIGHT));
      labelPanel.add(new JLabel("CALM Filename (.calm): ", JLabel.RIGHT));
      labelPanel.add(new JLabel("Assessment Name: ", JLabel.RIGHT));

      FileFilter excelFileFilter = new FileFilter() {
         public boolean accept(File f) {
            return f.getName().endsWith(".xls") || f.isDirectory();
         }

         public String getDescription() {
            return ".xls Files (Excel Assessment Worksheet Format)";
         }
      };

      @SuppressWarnings("unused")
      FileFilter calmFileFilter = new FileFilter() {
         public boolean accept(File f) {
            return f.getName().endsWith(".calm");
         }

         public String getDescription() {
            return ".calm Files";
         }
      };
      fieldPanel.add(importedFileField = new FileNameValueField(null, 15,
            FileNameValueField.BOTH_FILE_AND_DIR, excelFileFilter));
      if (defaultDir != null) {
         importedFileField.setValue(defaultDir);
      }

      scaFileField = new JTextField(15);
      scaFileField.setEditable(false);
      fieldPanel.add(scaFileField);
      fieldPanel.add(asNameField = new JTextField(15));
      asNameFieldListener = new FieldDocumentListener(this, asNameField,
            FieldDocumentListener.NON_EMPTY_TYPE);
      asNameField.getDocument().addDocumentListener(asNameFieldListener);

      importFileFieldListener = new FieldDocumentListener(this,
            importedFileField, FieldDocumentListener.FILE_TYPE);
      importedFileField.getTextField().getDocument().addDocumentListener(
            importFileFieldListener);

      panel.add(labelPanel, BorderLayout.WEST);
      panel.add(fieldPanel);

      return panel;
   }

   protected JPanel createPreferencesPanel() {
      JPanel panel = new JPanel(new GridLayout(2, 1, 5, 5));

      panel.setBorder(GUIUtils.createTitledBorder("Preferences"));
      preferDropdownCB = new JCheckBox(
            "Prefer dropdown over radio box group for multiple choice questions");
      havePageTitlesCB = new JCheckBox("Add title to each page", true);
      havePageTitlesCB.setBackground(Color.lightGray);
      preferDropdownCB.setBackground(Color.lightGray);

      panel.add(preferDropdownCB);
      panel.add(havePageTitlesCB);
      return panel;
   }

   protected JToggleButton prepTB(String imageName, String altText,
         ButtonGroup bg) {
      return prepTB(imageName, altText, bg, null);
   }

   protected JToggleButton prepTB(String imageName, String altText,
         ButtonGroup bg, String selImageName) {
      String imgLocation = "/images/" + imageName;
      URL imageURL = CommonOptionsPanel.class.getResource(imgLocation);
      JToggleButton tb = null;
      if (imageURL != null) {
         tb = new JToggleButton(new ImageIcon(imageURL));
         if (selImageName != null) {

            URL selImgURL = CommonOptionsPanel.class.getResource("/images/"
                  + selImageName);
            if (selImgURL != null) {
               tb.setSelectedIcon(new ImageIcon(selImgURL));
            }
         }

      } else {
         tb = new JToggleButton(altText);
      }
      bg.add(tb);
      tb.addActionListener(this);
      return tb;
   }

   public void actionPerformed(ActionEvent e) {
      if (e.getSource() instanceof JToggleButton) {
         this.layoutInfoProvided = true;
         this.selectedLayout = (JToggleButton) e.getSource();
         canMove2NextScreen(null);
      }
   }

   public void canMove2NextScreen(FieldDocumentListener fdListener) {
      if (fdListener != null) {
         if (fdListener.getComp() == asNameField) {
            asNameProvided = fdListener.isComplete();
         } else if (fdListener.getComp() == importedFileField) {
            importedFileProvided = fdListener.isComplete();
         }
      }
      if (wizardListener != null) {
         wizardListener.disableNext(this);
      }
      if (importedFileProvided) {
         File f = new File(importedFileField.getValue());
         String calmFilename = f.getName().replaceFirst("\\.\\w+$", ".calm");
         File scaFile = new File(this.scaGenDir, calmFilename);
         scaFileField.setText(scaFile.getAbsolutePath());
      }

      if (layoutInfoProvided && asNameProvided && importedFileProvided) {
         try {

            if (eii == null) {
               prepareExcelImportInfo();
            } else {
               ImportConfig ic = eii.getImportConfig();
               ic.setScaFilename(scaFileField.getText());
               handleLocationOrientation(ic);
               if (!ic.getImportExcelFile()
                     .equals(importedFileField.getValue())) {
                  prepareExcelImportInfo();
               }
            }

            if (wizardListener != null) {
               wizardListener.enableNext(this);
            }

         } catch (Exception e) {
            e.printStackTrace();
            if (wizardListener != null) {
               wizardListener.disableNext(this);
            }
         }
      }
   }

   protected void prepareExcelImportInfo() throws IOException,
         ImportValidationException {
      ImportConfig ic = new ImportConfig();
      ic.setScaFilename(scaFileField.getText());
      ic.setImportExcelFile(importedFileField.getValue());
      handleLocationOrientation(ic);

      ExcelImporter importer = new ExcelImporter(importedFileField.getValue());

      Assessment as = importer.importFromWorkSheet();
      this.questionList = new ArrayList<String>(as.getScores().size());
      for (Iterator<Score> iter = as.getScores().iterator(); iter.hasNext();) {
         Score score = iter.next();
         questionList.add(score.getQuestion());
      }
      ic.setPreferDropDown(preferDropdownCB.isSelected());
      ic.setHavePageTitle(havePageTitlesCB.isSelected());
      ic.setAssessmentName(asNameField.getText().trim());

      this.eii = new ExcelImportInfo(ic, importer);
      pcs.firePropertyChange("questionList", null, questionList);

   }

   protected void handleLocationOrientation(ImportConfig ic) {
      if (selectedLayout == eastHorizTB) {
         ic.setLocation(Location.EAST);
         ic.setOrientation(Orientation.HORIZONTAL);
      } else if (selectedLayout == eastVertTB) {
         ic.setLocation(Location.EAST);
         ic.setOrientation(Orientation.VERTICAL);
      } else if (selectedLayout == southHorizTB) {
         ic.setLocation(Location.SOUTH);
         ic.setOrientation(Orientation.HORIZONTAL);
      } else if (selectedLayout == southVertTB) {
         ic.setLocation(Location.SOUTH);
         ic.setOrientation(Orientation.VERTICAL);
      } else if (selectedLayout == westHorizTB) {
         ic.setLocation(Location.WEST);
         ic.setOrientation(Orientation.HORIZONTAL);
      } else if (selectedLayout == westVertTB) {
         ic.setLocation(Location.WEST);
         ic.setOrientation(Orientation.HORIZONTAL);
      } else if (selectedLayout == northHorizTB) {
         ic.setLocation(Location.NORTH);
         ic.setOrientation(Orientation.HORIZONTAL);
      } else if (selectedLayout == northVertTB) {
         ic.setLocation(Location.NORTH);
         ic.setOrientation(Orientation.HORIZONTAL);
      }
   }

   public void registerWizardListener(IWizardListener lsnr) {
      this.wizardListener = lsnr;
      this.wizardListener.disableNext(this);
   }

   public JPanel getMainPanel() {
      return this;
   }

   public boolean hasNext() {
      return true;
   }

   public boolean hasPrevious() {
      return false;
   }

   public Object getPayload() {
      if (eii != null) {
         ImportConfig ic = eii.getImportConfig();
         ic.setPreferDropDown(preferDropdownCB.isSelected());
         ic.setHavePageTitle(havePageTitlesCB.isSelected());
         ic.setAssessmentName(asNameField.getText().trim());
      }
      return eii;
   }

   public void setPayload(Object payload) {
   // not applicable to this screen
   }

   public void beforeLeave() {}

   public static class FieldDocumentListener implements DocumentListener {
      protected JComponent comp;
      protected boolean complete;
      protected int type;
      protected CommonOptionsPanel cop;
      public static int FILE_TYPE = 1;
      public static int NON_EMPTY_TYPE = 2;

      public FieldDocumentListener(CommonOptionsPanel cop, JComponent comp,
            int type) {
         super();
         this.comp = comp;
         this.type = type;
         this.cop = cop;
      }

      public void changedUpdate(DocumentEvent e) {
         decideInputIsComplete(e);

      }

      public void insertUpdate(DocumentEvent e) {
         decideInputIsComplete(e);

      }

      public void removeUpdate(DocumentEvent e) {
         decideInputIsComplete(e);

      }

      protected void decideInputIsComplete(DocumentEvent de) {
         Document document = (Document) de.getDocument();
         if (type == FILE_TYPE) {
            try {
               String text = document.getText(0, document.getLength());
               complete = new File(text).exists();
               cop.canMove2NextScreen(this);

            } catch (BadLocationException e) {
               e.printStackTrace();
            }
         } else if (type == NON_EMPTY_TYPE) {
            try {
               String text = document.getText(0, document.getLength());
               complete = text.trim().length() > 1;
               cop.canMove2NextScreen(this);

            } catch (BadLocationException e) {
               e.printStackTrace();
            }
         }
      }

      public JComponent getComp() {
         return comp;
      }

      public boolean isComplete() {
         return complete;
      }
   }
}
