package caslayout.importing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.ImportConfig;
import caslayout.importing.common.Score;
import caslayout.importing.excel.ExcelImportInfo;
import caslayout.ui.wizard.IWizardListener;
import caslayout.ui.wizard.IWizardUsable;
import caslayout.util.GUIUtils;
import caslayout.util.GenUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: QuestionsPerPagePanel.java,v 1.1.2.3 2007/07/20 02:03:40
 *          bozyurt Exp $
 */
public class QuestionsPerPagePanel extends JPanel implements IWizardUsable,
      ActionListener, PropertyChangeListener {
   private static final long serialVersionUID = 1L;
   protected QuestionSelectionPanel questSelectPanel;
   protected JPanel numQuestPerPagePanel;
   protected JComboBox methodSelector;
   protected JTextField numQuestField;
   protected List<String> questionList;
   protected ExcelImportInfo importInfo;
   protected IWizardListener wizardListener;
   protected FieldDocumentListener numQuestFieldListener;

   public QuestionsPerPagePanel() {
      setLayout(new BorderLayout(5, 5));
      setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

      setBorder(BorderFactory.createLineBorder(Color.gray));

      numQuestPerPagePanel = createNumQuestPerPagePanel();

      methodSelector = new JComboBox(new String[] { "Questions per Page",
            "Individual Question Assignment" });
      methodSelector.setSelectedIndex(0);
      methodSelector.addActionListener(this);
      JLabel[] labels = { new JLabel("Pagination Method", JLabel.RIGHT) };
      JPanel lfPanel = GUIUtils.createLabelFieldPanel(labels,
            new JComponent[] { methodSelector }, true);
      lfPanel.setPreferredSize(new Dimension(200, 40));
      add(lfPanel, BorderLayout.NORTH);
      add(numQuestPerPagePanel, BorderLayout.CENTER);

   }

   public void setQuestionList(List<String> questionList) {
      this.questionList = questionList;
      questSelectPanel = new QuestionSelectionPanel(questionList, this);
      if (numQuestPerPagePanel != null) {
         numQuestFieldListener.maxValue = questionList.size();
      }
   }

   public void registerWizardListener(IWizardListener lsnr) {
      this.wizardListener = lsnr;
      this.wizardListener.disableNext(this);
   }

   @SuppressWarnings("unchecked")
   public void propertyChange(PropertyChangeEvent evt) {
      if (evt.getPropertyName().equalsIgnoreCase("questionList")) {
         List<String> qList = (List<String>) evt.getNewValue();
         setQuestionList(qList);
      }
   }

   protected JPanel createNumQuestPerPagePanel() {
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      panel.setBorder(GUIUtils.createTitledBorder(""));
      JPanel p = new JPanel();
      p.setLayout(new FlowLayout());

      numQuestField = new JTextField(2);
      JLabel[] labels = { new JLabel("# of Questions Per Page: ", JLabel.RIGHT) };
      JComponent[] fields = { numQuestField };
      JPanel labelFieldPanel = GUIUtils.createLabelFieldPanel(labels, fields,
            false);

      numQuestFieldListener = new FieldDocumentListener(this, numQuestField, 5,
            10);
      numQuestField.getDocument().addDocumentListener(numQuestFieldListener);
      numQuestField.setText("5");
      p.add(labelFieldPanel);
      panel.add(p, BorderLayout.CENTER);
      return panel;
   }

   public void actionPerformed(ActionEvent e) {
      if (e.getSource() == methodSelector) {
         int selIdx = methodSelector.getSelectedIndex();
         if (selIdx == 1) {
            remove(numQuestPerPagePanel);
            add(questSelectPanel, BorderLayout.CENTER);
            validate();
            repaint(questSelectPanel.getBounds());

         } else {
            remove(questSelectPanel);
            add(numQuestPerPagePanel, BorderLayout.CENTER);
            validate();
            numQuestPerPagePanel.repaint(questSelectPanel.getBounds());
         }
      }
   }

   protected void canMove2Next() {
      if (methodSelector == null) {
         return;
      }
      int selIdx = methodSelector.getSelectedIndex();
      if (wizardListener != null) {
         wizardListener.disableNext(this);
      }
      if (selIdx == 1) {
         if (questSelectPanel.isAllQuestionsAssigned()) {
            if (wizardListener != null) {
               preparePageScoreMap();
               wizardListener.enableNext(this);
            }
         }
      } else {
         if (numQuestFieldListener.isComplete()) {
            if (wizardListener != null) {
               prepareEqualNumQuestPerPageScoreMap();
               wizardListener.enableNext(this);
            }
         }
      }
   }

   protected void preparePageScoreMap() {
      Map<Integer, List<Object>> pqMap = questSelectPanel.pageQuestionsMap;
      Assessment as = importInfo.getExcelImporter().getAssessment();
      ImportConfig ic = importInfo.getImportConfig();
      if (ic.getAssessmentName() != null) {
         as.setName(ic.getAssessmentName());
      }
      // for (Iterator it = pqMap.entrySet().iterator(); it.hasNext();) {
      for (Map.Entry<Integer, List<Object>> entry : pqMap.entrySet()) {
         Integer pageIdx = entry.getKey();
         List<Object> pqList = entry.getValue();
         for (Iterator<Object> it2 = pqList.iterator(); it2.hasNext();) {
            String question = (String) it2.next();
            Score score = as.findScoreByQuestion(question);
            ic.addPageScore(pageIdx.intValue(), score.getName());
         }
      }
   }

   protected void prepareEqualNumQuestPerPageScoreMap() {
      Assessment as = importInfo.getExcelImporter().getAssessment();
      ImportConfig ic = importInfo.getImportConfig();
      if (ic.getAssessmentName() != null) {
         as.setName(ic.getAssessmentName());
      }
      int numQuestsPerPage = GenUtils.toInt(numQuestField.getText(), 5);
      int numOfFullPages = questionList.size() / numQuestsPerPage;
      int pageIdx = 1;
      Iterator<String> iter = questionList.iterator();
      for (int j = 0; j < numOfFullPages; j++) {
         for (int k = 0; k < numQuestsPerPage; k++) {
            String question = iter.next();
            Score score = as.findScoreByQuestion(question);
            ic.addPageScore(pageIdx, score.getName());
         }
         ++pageIdx;
      }
      while (iter.hasNext()) {
         String question = iter.next();
         Score score = as.findScoreByQuestion(question);
         ic.addPageScore(pageIdx, score.getName());
      }
   }

   // for interface IWizardUsable
   public JPanel getMainPanel() {
      return this;
   }

   public boolean hasNext() {
      return false;
   }

   public boolean hasPrevious() {
      return true;
   }

   public Object getPayload() {
      return importInfo;
   }

   public void setPayload(Object payload) {
      this.importInfo = (ExcelImportInfo) payload;
   }

   public void beforeLeave() {
      canMove2Next();
   }

   public static class QuestionSelectionPanel extends JPanel implements
         ActionListener {
      private static final long serialVersionUID = 1L;
      JPanel selectionPanel;
      JPanel buttonPanel;
      JList questSrcList;
      JList questDestList;
      JButton addQuestButton;
      JButton removeQuestButton;
      JButton nextButton, prevButton;
      List<String> questionList;
      Map<Integer, List<Object>> pageQuestionsMap = new HashMap<Integer, List<Object>>(
            17);
      int curPageIdx = 1;
      boolean allQuestionsAssigned = false;
      QuestionsPerPagePanel owner;

      public QuestionSelectionPanel(List<String> questionList,
            QuestionsPerPagePanel owner) {
         this.questionList = questionList;
         this.owner = owner;
         setLayout(new BorderLayout(5, 5));
         setBorder(GUIUtils.createTitledBorder(
               "Question Assignment for Page 1", 10));

         selectionPanel = new JPanel();
         selectionPanel.setLayout(new BoxLayout(selectionPanel,
               BoxLayout.X_AXIS));

         DefaultListModel lm = new DefaultListModel();
         for (String question : questionList) {
            lm.addElement(question);
         }

         questSrcList = new JList(lm);
         questSrcList
               .setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
         questSrcList.setVisibleRowCount(10);
         questDestList = new JList(new DefaultListModel());
         questDestList
               .setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
         questDestList.setVisibleRowCount(10);

         addQuestButton = new JButton(">>");
         Dimension d = new Dimension(25, 20);
         addQuestButton.setMaximumSize(d);
         addQuestButton.setPreferredSize(d);
         addQuestButton.setMinimumSize(d);

         addQuestButton.addActionListener(this);
         removeQuestButton = new JButton("<<");
         removeQuestButton.addActionListener(this);
         removeQuestButton.setMaximumSize(d);
         removeQuestButton.setPreferredSize(d);

         selectionPanel.add(Box.createHorizontalGlue());
         JScrollPane listScroller = new JScrollPane(questSrcList);
         listScroller.setPreferredSize(new Dimension(100, 80));
         selectionPanel.add(listScroller);
         selectionPanel.add(Box.createHorizontalGlue());

         JPanel bPanel = new JPanel();
         bPanel.setLayout(new BoxLayout(bPanel, BoxLayout.Y_AXIS));

         bPanel.add(Box.createVerticalGlue());
         bPanel.add(addQuestButton);
         bPanel.add(Box.createRigidArea(new Dimension(0, 5)));
         bPanel.add(removeQuestButton);
         bPanel.add(Box.createVerticalGlue());

         selectionPanel.add(bPanel);
         selectionPanel.add(Box.createHorizontalGlue());
         listScroller = new JScrollPane(questDestList);
         listScroller.setPreferredSize(new Dimension(100, 80));

         selectionPanel.add(listScroller);
         selectionPanel.add(Box.createHorizontalGlue());

         buttonPanel = new JPanel();
         buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
         prevButton = new JButton("Previous Page");
         prevButton.addActionListener(this);
         prevButton.setEnabled(false);
         nextButton = new JButton("Next Page");
         nextButton.addActionListener(this);

         buttonPanel.add(Box.createHorizontalGlue());
         buttonPanel.add(prevButton);
         buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
         buttonPanel.add(nextButton);
         buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));

         add(selectionPanel, BorderLayout.CENTER);
         add(buttonPanel, BorderLayout.SOUTH);
      }

      public void actionPerformed(ActionEvent e) {
         if (e.getSource() == addQuestButton) {
            Object[] selValues = questSrcList.getSelectedValues();
            if (selValues != null) {
               DefaultListModel lm = (DefaultListModel) questDestList
                     .getModel();
               for (int i = 0; i < selValues.length; i++) {
                  lm.addElement(selValues[i]);
               }
               DefaultListModel slm = (DefaultListModel) questSrcList
                     .getModel();
               for (int i = 0; i < selValues.length; i++) {
                  slm.removeElement(selValues[i]);
               }
               List<Object> questions = pageQuestionsMap.get(new Integer(
                     curPageIdx));
               if (questions == null) {
                  questions = new ArrayList<Object>(10);
                  pageQuestionsMap.put(new Integer(curPageIdx), questions);
               }
               questions.clear();
               for (int i = 0; i < selValues.length; i++) {
                  questions.add(selValues[i]);
               }
               allQuestionsAssigned = slm.isEmpty();
               if (allQuestionsAssigned) {
                  owner.canMove2Next();
               }
               nextButton.setEnabled(!slm.isEmpty());
            }
         } else if (e.getSource() == removeQuestButton) {
            Object[] selValues = questDestList.getSelectedValues();
            if (selValues != null) {
               DefaultListModel slm = (DefaultListModel) questSrcList
                     .getModel();
               for (int i = 0; i < selValues.length; i++) {
                  slm.addElement(selValues[i]);
               }
               Object[] data = slm.toArray();
               Arrays.sort(data);
               slm.clear();
               for (int i = 0; i < data.length; i++) {
                  slm.addElement(data[i]);
               }
               DefaultListModel dlm = (DefaultListModel) questDestList
                     .getModel();
               for (int i = 0; i < selValues.length; i++) {
                  dlm.removeElement(selValues[i]);
               }
               List<Object> questions = pageQuestionsMap.get(new Integer(
                     curPageIdx));
               for (int i = 0; i < selValues.length; i++) {
                  questions.remove(selValues[i]);
               }
            }
         } else if (e.getSource() == nextButton) {
            DefaultListModel dlm = (DefaultListModel) questDestList.getModel();
            dlm.clear();
            curPageIdx++;
            List<Object> questions = pageQuestionsMap.get(new Integer(
                  curPageIdx));
            if (questions != null) {
               for (Iterator<Object> iter = questions.iterator(); iter
                     .hasNext();) {
                  String q = (String) iter.next();
                  dlm.addElement(q);
               }
            }

            DefaultListModel slm = (DefaultListModel) questSrcList.getModel();
            nextButton.setEnabled(!slm.isEmpty()
                  || pageQuestionsMap.size() > curPageIdx);
            prevButton.setEnabled(curPageIdx > 0);
            setBorderTitle();

         } else if (e.getSource() == prevButton) {
            DefaultListModel dlm = (DefaultListModel) questDestList.getModel();
            DefaultListModel slm = (DefaultListModel) questSrcList.getModel();
            dlm.clear();
            curPageIdx--;
            List<Object> questions = pageQuestionsMap.get(new Integer(
                  curPageIdx));
            if (questions != null) {
               for (Iterator<Object> iter = questions.iterator(); iter
                     .hasNext();) {
                  String q = (String) iter.next();
                  dlm.addElement(q);
               }
            }
            nextButton.setEnabled(!slm.isEmpty()
                  || pageQuestionsMap.size() > curPageIdx);
            prevButton.setEnabled(curPageIdx > 0);
            setBorderTitle();
         }

      }

      public void setBorderTitle() {
         TitledBorder tb = (TitledBorder) getBorder();
         tb.setTitle("Question Assignment for Page " + (curPageIdx + 1));
         repaint();
      }

      public boolean isAllQuestionsAssigned() {
         return allQuestionsAssigned;
      }

   }// ;

   public static class FieldDocumentListener implements DocumentListener {
      protected JComponent comp;
      protected boolean complete;
      QuestionsPerPagePanel owner;
      protected int defaultValue = 5;
      protected int maxValue = 10;

      public FieldDocumentListener(QuestionsPerPagePanel owner,
            JComponent comp, int defaultValue, int maxValue) {
         super();
         this.comp = comp;
         this.owner = owner;
         this.defaultValue = defaultValue;
         this.maxValue = maxValue;
      }

      public void changedUpdate(DocumentEvent e) {
         decideInputIsComplete(e);
      }

      public void insertUpdate(DocumentEvent e) {
         decideInputIsComplete(e);
      }

      public void removeUpdate(DocumentEvent e) {
         decideInputIsComplete(e);
      }

      protected void decideInputIsComplete(DocumentEvent de) {
         Document document = (Document) de.getDocument();
         try {
            String text = document.getText(0, document.getLength());
            text = text.trim();
            int num = GenUtils.toInt(text, -1);
            if (num <= 0 || num >= maxValue) {
               num = defaultValue;
            }
            complete = num != -1;
            owner.canMove2Next();

         } catch (BadLocationException e) {
            e.printStackTrace();
         }
      }

      public JComponent getComp() {
         return comp;
      }

      public boolean isComplete() {
         return complete;
      }
   }

}
