package caslayout.output;

import java.io.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AbstractGenerator.java,v 1.1 2004/05/19 01:32:52 bozyurt Exp $
 */
public abstract class AbstractGenerator implements IGenerator {
  protected int indentSize = 2;
  protected boolean indent = true;

  public AbstractGenerator() {}

  public abstract void generate(Writer out) throws IOException;

  public void setIndentSize(int indentSize) {
     this.indentSize = indentSize;
  }
  public int getIndentSize() {  return this.indentSize; }
  public void setIndent(boolean indent) { this.indent = indent; }
  public boolean getIndent() {  return this.indent; }

  protected void doIndent(Writer out, int level) throws IOException {
    for (int i = 0; i < level * indentSize; i++) {
      out.write(' ');
    }
  }


}