package caslayout.propedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

import org.apache.log4j.Logger;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PropertyEditorPanel.java,v 1.16 2008/10/13 23:58:07 bozyurt Exp $
 */

public class PropertyEditorPanel extends JPanel {
   private static final long serialVersionUID = -5703952441183415941L;
   protected Object bean;
   protected JTable table;
   protected TableColumn tc;
   protected PETableModel tableModel;
   protected PropertyCellEditor pce;
   protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
   protected static Logger log = Logger.getLogger("PropertyEditorPanel");
   protected boolean readOnly;

   public PropertyEditorPanel(Object bean) throws Exception {
      this(bean, true);
   }

   public PropertyEditorPanel(Object bean, boolean useCustomizer)
         throws Exception {
      super();
      this.bean = bean;
      setLayout(new BorderLayout(3, 3));
      setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
      BeanDescriptor bd = bi.getBeanDescriptor();

      if (useCustomizer && bd.getCustomizerClass() != null) {
         JPanel customizer = (JPanel) bd.getCustomizerClass().newInstance();
         ((Customizer) customizer).setObject(bean);
         this.add(customizer);
         return;
      }

      PropertyDescriptor[] descriptors = (PropertyDescriptor[]) bi
            .getPropertyDescriptors().clone();

      tableModel = new PETableModel(this, descriptors, bean);

      table = new JTable(tableModel);
      table.setRowHeight(20);

      table.getColumnModel().getColumn(0).setPreferredWidth(70);
      TableColumn propertyValueColumn = table.getColumnModel().getColumn(1);
      propertyValueColumn.setPreferredWidth(100);
      pce = new PropertyCellEditor(this, descriptors, bean);
      propertyValueColumn.setCellEditor(pce);
      JScrollPane sp = new JScrollPane(table);
      sp.setPreferredSize(new Dimension(190, 120));
      this.add(sp);
   }

   public Object getBean() {
      return bean;
   }

   // ---------------------- setters --------------
   public void setReadOnly(boolean newReadOnly) {
      this.readOnly = newReadOnly;
      tableModel.readOnly = readOnly;
   }

   // ---------------------- getters --------------
   public boolean getReadOnly() {
      return this.readOnly;
   }

   protected Component getEditorComponent(final PropertyEditor pe,
         final PropertyDescriptor pd) {
      String[] tags = pe.getTags();
      String text = pe.getAsText();
      if (log.isDebugEnabled()) {
         log.debug("getEditorComponent: text=" + text);
      }
      if (pe.supportsCustomEditor()) {

         // use custom editor
         final JButton button = new JButton("Customize");
         button.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent event) {
               final Component customEditor = pe.getCustomEditor();

               JOptionPane.showMessageDialog(getParent(), customEditor, "",
                     JOptionPane.PLAIN_MESSAGE);
            }
         });
         return button;
      } else if (tags != null) {
         final JComboBox combo = new JComboBox(tags);
         combo.setEditable(false);
         combo.setSelectedItem(text);
         combo.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent ie) {
               if (ie.getStateChange() == ItemEvent.SELECTED) {
                  pe.setAsText((String) combo.getSelectedItem());
                  System.out.println("firePropertyChange -- name="
                        + pd.getName());
                  pcs.firePropertyChange(pd.getName(), null, combo
                        .getSelectedItem());
               }
            }
         });
         return combo;

      } else {
         final JTextField textField = new JTextField(text);

         textField.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent de) {};

            public void insertUpdate(DocumentEvent de) {
               try {
                  pe.setAsText(textField.getText());
                  pcs.firePropertyChange(pd.getName(), null, textField
                        .getText());
               } catch (IllegalArgumentException iae) {}
            }

            public void removeUpdate(DocumentEvent de) {
               try {
                  pe.setAsText(textField.getText());
                  pcs.firePropertyChange(pd.getName(), null, textField
                        .getText());
               } catch (IllegalArgumentException iae) {}
            }
         });
         return textField;
      }
   }

   public void addPropertyChangeListener(PropertyChangeListener pcl) {
      pcs.addPropertyChangeListener(pcl);
   }

   public void removePropertyChangeListener(PropertyChangeListener pcl) {
      pcs.removePropertyChangeListener(pcl);
   }

   protected void fireStateChanged(PropertyChangeEvent pce) {
      pcs.firePropertyChange(pce);

   }

   public static class PropertyCellEditor extends AbstractCellEditor implements
         TableCellEditor {
      private static final long serialVersionUID = -2052107410691622383L;
      PropertyEditorPanel pePanel;
      List<PropertyEditor> editors = new ArrayList<PropertyEditor>();
      Object bean;
      List<Component> components = new ArrayList<Component>();
      PropertyEditor currentEditor;

      public PropertyCellEditor(PropertyEditorPanel pePanel,
            PropertyDescriptor[] descriptorArr, Object aBean) throws Exception {
         this.pePanel = pePanel;
         this.bean = aBean;
         for (int i = 0; i < descriptorArr.length; i++) {
            PropertyEditor pe = PropertyEditorUtils.getPropertyEditor(bean,
                  descriptorArr[i], pePanel.pcs);
            if (pe != null) {
               components.add(pePanel.getEditorComponent(pe, descriptorArr[i]));
               editors.add(pe);
            }
         }
      }

      public Object getCellEditorValue() {
         return currentEditor.getValue();
      }

      public Component getTableCellEditorComponent(JTable table, Object value,
            boolean isSelected, int row, int column) {
         Component c = (Component) components.get(row);
         currentEditor = (PropertyEditor) editors.get(row);
         return c;
      }

   }

   public static class PETableModel extends AbstractTableModel {
      private static final long serialVersionUID = 8561068953667671697L;
      String[] columnNames = { "Attribute", "Value" };
      // List rowData;
      boolean readOnly;
      List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
      List<PropertyEditor> editors = new ArrayList<PropertyEditor>();
      Object bean;

      public PETableModel(PropertyEditorPanel pePanel,
            PropertyDescriptor[] descriptorArr, Object aBean) throws Exception {

         this.bean = aBean;
         for (int i = 0; i < descriptorArr.length; i++) {
            PropertyEditor pe = PropertyEditorUtils.getPropertyEditor(bean,
                  descriptorArr[i], pePanel.pcs);
            if (pe != null) {
               descriptors.add(descriptorArr[i]);
               editors.add(pe);
            }
         }
      }

      public void resetData(PropertyEditorPanel pePanel,
            PropertyDescriptor[] descriptorArr, Object aBean) {

         if (editors != null) {
            editors.clear();

            fireTableRowsDeleted(0, editors.size() - 1);
         }

         this.bean = aBean;
         for (int i = 0; i < descriptorArr.length; i++) {
            try {
               PropertyEditor pe = PropertyEditorUtils.getPropertyEditor(bean,
                     descriptorArr[i], pePanel.pcs);
               if (pe != null) {
                  descriptors.add(descriptorArr[i]);
                  editors.add(pe);
               }
            } catch (Exception x) {
               x.printStackTrace();
            }
         }
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public int getRowCount() {
         return descriptors.size();
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         if (col == 0) {
            return ((PropertyDescriptor) descriptors.get(row)).getName();
         } else {
            return ((PropertyEditor) editors.get(row)).getValue();
         }

      }

      public boolean isCellEditable(int row, int col) {
         if (readOnly) {
            return false;
         } else {
            return col > 0;
         }
      }

      public void setValueAt(Object value, int row, int col) {
         if (col == 1) {
            if (log.isDebugEnabled()) {
               log.debug("setValueAt value=" + value);
            }
            ((PropertyEditor) editors.get(row)).setValue(value);
            fireTableCellUpdated(row, col);
         }
      }

      /*
       * public void clear() { int size = rowData.size(); rowData.clear(); if
       * (size > 0) { fireTableRowsDeleted(0, size - 1); } }
       */
   }

}
