package caslayout.propedit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PropertyEditorUtils.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class PropertyEditorUtils {
   private PropertyEditorUtils() {}

   public static PropertyEditor getPropertyEditor(final Object aBean,
         final PropertyDescriptor descriptor, final PropertyChangeSupport pcs)
         throws InstantiationException, IllegalAccessException,
         InvocationTargetException {
      Method getter = descriptor.getReadMethod();
      if (getter == null)
         return null;
      final Method setter = descriptor.getWriteMethod();
      if (setter == null)
         return null;
      final PropertyEditor editor;
      Class<?> edClazz = descriptor.getPropertyEditorClass();
      if (edClazz != null) {
         editor = (PropertyEditor) edClazz.newInstance();
      } else {
         editor = PropertyEditorManager
               .findEditor(descriptor.getPropertyType());
      }
      if (editor == null)
         return null;

      // System.out.println("editor class=" + editor.getClass() + "bean " +
      // aBean);

      editor.setValue(getter.invoke(aBean, new Object[] {}));
      editor.addPropertyChangeListener(new PropertyChangeListener() {
         public void propertyChange(PropertyChangeEvent pce) {
            try {
               setter.invoke(aBean, new Object[] { editor.getValue() });
               pcs.firePropertyChange(pce);
            } catch (InvocationTargetException ite) {} catch (IllegalAccessException iae) {}

         }

      });

      return editor;
   }

}
