package caslayout.propedit;

import java.beans.PropertyEditorSupport;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: PropertySelector.java,v 1.3 2005/10/07 00:34:44 bozyurt Exp $
 */
public class PropertySelector extends PropertyEditorSupport
{
  protected String[] names;
  protected Object[] values;

  public PropertySelector(String[] names, Object[] values) {
    this.names = names;
    this.values = values;
  }

  public String[] getTags() { return names; }
  public String getAsText() {
    Object val = getValue();
    for (int i = 0; i < values.length; i++) {
      if ( values[i] == val)
           return names[i];
    }
    return null;
  }

  public void setAsText(String newVal) {
    for (int i = 0; i < names.length; i++) {
      if ( names[i].equals(newVal) ) {
           setValue( values[i]);
      }
    }
  }
}
