package caslayout.test;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.hibernate.Session;
import org.hibernate.SessionFactory;

import caslayout.Constants;
import caslayout.importing.common.Assessment;
import caslayout.importing.common.DataRow;
import caslayout.importing.excel.ExcelImporter;
import caslayout.importing.ui.AsDataImportDialog;
import caslayout.ui.CALMConfig;
import caslayout.ui.db.Protocol;
import caslayout.ui.db.Segment;
import caslayout.ui.db.SegmentKey;
import caslayout.ui.db.SessionFactoryFactory;
import caslayout.ui.db.Study;
import caslayout.ui.db.Visit;
import caslayout.ui.db.services.AssessmentDataService;

public class AsDataServiceTests extends TestCase {
	SessionFactory sessionFactory;
	CALMConfig config;

	public AsDataServiceTests(String testName) {
		super(testName);
	}

	protected void setUp() throws Exception {
		config = new CALMConfig("caslayout.properties");
		// config.setDbType(Constants.POSTGRES);
		config.setDbType(Constants.ORACLE);
		config.setUser("fbirn_test2");
		config.setPwd("testit");


		sessionFactory = SessionFactoryFactory
				.getSessionFactory(config);
	}

	protected void tearDown() throws Exception {
		if (sessionFactory != null) {
			sessionFactory.close();
		}
	}

	public void testDeleteDataForAssessment() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);
		ads.deleteAssessmentDataFor("DEMOGRAPH");
	}

	public void testDeleteSubjectVisits() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);
		ads.deleteSubjectVisits("fBIRNPhaseII__0010", "clinical visit");
	}

	public void testDeleteSubjectVisitsAndAsData() throws Exception {
	   AssessmentDataService ads = AssessmentDataService.getInstance(config);
	   ads.deleteAssessmentDataFor("ExcelTest");
	   ads.deleteSubjectVisits("fBIRNPhaseII__0010", "clinical visit");
	}


	public void testAddAssessmentDataWithSubjectMan() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);
		String xlsFile = "/home/bozyurt/dev/java/birn_testbed/test/excel/SOCIOECONOMICSTATUSSES.xls";

		ExcelImporter importer = new ExcelImporter(xlsFile);

		Assessment as = importer.importFromWorkSheet();
		List<DataRow> dataRowList = importer.loadAssessmentData();
		Map<Object,Object> protocolMap = ads.getProtocolMap();

		Protocol protocol = (Protocol) protocolMap
				.get("Subjects screening protocol_1");
		DataRow dataRow = (DataRow) dataRowList.get(0);

		// ads.deleteVisits(dataRow.getSubjectID(), "calm_import_test",
		//		"clinical visit");
		Calendar cal = Calendar.getInstance();
		cal.set(2007, 6, 31, 0, 0, 0);

		Date visitDate = cal.getTime();

		cal.clear();
		cal.set(2007, 6, 31, 13, 26, 0);
		Date segmentTimestamp = cal.getTime();

		Visit visit = ads.getVisitWithStudySegmentForSubject(dataRow,
				"calm_import_test", "clinical visit", "control", visitDate,
				segmentTimestamp, protocol, null);
		Study study = (Study) visit.getStudies().iterator().next();
		Segment segment = (Segment) study.getSegments().iterator().next();
		System.out.println("Assessment Name:" + as.getName());
		ads.addAssessmentData(segment, dataRow, as.getName());

	}

	public void testAddAssessmentData() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);
		String xlsFile = "/home/bozyurt/dev/java/birn_testbed/test/excel/SOCIOECONOMICSTATUSSES.xls";

		ExcelImporter importer = new ExcelImporter(xlsFile);

		Assessment as = importer.importFromWorkSheet();
		List<DataRow> dataRowList = importer.loadAssessmentData();

		List<?> visits = ads.getStudySegmentsForSubject("009002593489", "Test1",
				"screening");

		Visit visit = (Visit) visits.get(0);
		Study study = (Study) visit.getStudies().iterator().next();
		Segment segment = (Segment) study.getSegments().iterator().next();
		DataRow dataRow = (DataRow) dataRowList.get(0);

		System.out.println("Assessment Name:" + as.getName());
		ads.addAssessmentData(segment, dataRow, as.getName());
	}

	public void testGetStudySegmentsForSubject() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);

		// List visits = ads.getStudySegmentsForSubject("000602155404",
		// "download_test", "clinical visit");

		List<?> visits = ads.getStudySegmentsForSubject("009002593489", "Test1",
				"screening");
		for (Iterator<?> it = visits.iterator(); it.hasNext();) {
			Visit visit = (Visit) it.next();
			System.out.println(visit.toString());
		}
	}

	public void testAsDataImportDialog() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);

		AsDataImportDialog dlg = new AsDataImportDialog(null, "Assessment Data Import", ads);
		dlg.showDialog();
	}

	public void testAsDataExistence() throws Exception {
		AssessmentDataService ads = AssessmentDataService.getInstance(config);
		Map<Object,Object> asMap = ads.getAssessmentMap();
		for (Iterator<Object> it = asMap.values().iterator(); it.hasNext();) {
			caslayout.ui.db.Assessment as = (caslayout.ui.db.Assessment) it.next();
			System.out.println(as.getName() + " id:" + as.getID());
		}
		caslayout.ui.db.Assessment as = (caslayout.ui.db.Assessment)
		   asMap.get("ExcelTest");
		Session session = null;
		try {
			session = sessionFactory.openSession();
			Segment theSegment = new Segment();
            SegmentKey sk = new SegmentKey();
            sk.setExperimentID(new Long(33860) );
            sk.setSubjectID("000367047295");
            sk.setSegmentID(new Long(1));
            sk.setVisitID(new Long(1));
            theSegment.setSegmentKey(sk);
            theSegment.setTimeStamp( new Timestamp(System.currentTimeMillis()));

			boolean ok =  ads.asssessmentEntryExists(session, theSegment, as);

			assertFalse(ok);
		} finally {
			if (session != null)
				session.close();
		}
	}


	public static Test suite() {
		TestSuite suite = new TestSuite();

		// suite.addTest(new
		// AsDataServiceTests("testGetStudySegmentsForSubject"));
		// suite.addTest(new AsDataServiceTests("testAddAssessmentData"));
		// suite.addTest(new AsDataServiceTests("testAddAssessmentDataWithSubjectMan"));
		// suite.addTest(new AsDataServiceTests("testAsDataImportDialog"));
		// suite.addTest(new AsDataServiceTests("testDeleteDataForAssessment"));
		// suite.addTest( new AsDataServiceTests("testDeleteSubjectVisits"));
		//suite.addTest( new AsDataServiceTests("testAsDataExistence") );
		suite.addTest( new AsDataServiceTests("testDeleteSubjectVisitsAndAsData"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
