package caslayout.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JFrame;

import caslayout.ui.CALMConfig;
import caslayout.ui.Document;
import caslayout.ui.assoc.AssessmentMaintenancePanel;
import caslayout.ui.db.Assessment;
import caslayout.ui.db.AssessmentScore;
import caslayout.ui.db.DBParamsDialog;
import caslayout.ui.db.SessionFactoryFactory;
import caslayout.ui.db.services.AssessmentService;
import caslayout.ui.model.AssessmentInfo;
import caslayout.ui.model.ScoreInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AsMaintenancePanelTest.java,v 1.6 2007/10/08 18:00:40 bozyurt
 *          Exp $
 */
public class AsMaintenancePanelTest {
   public AsMaintenancePanelTest() {}

   public static AssessmentInfo loadAssessment(String propsFile)
         throws Exception {
      AssessmentService service = null;
      AssessmentInfo asi = null;
      CALMConfig config = new CALMConfig(propsFile);

      DBParamsDialog dlg = new DBParamsDialog(null, "", config);
      dlg.showDialog();

      try {
         service = AssessmentService.getInstance(config);
         String assessmentName;
         assessmentName = "Self-rating Anxiety Scale (SAS)";
         assessmentName = "Beck Depression Inventory (BDI)";
         assessmentName = "SCID";
         assessmentName = "quick mood";

         Assessment as = service.getAssessment(assessmentName);
         if (as != null) {

            asi = new AssessmentInfo(as.getName());
            Map<ScoreInfo, ScoreInfo> siMap = new LinkedHashMap<ScoreInfo, ScoreInfo>();
            for (Iterator<AssessmentScore> iter = as.getScores().iterator(); iter
                  .hasNext();) {
               AssessmentScore score = iter.next();
               ScoreInfo si = new ScoreInfo(score.getScoreName());
               si.setAssessment(asi);
               si.setScoreType(score.getScoreType());
               si.setScoreSequence(score.getScoreSequence().intValue());
               siMap.put(si, si);
               if (score.getParent() != null) {
                  AssessmentScore parentScore = (AssessmentScore) score
                        .getParent();
                  ScoreInfo parentSi = new ScoreInfo(parentScore.getScoreName());
                  if (siMap.get(parentSi) != null) {
                     parentSi = (ScoreInfo) siMap.get(parentSi);
                  } else {
                     parentSi.setAssessment(asi);
                     parentSi.setScoreType(parentScore.getScoreType());
                     parentSi.setScoreSequence(parentScore.getScoreSequence()
                           .intValue());
                     siMap.put(parentSi, parentSi);
                  }
                  si.setParent(parentSi);
               }

            }// iter
            List<ScoreInfo> scores = new ArrayList<ScoreInfo>(siMap.values());
            Collections.sort(scores, new Comparator<ScoreInfo>() {
               public int compare(ScoreInfo o1, ScoreInfo o2) {
                  return o1.getScoreSequence() - o2.getScoreSequence();
               }
            });
            for (ScoreInfo si : scores) {
               asi.addScoreInfo(si);
            }
         } // as != null

      } catch (Exception x) {
         x.printStackTrace();
      } finally {
         if (service != null)
            SessionFactoryFactory.shutdown();
      }
      return asi;

   }

   public static void main(String[] args) throws Exception {
      JFrame.setDefaultLookAndFeelDecorated(true);

      JFrame frame = new JFrame("AsMaintenancePanelTest");
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

      AssessmentInfo asi = loadAssessment("caslayout.properties");
      Document doc = Document
            .loadDocument("/home/bozyurt/quick_mod.xml", frame);

      AssessmentMaintenancePanel panel = new AssessmentMaintenancePanel(asi,
            doc, frame);
      frame.setContentPane(panel);
      frame.setSize(800, 500);
      // frame.pack();
      frame.setVisible(true);

   }

}
