package caslayout.test;

import java.util.Iterator;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import caslayout.importing.common.Score;
import caslayout.importing.common.ScoreCode;
import caslayout.importing.excel.ExcelImporter;
import caslayout.ui.CALMConfig;
import caslayout.ui.db.Assessment;
import caslayout.ui.db.AssessmentItem;
import caslayout.ui.db.AssessmentScore;
import caslayout.ui.db.AssessmentScoreCode;
import caslayout.ui.db.AssessmentTimestamp;
import caslayout.ui.db.DatabaseUser;
import caslayout.ui.db.Experiment;
import caslayout.ui.db.ResearchGroup;
import caslayout.ui.db.Segment;
import caslayout.ui.db.SessionFactoryFactory;
import caslayout.ui.db.services.AssessmentService;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentServiceTests.java,v 1.2 2007/10/08 18:00:40 bozyurt
 *          Exp $
 */
public class AssessmentServiceTests extends TestCase {
   SessionFactory sessionFactory;

   public AssessmentServiceTests(String name) {
      super(name);
   }

   protected void setUp() throws Exception {
      CALMConfig config = new CALMConfig("caslayout.properties");

      sessionFactory = SessionFactoryFactory.getSessionFactory(config);
   }

   protected void tearDown() throws Exception {
      if (sessionFactory != null) {
         sessionFactory.close();
      }
   }

   public void testHibernate() throws Exception {
      Session session = null;
      List<?> assessmentList;
      try {
         session = sessionFactory.openSession();
         Transaction trx = session.beginTransaction();
         assessmentList = session.createQuery(
               "from Assessment a left join fetch a.scores order by name asc")
               .list();

         Long tableID = AssessmentService.getTableID(session, "nc_experiment");
         System.out.println("tableID:" + tableID);
         trx.commit();

      } finally {
         if (session != null) {
            session.close();
         }
      }

      for (Iterator<?> iter = assessmentList.iterator(); iter.hasNext();) {
         Assessment as = (Assessment) iter.next();
         System.out.println(as);

      }
   }

   public void testGetAssessmentData() throws Exception {
      Session session = null;
      try {
         // favorites 28563
         session = sessionFactory.openSession();
         Transaction trx = session.beginTransaction();
         List<?> asData = session.createQuery(
               "from AssessmentTimestamp ai where ai.assessmentID = :asID)")
               .setParameter("asID", new Long(28563)).list();

         for (Iterator<?> iter = asData.iterator(); iter.hasNext();) {
            AssessmentTimestamp at = (AssessmentTimestamp) iter.next();
            System.out.println(at.getScorename() + " --> " + at.getDataValue());
         }

         trx.commit();
      } finally {
         if (session != null) {
            session.close();
         }
      }
   }

   public void testGetAssessmentMetaData() throws Exception {
      AssessmentService service = null;
      CALMConfig config = new CALMConfig("caslayout.properties");
      service = AssessmentService.getInstance(config);

      Assessment as = service.getAssessment("quick");

      System.out.println(as);
   }

   public void testImportAssessmentMetaData() throws Exception {
      AssessmentService service = null;
      CALMConfig config = new CALMConfig("caslayout.properties");
      service = AssessmentService.getInstance(config);

      String xlsFile = "/home/bozyurt/dev/java/birn_testbed/test/excel/SOCIOECONOMICSTATUSSES.xls";
      ExcelImporter importer = new ExcelImporter(xlsFile);

      caslayout.importing.common.Assessment importedAs = importer
            .importFromWorkSheet();

      Assessment as = new Assessment();
      as.setName(importedAs.getName());
      for (Object element : importedAs.getScores()) {
         Score score = (Score) element;
         AssessmentScore aScore = new AssessmentScore();
         aScore.setScoreName(score.getName());
         aScore.setScoreLevel(new Integer(1));
         aScore.setScoreSequence(new Integer(score.getScoreSequence()));
         aScore.setScoreType(score.getScoreType());
         aScore.setNullable(new Boolean(true));
         aScore.setSecurityClassification("FIRST BIRN");
         if (score.getQuestion() != null
               && score.getQuestion().trim().length() > 0) {
            AssessmentItem asItem = new AssessmentItem();
            asItem.setScoreName(score.getName());
            asItem.setItemLeadingText(score.getQuestion());
            as.addItem(asItem);
         }
         as.addScore(aScore);
         if (score.hasScoreCodes()) {
            List<ScoreCode> scoreCodes = score.getScoreCodes();
            for (Object element2 : scoreCodes) {
               ScoreCode sc = (ScoreCode) element2;
               AssessmentScoreCode asc = new AssessmentScoreCode();
               asc.setScoreName(score.getName());
               asc.setScoreCode(sc.getScoreCode());
               asc.setScoreCodeType(score.getScoreType());
               asc.setScoreCodeLabel(sc.getScoreLabel());
               asc.setScoreCodeValue(sc.getScoreValue());
               aScore.addScoreCode(asc);
            }
         }
      }

      service.saveAssessment(as);

   }

   public void testDeleteAssessmentMetaData() throws Exception {
      AssessmentService service = null;
      CALMConfig config = new CALMConfig("caslayout.properties");
      service = AssessmentService.getInstance(config);

      Assessment as = service.getAssessment("SOCIOECONOMICSTATUSSES");
      if (as != null) {
         service.deleteAssessment(as, true);
      }
   }

   public void testResearchGroupRetrieval() throws Exception {
      Session session = null;
      List<?> rgList = null;
      try {
         session = sessionFactory.openSession();
         rgList = session.createQuery("from ResearchGroup").list();
      } finally {
         if (session != null) {
            session.close();
         }
      }
      for (Iterator<?> it = rgList.iterator(); it.hasNext();) {
         ResearchGroup rg = (ResearchGroup) it.next();
         System.out.println(rg);
      }
   }

   public void testSegmentRetrieval() throws Exception {
      Session session = null;
      List<?> segList = null;
      try {
         session = sessionFactory.openSession();
         segList = session.createQuery("from Segment").list();
         for (Iterator<?> it = segList.iterator(); it.hasNext();) {
            Segment seg = (Segment) it.next();
            System.out.println(seg);
         }
      } finally {
         if (session != null) {
            session.close();
         }
      }
   }

   public void testDatabaseUserRetrieval() throws Exception {
      Session session = null;
      List<?> userList = null;
      try {
         session = sessionFactory.openSession();
         userList = session.createQuery("from DatabaseUser").list();
         for (Iterator<?> it = userList.iterator(); it.hasNext();) {
            DatabaseUser user = (DatabaseUser) it.next();
            System.out.println(user);
         }
      } finally {
         if (session != null) {
            session.close();
         }
      }
   }

   public void testExperimentRetrieval() throws Exception {
      Session session = null;
      List<?> expList = null;
      try {
         session = sessionFactory.openSession();
         expList = session.createQuery("from Experiment").list();
         for (Iterator<?> it = expList.iterator(); it.hasNext();) {
            Experiment exp = (Experiment) it.next();
            System.out.println(exp);
         }
      } finally {
         if (session != null) {
            session.close();
         }
      }
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      // suite.addTest( new AssessmentServiceTests("testHibernate"));
      // suite.addTest(new AssessmentServiceTests("testGetAssessmentData"));
      // suite.addTest( new AssessmentServiceTests("testGetAssessmentMetaData")
      // );
      // suite.addTest(new
      // AssessmentServiceTests("testImportAssessmentMetaData"));
      // suite.addTest( new
      // AssessmentServiceTests("testDeleteAssessmentMetaData"));
      // suite.addTest( new AssessmentServiceTests("testResearchGroupRetrieval")
      // );
      // suite.addTest(new AssessmentServiceTests("testSegmentRetrieval"));
      // suite.addTest(new AssessmentServiceTests("testDatabaseUserRetrieval"));
      suite.addTest(new AssessmentServiceTests("testExperimentRetrieval"));
      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }
}
