package caslayout.test;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

import caslayout.ui.ColumnsPercentSelectionDialog;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DialogTest.java,v 1.2 2007/10/08 18:00:40 bozyurt Exp $
 */
public class DialogTest {
  public DialogTest() {
  }


  public static JPanel createColumnsPercentDlgTestPanel(final JFrame frame) {
    JPanel panel = new JPanel( new BorderLayout(3,3));
    JButton button = new JButton("Test Dialog");
    button.addActionListener(new ActionListener() {
             public void actionPerformed(ActionEvent e) {
               ColumnsPercentSelectionDialog dlg = new
                   ColumnsPercentSelectionDialog(frame, "Column Percents",
                                                 new double[] {20,40,10,10,10,10} );

               dlg.showDialog();
             }
           });
    panel.add(button, BorderLayout.NORTH);

    return panel;
  }

  public static void main(String[] args)  throws Exception {
     JFrame.setDefaultLookAndFeelDecorated(true);


     JFrame frame = new JFrame("DialogTest");
     frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);


     frame.setContentPane( createColumnsPercentDlgTestPanel(frame) );
     frame.setSize(400, 400);
     // frame.pack();
     frame.setVisible(true);

   }

}