package caslayout.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JFrame;
import javax.swing.JPanel;

import caslayout.ui.ButtonDisplayComponent;
import caslayout.ui.ButtonType;
import caslayout.ui.IDisplayComponent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DisplayComponentTest.java,v 1.5 2006/03/29 02:25:02 bozyurt Exp $
 */
public class DisplayComponentTest {
	public DisplayComponentTest() {
	}

	public static JPanel createTestButtonComponentPanel()
	{
		TestCanvas panel = new TestCanvas();
		ButtonDisplayComponent bdc = new ButtonDisplayComponent(20, 20, panel,
				ButtonType.SUBMIT_BUTTON);
		panel.setDisplayComponent(bdc);
		return panel;
	}

	public static class TestCanvas extends JPanel implements MouseListener {
		private static final long serialVersionUID = -674155380316411076L;
		IDisplayComponent ic;

		public TestCanvas() {
			super(null);
			setBackground(Color.white);
		}

		public void setDisplayComponent(IDisplayComponent ic)
		{
			this.ic = ic;
		}

		protected void paintComponent(Graphics g)
		{
			Dimension d = getSize();
			Insets is = getInsets();
			Color oldColor = g.getColor();
			g.setColor(Color.white);

			g.fillRect(is.left, is.top, d.width - is.left - is.right, d.height
					- is.top - is.bottom);
			g.setColor(oldColor);
			ic.draw((Graphics2D) g);
		}

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent e)
		{
		}

		public void mouseReleased(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}
	}

	public static void main(String[] args) throws Exception
	{
		JFrame.setDefaultLookAndFeelDecorated(true);

		JFrame frame = new JFrame("ComponentTest");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		frame.setContentPane(createTestButtonComponentPanel());
		frame.setSize(500, 500);
		// frame.pack();
		frame.setVisible(true);
	}
}