package caslayout.test;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import caslayout.codegen.HTMLGenerator;
import caslayout.ui.Document;
import caslayout.ui.Page;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: HTMLGeneratorTest.java,v 1.5 2008/10/14 23:21:16 bozyurt Exp $
 */
public class HTMLGeneratorTest extends TestCase {
  Document doc;
  public HTMLGeneratorTest(String name) {
    super(name);
  }

  protected void setUp() throws Exception {
     doc = Document.loadDocument("/home/bozyurt/quick_mod.xml", null);

   }


   public void testGenHTML() throws Exception {
     StringWriter sout = null;
     for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext(); ) {
       Page page = (Page) iter.next();
       HTMLGenerator htmlGen = new HTMLGenerator(  page.getViewPanel() );

       sout = new StringWriter(15000);


       htmlGen.generate(sout);
       String content = sout.toString();
       System.out.println(content);
     }
   }


   public static void writeToFile(String filename, String content) throws IOException {
     BufferedWriter out = null;
     try {
       out = new BufferedWriter( new FileWriter( filename ) );
       out.write(content);
     } finally {
     if (out != null) try { out.close(); } catch(Exception x) {}
     }
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      suite.addTest( new HTMLGeneratorTest("testGenHTML") );
      return suite;
  }

    public static void main(String[] args) {
      junit.textui.TestRunner.run( suite() );
    }
}