package caslayout.test;

import guilib.common.BaseDialog;

import java.awt.Font;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jdom.Element;

import caslayout.importing.common.Assessment;
import caslayout.importing.common.ImportConfig;
import caslayout.importing.excel.ExcelImportInfo;
import caslayout.importing.excel.ExcelImporter;
import caslayout.importing.ui.AsDataImportDialog;
import caslayout.importing.ui.CommonOptionsPanel;
import caslayout.importing.ui.QuestionsPerPagePanel;
import caslayout.ui.builder.Location;
import caslayout.ui.builder.Orientation;
import caslayout.ui.wizard.IWizardUsable;
import caslayout.ui.wizard.WizardDialog;
import caslayout.util.XMLUtils;

import com.digitprop.tonic.TonicLookAndFeel;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ImportTests.java,v 1.3 2008/10/14 23:21:16 bozyurt Exp $
 */
public class ImportTests extends TestCase {

   public ImportTests(String testName) {
      super(testName);
   }

   public void testImportFromExcel() throws Exception {
      String xlsFile = "/home/bozyurt/dev/java/birn_testbed/test/excel/SOCIOECONOMICSTATUSSES.xls";

      ExcelImporter importer = new ExcelImporter(xlsFile);

      Assessment as = importer.importFromWorkSheet();

      ImportConfig ic = new ImportConfig();
      ic.setScaFilename("ses.calm");
      ic.setLocation(Location.EAST);
      ic.setOrientation(Orientation.VERTICAL);
      ic.addPageScore(1, "ses education subject");
      ic.addPageScore(1, "ses education p_caretaker_prior18");
      ic.addPageScore(1, "ses education p_caretaker_lifetime");

      Element calmElem = as.toCALM(ic);
      String calmFile = "/home/bozyurt/dev/java/branch/BIRN/cas_layout/examples/"
            + ic.getScaFilename();
      XMLUtils.saveXML(calmElem, calmFile);
   }

   @SuppressWarnings("unchecked")
   public static void setUIFont(FontUIResource fur) {
      Enumeration keys = UIManager.getDefaults().keys();
      while (keys.hasMoreElements()) {
         Object key = keys.nextElement();
         Object value = UIManager.get(key);
         if (value instanceof FontUIResource) {
            UIManager.put(key, fur);
         }
      }
   }

   public void testImportWizard() throws Exception {
      setUIFont(new FontUIResource("Dialog", Font.PLAIN, 11));
      UIManager.setLookAndFeel(new TonicLookAndFeel());

      IWizardUsable[] screens = new IWizardUsable[2];
      String scaGenDir = "/home/bozyurt/dev/java/branch/BIRN/cas_layout/gen";
      CommonOptionsPanel cop = new CommonOptionsPanel(
            "/home/bozyurt/dev/java/birn_testbed", scaGenDir);
      QuestionsPerPagePanel qp3 = new QuestionsPerPagePanel();

      screens[0] = cop;
      screens[1] = qp3;

      List<String> questionList = new ArrayList<String>();
      for (int i = 0; i < 23; i++) {
         questionList.add("Question " + (i + 1));
      }

      // qp3.setQuestionList(questionList);

      cop.addPropertyChangeListener(qp3);

      WizardDialog dlg = new WizardDialog(null, "Import Clinical Assessment",
            screens);

      cop.registerWizardListener(dlg);
      qp3.registerWizardListener(dlg);

      int rc = dlg.showDialog();
      if (rc == BaseDialog.OK_PRESSED) {
         System.out.println("time to create assessment");
         ExcelImportInfo ii = (ExcelImportInfo) dlg.getPayload();
         Assessment as = ii.getExcelImporter().getAssessment();
         ImportConfig ic = ii.getImportConfig();
         Element calmElem = as.toCALM(ic);
         String calmFile = ic.getScaFilename();
         XMLUtils.saveXML(calmElem, calmFile);
         System.out.println("saved assessment to file:" + calmFile);
      }
   }

   public void testAsDataImportDialog() {
      AsDataImportDialog dlg = new AsDataImportDialog(null,
            "Assessment Data Import", null);

      dlg.showDialog();
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      // suite.addTest( new ImportTests("testImportFromExcel"));
      // suite.addTest(new ImportTests("tesImportWizard"));
      suite.addTest(new ImportTests("testAsDataImportDialog"));
      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }
}
