package caslayout.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import caslayout.util.XMLUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MiscTests.java,v 1.5 2008/10/14 23:21:16 bozyurt Exp $
 */
public class MiscTests extends TestCase {
   public MiscTests(String name) {
      super(name);
   }

   public void testXMLEncodeDecode() {
      String sqlQuery = "select x from y where x like 'some%'";
      String encoded = XMLUtils.toXML(sqlQuery);
      String decoded = XMLUtils.decodeXML(encoded);
      assertEquals(sqlQuery, decoded);
      System.out.println("decoded=" + decoded);
   }

   public void testPrepareJSExpression() {
      String expected = "  var value = 128.7 - 0.89*Math.log(Math.sin(total_Errors));\n";
      String expr = "128.7 - 0.89*log(sin (total_Errors))";
      Map<String, String> varMap = new HashMap<String, String>(3);
      varMap.put("totalErrors", "totalErrors");
      StringBuffer buf = new StringBuffer();
      String jsExpr = expr.replaceAll("log\\s*\\(", "Math.log(");
      jsExpr = jsExpr.replaceAll("sin\\s*\\(", "Math.sin(");
      jsExpr = jsExpr.replaceAll("cos\\s*\\(", "Math.cos(");
      jsExpr = jsExpr.replaceAll("exp\\s*\\(", "Math.exp(");
      jsExpr = jsExpr.replaceAll("sqrt\\s*\\(", "Math.sqrt(");
      for (Iterator<String> iter = varMap.keySet().iterator(); iter.hasNext();) {
         String propertyName = iter.next();
         jsExpr = jsExpr.replaceAll(propertyName, "form." + propertyName
               + ".value");
      }
      buf.append("  var value = ").append(jsExpr).append(";\n");
      System.out.println(buf.toString());
      assertEquals(buf.toString(), expected);
   }

   public void testRegexs() {
      String testText = "<forward name=\"failure\" path=\"/pages/SegmentMan_full.jsp\"/>";
      String regex = "<forward\\s+name=\"failure\"\\s+path=\"/pages/SegmentMan_full\\.jsp\"/>";
      Pattern p = Pattern.compile(regex);
      Matcher m = p.matcher(testText);
      assertTrue(m.find());
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();

      // suite.addTest(new MiscTests("testXMLEncodeDecode"));
      suite.addTest(new MiscTests("testPrepareJSExpression"));
      suite.addTest(new MiscTests("testRegexs"));
      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }
}
