package caslayout.test;

import java.io.*;

import caslayout.codegen.struts.*;
import caslayout.ui.*;
import caslayout.ui.model.*;
import caslayout.util.GenUtils;
import junit.framework.*;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StrutsCodeGenTest.java,v 1.4 2007/04/16 17:00:43 bozyurt Exp $
 */
public class StrutsCodeGenTest extends BaseTestCase {
   Document doc;
   String testRootDir;
   StrutsCodegenConfig config = new StrutsCodegenConfig();

   public StrutsCodeGenTest(String name) {
      super(name, "caslayout.properties");
   }

   protected void setUp() throws Exception {
      testRootDir = super.getProperty("test.data.dir");
      prep4PackYearTest();
      /*
       * doc = Document.loadDocument("/home/bozyurt/mq_test1.xml", null);
       * config.setFormBeanID("qmForm");
       * config.setRelativeJspPath("/pages/assessment/"); String[] jspNames = {
       * "MQTest1.jsp" }; config.setJspPageNames(jspNames);
       * config.setStrutsActionRoot("/man_mq_test");
       * config.setStrutsConfigFile("/home/bozyurt/tmp/struts-config.xml");
       * config.setPackageName("clinical.web.game.forms");
       * config.setFormBeanName("MQTest1Form");
       */
   }

   protected void prep4PackYearTest() throws Exception {
      doc = Document.loadDocument(new File(testRootDir,
            "calm_forms/PackYear.xml").getAbsolutePath(), null);
      File strutsConfigXMLFile = new File(testRootDir,
            "clinical/web/WEB-INF/struts-config.xml.template");
      File strutsConfigOrigXMLFile = new File(testRootDir,
            "clinical/web/WEB-INF/struts-config.xml.template.orig");
      GenUtils.copyFile(strutsConfigOrigXMLFile, strutsConfigXMLFile);

      config.setFormBeanID("packyearForm");
      config.setRelativeJspPath("/pages/assessment/");
      String[] jspNames = { "PackYearForm_Page1.jsp", "PackYearForm_Page2.jsp" };
      config.setJspPageNames(jspNames);
      config.setStrutsActionRoot("/man_packyear");
      config.setStrutsConfigFile(strutsConfigXMLFile.getAbsolutePath());
      config.setPackageName("clinical.web.game.forms");
      config.setFormBeanName("PackYearForm");
      config.setSourceCodeRoot(new File(testRootDir, "clinical/src").getAbsolutePath());
      
      File srcFile = new File(config.getSourceCodeRoot(), "clinical.web".replace(
            '.', File.separatorChar)  + File.separatorChar + "Constants.java.orig");
      File destFile = new File(config.getSourceCodeRoot(), "clinical.web".replace(
            '.', File.separatorChar)  + File.separatorChar + "Constants.java");
      GenUtils.copyFile(srcFile, destFile);      
      
      srcFile = new File(config.getSourceCodeRoot(), "clinical.web.actions".replace(
            '.', File.separatorChar)  +  File.separatorChar + "CADispatcherAction.java.orig");
      destFile = new File(config.getSourceCodeRoot(), "clinical.web.actions".replace(
            '.', File.separatorChar)  + File.separatorChar + "CADispatcherAction.java");
      GenUtils.copyFile(srcFile, destFile);
   }

   public void testGenerate() throws Exception {
      StrutsCodegenConfig config = new StrutsCodegenConfig();
      config.setFormBeanName("MQTest1Form");
      config.setPackageName("clinical.web.game.forms");

      FormBeanGenerator gen = new FormBeanGenerator(AssociationHelper
            .getInstance(), config, doc);

      StringWriter out = new StringWriter(4000);
      gen.generate(out);
      System.out.println(out.toString());
   }

   public void testUpdateStrutsConfigFile() throws Exception {
      StrutsCodeGenerator gen = new StrutsCodeGenerator(config, doc);

      gen.updateStrutsConfigFile();
   }

   public void testStrutsCodegenHelper() throws Exception {
       StrutsCodegenHelper helper = new StrutsCodegenHelper(config);
       helper.updateConstantsJavaFile();
       helper.updateCADispatcherActionJavaFile();
       helper.updateStrutsConfigTemplateFile();
       
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      //suite.addTest(new StrutsCodeGenTest("testGenerate"));
      // suite.addTest( new StrutsCodeGenTest("testUpdateStrutsConfigFile") );
      suite.addTest( new StrutsCodeGenTest("testStrutsCodegenHelper"));
      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}