package caslayout.test;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Iterator;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import caslayout.codegen.struts.StrutsCodegenConfig;
import caslayout.codegen.struts.StrutsJSPGenerator;
import caslayout.ui.CAPanel;
import caslayout.ui.Document;
import caslayout.ui.Page;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: StrutsJSPGeneratorTest.java,v 1.3 2008/10/14 23:21:16 bozyurt Exp $
 */
public class StrutsJSPGeneratorTest extends TestCase {
   Document doc;

   public StrutsJSPGeneratorTest(String name) {
      super(name);
   }

   protected void setUp() throws Exception {
      doc = Document.loadDocument("/home/bozyurt/mq_test1.xml", null);
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      suite.addTest(new StrutsJSPGeneratorTest("testGenerate"));
      return suite;
   }

   public void testGenerate() throws Exception {

      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = (Page) iter.next();
         CAPanel panel = page.getViewPanel();
         StrutsCodegenConfig config = new StrutsCodegenConfig();
         String[] jspNames = { "MQTest1.jsp" };
         config.setJspPageNames(jspNames);
         config.setStrutsActionRoot("/man_mq_test");
         config.setStrutsConfigFile("/home/bozyurt/tmp/struts-config.xml");

         config.setFormBeanName("MQTest1Form");
         config.setPackageName("clinical.web.game.forms");
         config.setFormBeanID("mqTest1Form");
         config.setAppContext("/clinical");

         StrutsJSPGenerator gen = new StrutsJSPGenerator(panel, config, 1);
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(
                  "/home/bozyurt/tmp/MQTest1_Page1.jsp"));
            bout.write(out.toString());
         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
      }
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}