package caslayout.test;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Iterator;

import junit.framework.Test;
import junit.framework.TestSuite;
import caslayout.codegen.XFormsGenerator;
import caslayout.ui.CAPanel;
import caslayout.ui.Document;
import caslayout.ui.Page;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: XFormsOutputTest.java,v 1.6 2008/10/14 23:21:16 bozyurt Exp $
 */

public class XFormsOutputTest extends BaseTestCase {
  Document doc;
  public XFormsOutputTest(String name, String propsFile) {
    super(name, propsFile);
  }


  protected void setUp() throws Exception {
    doc = Document.loadDocument( getProperty("test.document") , null);
    //doc = Document.loadDocument("/home/bozyurt/aims.xml", null);
  }


  public void testGenerate() throws Exception {
    for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext(); ) {
      Page page = (Page)iter.next();
      CAPanel panel =  page.getViewPanel();
      XFormsGenerator gen = new XFormsGenerator(panel);
      StringWriter out = new StringWriter(20000);
      BufferedWriter bout = null;
      try {
        gen.generate(out);
        System.out.println(out.toString());
        bout = new BufferedWriter( new FileWriter(  getProperty("test.xforms.filename") ) );
        bout.write( out.toString());
      } finally {
        if (bout != null) try { bout.close(); } catch(Exception x) {}
      }
    }
  }

  public static Test suite() {
    TestSuite suite = new TestSuite();
    suite.addTest( new XFormsOutputTest("testGenerate", "test.properties") );
    return suite;
}

  public static void main(String[] args) {
    junit.textui.TestRunner.run( suite() );
  }
}