package caslayout.test;

import javax.swing.*;

import caslayout.ui.*;
import caslayout.util.*;
import junit.framework.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: XMLPersistenceTest.java,v 1.2 2004/08/04 02:23:04 bozyurt Exp $
 */
public class XMLPersistenceTest extends TestCase {
  CAPanel panel;
  public XMLPersistenceTest(String name) {
    super(name);
  }

  protected void setUp() throws Exception {
    JPanel p = new JPanel();
    CAGridLayout layoutMan = new CAGridLayout(1,1, false);
    panel = new CAPanel(layoutMan, 3, 3, 100, 200);
    TextDisplayComponent td = new TextDisplayComponent("first line\n second line\n third line",5,5,p);
    panel.add(td,0);
  }

  protected void tearDown() throws Exception {}

  public void testSavePanel() throws Exception {
    XMLUtils.savePanel("/home/bozyurt/panel.xml", panel);
  }
  public void testLoadPanel() throws Exception {
    JPanel p = new JPanel();
    CAPanel caPanel = XMLUtils.loadPanel("/home/bozyurt/panel.xml", p);
    TextDisplayComponent td = (TextDisplayComponent) caPanel.getComponents().get(0);
    String text = td.getLabel().getText();
    System.out.println("text="+ text);
  }

  public static Test suite() {
   TestSuite suite = new TestSuite();
   suite.addTest( new XMLPersistenceTest("testSavePanel") );
   suite.addTest( new XMLPersistenceTest("testLoadPanel") );
   return suite;

 }

 public static void main(String[] args) {
    junit.textui.TestRunner.run( suite() );
 }


}