package caslayout.test;

import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

import org.apache.xpath.*;
import org.w3c.dom.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
import junit.framework.*;


/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: XPathTest.java,v 1.5 2004/09/09 02:12:12 bozyurt Exp $
 */
public class XPathTest extends TestCase {

  public XPathTest(String name) {
    super(name);
  }


  public void testXSLTransform() throws Exception {
      String xslFile = "/home/bozyurt/dev/java/cas_layout/y.xsl";
      String xmlFile = "/home/bozyurt/dev/java/cas_layout/test_xform.xml";

      TransformerFactory factory = TransformerFactory.newInstance();
      Transformer transformer =  factory.newTransformer(  new StreamSource(xslFile) );

      transformer.setOutputProperty("standalone","no");
      transformer.setOutputProperty("omit-xml-declaration","yes");
      transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount","3");
      transformer.setOutputProperty("{http://xml.apache.org/xslt}omit-meta-tag","yes");


      Properties props = transformer.getOutputProperties();
      props.list( System.out );

      BufferedOutputStream out = null;
      try {
        out = new BufferedOutputStream(
          new FileOutputStream("/home/bozyurt/dev/java/clinical/web/pages/assessment/QuickMood.jsp") );

        transformer.transform(new StreamSource(xmlFile),
                              new StreamResult( out ));
      } finally {
        if (out != null) try { out.close(); } catch(Exception x) {}
      }
  }

  public void testXSLTransform2() throws Exception {
      String xslFile = "/home/bozyurt/dev/java/cas_layout/sars.xsl";
      String xmlFile = "/home/bozyurt/dev/java/cas_layout/test_xform.xml";

      TransformerFactory factory = TransformerFactory.newInstance();
      Transformer transformer =  factory.newTransformer(  new StreamSource(xslFile) );

      transformer.setOutputProperty("standalone","no");
      transformer.setOutputProperty("omit-xml-declaration","yes");
      transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount","3");
      transformer.setOutputProperty("{http://xml.apache.org/xslt}omit-meta-tag","yes");


      Properties props = transformer.getOutputProperties();
      props.list( System.out );

      BufferedOutputStream out = null;
      try {
        out = new BufferedOutputStream(
          new FileOutputStream("/home/bozyurt/dev/java/cas_layout/sars.jsp") );

        transformer.transform(new StreamSource(xmlFile),
                              new StreamResult( out ));
      } finally {
        if (out != null) try { out.close(); } catch(Exception x) {}
      }
  }



  public void testXPath() throws Exception {
    String xpathQuery="//calm:score[@id='C34']/calm:display-name";
    xpathQuery = "//calm:field[@id='C118']/@name";
    InputSource in = new InputSource( new FileInputStream("/home/bozyurt/dev/java/cas_layout/gen/quick_mood_scale_1.xml") );
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    factory.setNamespaceAware(true);
    Document doc = factory.newDocumentBuilder().parse(in);

    //set up an identity transformer to use as a serializer
    Transformer serializer = TransformerFactory.newInstance().newTransformer();

    serializer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
    NodeIterator nl = XPathAPI.selectNodeIterator(doc, xpathQuery);

    Node n;
    while( ( n = nl.nextNode()) != null) {
      if ( isTextNode(n) ) {
        StringBuffer buf = new StringBuffer( n.getNodeValue() );
        for( Node nd = n.getNextSibling(); isTextNode(nd); nd = nd.getNextSibling() ) {
          buf.append( nd.getNodeValue() );
        }
        System.out.print(buf.toString());
      } else {
        serializer.transform( new DOMSource(n),
                              new StreamResult( new OutputStreamWriter( System.out) ) );
      }
      System.out.println();
    }

  }

  public void testXPath2() throws Exception {
    String xpathQuery="//calm:score[@id='C34']/calm:display-name";
    xpathQuery = "//calm:id[@value='C21']/../xforms:label/../calm:css";
    InputSource in = new InputSource( new FileInputStream("/home/bozyurt/dev/java/cas_layout/test_xform.xml") );
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    factory.setNamespaceAware(true);
    Document doc = factory.newDocumentBuilder().parse(in);

    //set up an identity transformer to use as a serializer
    Transformer serializer = TransformerFactory.newInstance().newTransformer();

    serializer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
    NodeIterator nl = XPathAPI.selectNodeIterator(doc, xpathQuery);

    Node n;
    while( ( n = nl.nextNode()) != null) {
      if ( isTextNode(n) ) {
        StringBuffer buf = new StringBuffer( n.getNodeValue() );
        for( Node nd = n.getNextSibling(); isTextNode(nd); nd = nd.getNextSibling() ) {
          buf.append( nd.getNodeValue() );
        }
        System.out.print(buf.toString());
      } else {
        serializer.transform( new DOMSource(n),
                              new StreamResult( new OutputStreamWriter( System.out) ) );
      }
      System.out.println();
    }

  }


  private boolean isTextNode(Node n) {
    if ( n == null) return false;
    short nodeType = n.getNodeType();
    return nodeType == Node.CDATA_SECTION_NODE || nodeType == Node.TEXT_NODE;
  }

  public static Test suite() {
    TestSuite suite = new TestSuite();
    // suite.addTest( new XPathTest("testXPath2") );
    //suite.addTest( new XPathTest("testXSLTransform") );

    suite.addTest( new XPathTest("testXSLTransform2") );
    return suite;
  }

   public static void main(String[] args) {
     junit.textui.TestRunner.run( suite() );
   }

}