package caslayout.test;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import junit.framework.Test;
import junit.framework.TestSuite;
import caslayout.codegen.StrutsStyleSheetGenerator;
import caslayout.codegen.StyleSheetGenerator;
import caslayout.codegen.struts.StrutsCodegenConfig;
import caslayout.ui.CAPanel;
import caslayout.ui.Document;
import caslayout.ui.Page;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: XSLOutputTest.java,v 1.7 2008/10/14 23:21:16 bozyurt Exp $
 */
public class XSLOutputTest extends BaseTestCase {
   Document doc;

   public XSLOutputTest(String name, String propsFile) {
      super(name, propsFile);
   }

   protected void setUp() throws Exception {
      // doc = Document.loadDocument("/home/bozyurt/aims.xml", null);
      doc = Document.loadDocument(getProperty("test.document"), null);
   }

   public void testGenerate() throws Exception {
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = (Page) iter.next();
         CAPanel panel = page.getViewPanel();
         StyleSheetGenerator gen = new StyleSheetGenerator(panel);
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(
                  getProperty("test.xsl_for_struts")));
            bout.write(out.toString());
         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
      }
   }

   public void testStrutsGenerate() throws Exception {
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = (Page) iter.next();
         CAPanel panel = page.getViewPanel();
         StrutsCodegenConfig config = new StrutsCodegenConfig();
         config.setFormBeanID(getProperty("test.struts.formbean.id"));

         StrutsStyleSheetGenerator gen = new StrutsStyleSheetGenerator(panel,
               config, 1);
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(
                  getProperty("test.xsl_for_struts")));
            bout.write(out.toString());
         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
      }
   }

   public void testStrutsGenerate2() throws Exception {
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = (Page) iter.next();
         CAPanel panel = page.getViewPanel();
         StrutsCodegenConfig config = new StrutsCodegenConfig();
         config.setFormBeanID(getProperty("test.struts.formbean.id"));
         config
               .setJspPageNames(new String[] { getProperty("test.struts.jsp.page.name") });

         StrutsStyleSheetGenerator gen = new StrutsStyleSheetGenerator(panel,
               config, 1);
         StringWriter out = new StringWriter(20000);
         BufferedWriter bout = null;
         try {
            gen.generate(out);
            System.out.println(out.toString());
            bout = new BufferedWriter(new FileWriter(
                  getProperty("test.xsl_for_struts")));
            bout.write(out.toString());
         } finally {
            if (bout != null)
               try {
                  bout.close();
               } catch (Exception x) {}
         }
      }
   }

   public void testXSLTransform() throws Exception {
      String xslFile = getProperty("test.xsl_for_struts"); // "/home/bozyurt/dev/java/cas_layout/sars.xsl";
      String xmlFile = getProperty("test.xforms.filename"); // "/home/bozyurt/dev/java/cas_layout/test_xform.xml";

      TransformerFactory factory = TransformerFactory.newInstance();
      Transformer transformer = factory
            .newTransformer(new StreamSource(xslFile));

      transformer.setOutputProperty("standalone", "no");
      transformer.setOutputProperty("omit-xml-declaration", "yes");
      transformer.setOutputProperty(
            "{http://xml.apache.org/xslt}indent-amount", "3");
      transformer.setOutputProperty(
            "{http://xml.apache.org/xslt}omit-meta-tag", "yes");

      Properties props = transformer.getOutputProperties();
      props.list(System.out);

      BufferedOutputStream out = null;
      try {
         out = new BufferedOutputStream(new FileOutputStream(
               getProperty("test.struts.jsp.filename"))); // "/home/bozyurt/dev/java/cas_layout/sars.jsp")
                                                            // );

         transformer
               .transform(new StreamSource(xmlFile), new StreamResult(out));
      } finally {
         if (out != null)
            try {
               out.close();
            } catch (Exception x) {}
      }
   }

   public static Test suite() {
      TestSuite suite = new TestSuite();
      // suite.addTest( new XSLOutputTest("testGenerate") );
      suite
            .addTest(new XSLOutputTest("testStrutsGenerate2", "test.properties"));
      suite.addTest(new XSLOutputTest("testXSLTransform", "test.properties"));

      return suite;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}