package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import caslayout.ui.model.AsDiffInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentDifferenceDialog.java,v 1.3 2007/04/16 23:22:59
 *          bozyurt Exp $
 */
public class AssessmentDifferenceDialog extends BaseDialog {
   private static final long serialVersionUID = -8801682043327676404L;
   protected List<AsDiffInfo> diffList;
   protected JTextArea textArea;

   public AssessmentDifferenceDialog(Frame owner, String title,
         List<AsDiffInfo> diffList, String asName) {
      super(owner, title, new String[] { "OK" });
      this.diffList = diffList;
      textArea = new JTextArea(10, 80);
      textArea.setEditable(false);

      textArea.setText(prepareDiffReport());

      JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
      mainPanel.setBorder(BorderFactory
            .createTitledBorder("Difference from Database for Assessment "
                  + asName));
      mainPanel.add(new JScrollPane(textArea));

      this.getContentPane().add(mainPanel);
      pack();
   }

   protected String prepareDiffReport() {
      if (diffList.isEmpty()) {
         return "There is no difference between the reference assessment and the one in the database";
      }
      Map<String, List<AsDiffInfo>> scoreMap = new LinkedHashMap<String, List<AsDiffInfo>>();
      for (AsDiffInfo adi : diffList) {
         List<AsDiffInfo> scoreDiffList = scoreMap.get(adi.getId());
         if (scoreDiffList == null) {
            scoreDiffList = new ArrayList<AsDiffInfo>(5);
            scoreMap.put(adi.getId(), scoreDiffList);
         }
         scoreDiffList.add(adi);
      }

      StringBuffer buf = new StringBuffer(512);
      for (Iterator<List<AsDiffInfo>> iter = scoreMap.values().iterator(); iter
            .hasNext();) {
         List<AsDiffInfo> scoreDiffList = iter.next();
         String scoreName = scoreDiffList.get(0).getId();
         buf.append("Difference(s) for score " + scoreName).append("\n");
         for (AsDiffInfo adi : scoreDiffList) {
            buf.append("\t").append(adi.prepareMessage()).append("\n");
         }
      }
      return buf.toString();
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

}
