package caslayout.ui;

import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentListSelectDialog.java,v 1.3 2008/10/13 23:58:07 bozyurt Exp $
 */
public class AssessmentListSelectDialog extends BaseDialog implements PropertyChangeListener {
	protected FileNameValueField asDirField;
	protected JList asList;
	protected String asDir;
	private static final long serialVersionUID = 5066495590622011002L;

	public AssessmentListSelectDialog(Frame owner, String title, File defaultDir) {
		super(owner, title, new String[] { "Cancel", "OK"});
		setDefaultButton("Cancel");
		asDir = defaultDir != null ? defaultDir.getAbsolutePath() : null;
		init();
		if ( defaultDir != null) {
			updateModel(defaultDir);
	    }
		pack();
	}

	protected void init() {
		JPanel mainPanel = new JPanel(new BorderLayout(5,5));
		mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		asDirField = new FileNameValueField("CALM Assessments Directory: ", 25, FileNameValueField.DIR_ONLY);
		if ( asDir != null) {
			asDirField.setValue( asDir );
		}
		asDirField.addPropertyChangeListener(this);

		mainPanel.add(asDirField, BorderLayout.NORTH);

		JPanel listPanel = new JPanel(new BorderLayout(5,5));
		listPanel.setBorder( BorderFactory.createTitledBorder("Assessments"));
		asList = new JList( new DefaultListModel() );
		asList.getSelectionModel().setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		JScrollPane sp = new JScrollPane(asList);
		listPanel.add(sp);
		mainPanel.add(listPanel, BorderLayout.CENTER);

		getContentPane().add(mainPanel);
	}

	public List<String> getSelectedAssessments() {
		Object[] values = asList.getSelectedValues();
		List<String> asPathList = new ArrayList<String>( values.length );
		for (int i = 0; i < values.length; i++) {
			File f = new File(asDir, (String) values[i]);
			asPathList.add(f.getAbsolutePath());
		}
		return asPathList;
	}

	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				this.returnCode = OK_PRESSED;
			}
		}
		setVisible(false);
	}

	public void propertyChange(PropertyChangeEvent evt) {
        if ( evt.getPropertyName().equals("value")) {
        	File dir = new File( (String) evt.getNewValue() );
        	if ( dir.isDirectory()) {
        		this.asDir = dir.getAbsolutePath();
        		updateModel(dir);
        	}

        }
	}

	protected void updateModel(File dir) {
		File[] asFiles = dir.listFiles( new FilenameFilter() {
			public boolean accept(File dir, String name) {
				return name.endsWith(".xml");
			}
		});
		DefaultListModel model =  (DefaultListModel) asList.getModel();
		model.clear();
		for (int i = 0; i < asFiles.length; i++) {
			model.addElement(asFiles[i].getName());
		}
	}


}
