package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentSelectionDialog.java,v 1.3 2005/12/01 01:01:57
 *          bozyurt Exp $
 */
public class AssessmentSelectionDialog extends BaseDialog {
	private static final long serialVersionUID = -8789793706167901522L;
	JList asNameList;

	public AssessmentSelectionDialog(Frame owner, String title, List<String> asNames) {
		super(owner, title, new String[] { "Cancel", "OK" });
		super.setDefaultButton("Cancel");

		JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
		mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory
				.createEmptyBorder(5, 5, 5, 5), BorderFactory
				.createTitledBorder("Select an assessment:")));
		asNameList = new JList(asNames.toArray());
		asNameList.getSelectionModel().setSelectionMode(
				ListSelectionModel.SINGLE_SELECTION);
		JScrollPane scrollPane = new JScrollPane(asNameList);
		mainPanel.add(scrollPane);
		mainPanel.setPreferredSize(new Dimension(300, 200));
		getContentPane().add(mainPanel);

		pack();
	}

	public String getSelectedAssessmentName() {
		return (String) asNameList.getSelectedValue();
	}

	public void actionPerformed(ActionEvent e) {
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("ok")) {
				if (asNameList.getSelectedIndex() == -1) {
					CALMHelper.showError(this, "Please select an assessment!");
					return;
				} else {
					this.returnCode = OK_PRESSED;
				}
			}
		}
		setVisible(false);
	}

}
