package caslayout.ui;

import guilib.common.BaseDialog;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;

import org.apache.log4j.Logger;

import caslayout.ui.model.Association;
import caslayout.ui.model.AssociationHelper;
import caslayout.ui.model.DefaultNodeRenderer;
import caslayout.ui.model.MandatoryFieldAssociation;
import caslayout.ui.model.ScoreAssociation;
import caslayout.ui.model.ScoreCodeInfo;
import caslayout.ui.model.ScoreInfo;
import caslayout.util.IComparable;

/**
 * Currently NOT USED
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssocDialog.java,v 1.13 2008/10/13 23:58:07 bozyurt Exp $
 */

public class AssocDialog extends BaseDialog implements TreeSelectionListener {
   protected JPanel mainPanel;
   protected JTree docTree;
   protected ScoreInfo scoreInfo;
   protected String mandatoryField;
   protected JLabel assocLabel;
   protected JComboBox scoreNameAssocCombo;
   protected JComboBox scoreValueAssocCombo;
   protected CAContainer selectedContainer;
   /** a single selected compoenent */
   protected AbstractDisplayComponent selectedField;
   protected LinkedHashMap<String, AbstractDisplayComponent> compMap = new LinkedHashMap<String, AbstractDisplayComponent>();
   protected JTable ascTable;
   protected JPanel controlPanel;
   protected static Logger log = Logger.getLogger("AssocDialog");
   private static final long serialVersionUID = 8041650472879599072L;

   public AssocDialog(Frame owner, String title, ScoreInfo scoreInfo,
         DefaultMutableTreeNode docRoot) {
      super(owner, title, new String[] { "Cancel", "OK" });
      super.setDefaultButton("Cancel");
      this.scoreInfo = scoreInfo;
      init(docRoot, true);
      setSize(new Dimension(450, 480));
   }

   public AssocDialog(Frame owner, String title, String mandatoryField,
         DefaultMutableTreeNode docRoot) {
      super(owner, title, new String[] { "Cancel", "OK" });
      super.setDefaultButton("Cancel");
      this.mandatoryField = mandatoryField;
      init(docRoot, false);
      setSize(new Dimension(450, 480));
   }

   protected void initForMandatoryField() {

      this.controlPanel = new JPanel(new BorderLayout(5, 5));
      controlPanel.setBorder(BorderFactory.createTitledBorder("Association"));
      AssociationHelper ah = AssociationHelper.getInstance();
      assocLabel = new JLabel("Mandatory Field '" + mandatoryField
            + " is not associated");
      MandatoryFieldAssociation mfa = ah
            .findMandatoryFieldAssociation(mandatoryField);
      if (mfa != null) {
         assocLabel.setText("Mandatory Field '" + mandatoryField
               + " is associated with component " + mfa.getRight().getId());
      }
      controlPanel.add(assocLabel, BorderLayout.NORTH);
   }

   @SuppressWarnings("unchecked")
   protected DefaultMutableTreeNode extractAllTextFields(
         DefaultMutableTreeNode docRoot) {
      DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode(docRoot
            .getUserObject());
      boolean first = true;
      DefaultMutableTreeNode newParent = null;
      Enumeration enumer = docRoot.breadthFirstEnumeration();
      while (enumer.hasMoreElements()) {
         DefaultMutableTreeNode node = (DefaultMutableTreeNode) enumer
               .nextElement();
         if (first) {
            newRoot = new DefaultMutableTreeNode(node.getUserObject());
            newParent = newRoot;
            first = false;
            continue;
         }
         if (node.getUserObject() instanceof FormNodeInfo) {
            FormNodeInfo ni = (FormNodeInfo) node.getUserObject();
            AbstractDisplayComponent adc = (AbstractDisplayComponent) ni
                  .getData();
            if (adc instanceof TextFieldDisplayComponent) {
               newParent.add(new DefaultMutableTreeNode(ni));
            }
         }
      }
      return newRoot;
   }

   protected void init(DefaultMutableTreeNode docRoot, boolean forScoreInfo) {
      if (!forScoreInfo) {
         // DefaultMutableTreeNode newTreeRoot = extractAllTextFields(docRoot);
         // docTree = new JTree( newTreeRoot);
      }
      docTree = new JTree(docRoot);

      docTree.setCellRenderer(new DefaultNodeRenderer());

      docTree.getSelectionModel().setSelectionMode(
            TreeSelectionModel.SINGLE_TREE_SELECTION);
      docTree.addTreeSelectionListener(this);

      docTree.expandRow(0);
      mainPanel = new JPanel(new BorderLayout(5, 5));
      mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      JScrollPane docPane = new JScrollPane(docTree);
      docPane.setBorder(BorderFactory
            .createTitledBorder("Form Document Hierarchy"));

      if (forScoreInfo) {
         initForScoreInfo(docRoot);
      } else {
         initForMandatoryField();
      }
      mainPanel.add(docPane);
      mainPanel.add(controlPanel, BorderLayout.SOUTH);
      getContentPane().add(mainPanel);
   }

   protected void initForScoreInfo(DefaultMutableTreeNode docRoot) {
      JPanel scoreCodeAssocPanel = null;
      this.controlPanel = new JPanel(new BorderLayout(5, 5));

      controlPanel.setBorder(BorderFactory.createTitledBorder("Association"));
      AssociationHelper ah = AssociationHelper.getInstance();
      assocLabel = new JLabel("Score " + scoreInfo.getScoreName()
            + " is not associated");
      ScoreAssociation sa = (ScoreAssociation) ah.getAssocMap().get(scoreInfo);
      if (sa != null) {
         assocLabel.setText("Score " + scoreInfo.getScoreName()
               + " is associated with component " + sa.getRHSID());
      }

      controlPanel.add(assocLabel, BorderLayout.NORTH);

      JPanel labelPanel = new JPanel(new GridLayout(2, 1, 4, 4));
      labelPanel.add(new JLabel("Score Name", JLabel.LEFT));
      labelPanel.add(new JLabel("Score Value", JLabel.LEFT));

      JPanel fieldPanel = new JPanel(new GridLayout(2, 1, 4, 4));
      scoreNameAssocCombo = new JComboBox(new VisualCompListModel());
      VisualCompListModel svacModel = new VisualCompListModel();
      scoreValueAssocCombo = new JComboBox(svacModel);

      if (sa != null && sa.getScoreValue() != null) {
         ScoreValueComparator svc = new ScoreValueComparator(
               (AbstractDisplayComponent) sa.getScoreValue());
         DefaultMutableTreeNode n = findNode(docRoot, svc);
         log.info(" found node " + n);
         if (n != null) {
            svacModel.update(n);
            // first index is empty string
            scoreValueAssocCombo.setSelectedIndex(1);
            if (scoreInfo.getScoreCodes() != null) {
               scoreCodeAssocPanel = createScoreCodePanel(n);
            }
         }
      }
      fieldPanel.add(scoreNameAssocCombo);
      fieldPanel.add(scoreValueAssocCombo);

      JPanel p = new JPanel(new GridLayout(1, 2, 4, 4));
      p.add(labelPanel);
      p.add(fieldPanel);
      controlPanel.add(p, BorderLayout.CENTER);
      if (scoreCodeAssocPanel != null) {
         controlPanel.add(scoreCodeAssocPanel, BorderLayout.SOUTH);
      }
   }

   protected void prepareScoreValueComponents(DefaultMutableTreeNode node,
         LinkedHashMap<String, AbstractDisplayComponent> itemMap) {
      FormNodeInfo ni = (FormNodeInfo) node.getUserObject();
      AbstractDisplayComponent adc = (AbstractDisplayComponent) ni.getData();
      if (adc instanceof CAContainer) {
         CAContainer c = (CAContainer) adc;
         if (c.getIsGroup()) {
            for (int i = 0; i < node.getChildCount(); i++) {
               DefaultMutableTreeNode child = (DefaultMutableTreeNode) node
                     .getChildAt(i);
               prepareScoreValueComponents(child, itemMap);
            }
         }
      } else {
         itemMap.put(ni.getLabel(), adc);
      }
   }

   protected JPanel createScoreCodePanel(DefaultMutableTreeNode node) {
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      List<ScoreCodeInfo> ascList = scoreInfo.getScoreCodes();

      prepareScoreValueComponents(node, compMap);
      // use only labels
      String[] svcs = new String[compMap.size()];
      int i = 0;
      for (Iterator<String> iter = compMap.keySet().iterator(); iter.hasNext();) {
         String label = iter.next();
         svcs[i++] = label;
      }

      String[] curCompSelections = new String[svcs.length];
      for (i = 0; i < curCompSelections.length; i++) {
         curCompSelections[i] = svcs[i];
      }
      TableModel tm = new TableModel(ascList, curCompSelections);

      ascTable = new JTable(tm);
      ascTable.setPreferredScrollableViewportSize(new Dimension(220, 80));
      TableColumn compColumn = ascTable.getColumnModel().getColumn(1);
      JComboBox cb = new JComboBox();
      for (i = 0; i < svcs.length; i++) {
         cb.addItem(svcs[i]);
      }
      compColumn.setCellEditor(new DefaultCellEditor(cb));

      panel.setBorder(BorderFactory
            .createTitledBorder("Associate Score Values with GUI Components"));
      JScrollPane scrollPane = new JScrollPane(ascTable);
      panel.add(scrollPane);

      return panel;
   }

   class TableModel extends AbstractTableModel {
      private static final long serialVersionUID = -8725820828473152664L;
      private String[] columnNames;
      private Object[][] data;

      public TableModel(List<ScoreCodeInfo> ascList, String[] currentCompSelections) {
         this.columnNames = new String[] { "Score Value",
               "Associated Component" };
         data = new Object[ascList.size()][2];
         int i = 0;
         for (ScoreCodeInfo asc : ascList) {
            data[i][0] = asc.getScoreCodeValue();
            data[i][1] = currentCompSelections[i];
            ++i;
         }
      }

      public int getRowCount() {
         return data.length;
      }

      public int getColumnCount() {
         return columnNames.length;
      }

      public Object getValueAt(int row, int col) {
         return data[row][col];
      }

      public String getColumnName(int col) {
         return columnNames[col];
      }

      public Class<?> getColumnClass(int col) {
         return getValueAt(0, col).getClass();
      }

      public boolean isCellEditable(int row, int col) {
         if (col == 1)
            return true;
         return false;
      }

      public void setValueAt(Object value, int row, int col) {
         data[row][col] = value;
         fireTableCellUpdated(row, col);
      }
   }

   public void actionPerformed(ActionEvent e) {
      this.returnCode = BaseDialog.NONE;
      if (e.getSource() instanceof JButton) {
         JButton button = (JButton) e.getSource();
         if (button.getText().equalsIgnoreCase("ok")) {
            this.returnCode = OK_PRESSED;
         }
      }
      setVisible(false);
   }

   public MandatoryFieldAssociation getMandatoryFieldAssociation() {
      MandatoryFieldAssociation mfa = AssociationHelper.getInstance()
            .findMandatoryFieldAssociation(mandatoryField);
      if (mfa == null && selectedField != null) {
         mfa = new MandatoryFieldAssociation(mandatoryField,
               Association.BIDIRECTIONAL, mandatoryField,
               (TextFieldDisplayComponent) selectedField);
      } else if (mfa != null) {
         mfa.setRight(selectedField);
      }

      return mfa;
   }

   /**
    * Based on the user's selections creates a ScoreAssociation
    *
    * @return
    */
   public ScoreAssociation getScoreAssociation() {
      ScoreAssociation sa = (ScoreAssociation) AssociationHelper.getInstance()
            .getAssocMap().get(scoreInfo);
      if (sa == null || selectedContainer != null) {
         sa = new ScoreAssociation(scoreInfo.getScoreName(),
               Association.BIDIRECTIONAL, scoreInfo, selectedContainer);
      }
      VisualCompListModel nameAssocModel = (VisualCompListModel) scoreNameAssocCombo
            .getModel();
      String nameAssocLabel = (String) scoreNameAssocCombo.getSelectedItem();
      AbstractDisplayComponent adc = (AbstractDisplayComponent) nameAssocModel.itemMap
            .get(nameAssocLabel);

      if (adc != null && adc instanceof TextDisplayComponent) {
         sa.associateScoreName((TextDisplayComponent) adc);
      }

      VisualCompListModel valueAssocModel = (VisualCompListModel) scoreValueAssocCombo
            .getModel();
      String valueAssocLabel = (String) scoreValueAssocCombo.getSelectedItem();
      adc = (AbstractDisplayComponent) valueAssocModel.itemMap
            .get(valueAssocLabel);
      if (adc != null && (adc instanceof CAContainer)) {
         CAContainer c = (CAContainer) adc;
         if (c.getIsGroup()) {
            sa.associateScoreValue(c);
         }
      }

      /**
       * @todo Also set score codes namely set the corresponding value for the
       *       display component like radio button and check box groups
       */
      if (ascTable != null) {
         TableModel tm = (TableModel) ascTable.getModel();
         for (int i = 0; i < tm.data.length; i++) {
            AbstractDisplayComponent ac = this.compMap
                  .get(tm.data[i][1]);
            ScoreCodeInfo sci = scoreInfo.findScoreCode((String) tm.data[i][0]);

            if (ac instanceof RadioButtonDisplayComponent) {
               RadioButtonDisplayComponent rdc = (RadioButtonDisplayComponent) ac;
               rdc.setValue(sci.getScoreCode());
            } else if (ac instanceof CheckBoxDisplayComponent) {
               CheckBoxDisplayComponent cdc = (CheckBoxDisplayComponent) ac;
               cdc.setValue(sci.getScoreCode());
            }
         }
      }
      return sa;
   }

   public void valueChanged(TreeSelectionEvent e) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) docTree
            .getLastSelectedPathComponent();
      if (node == null)
         return;
      FormNodeInfo ni = (FormNodeInfo) node.getUserObject();
      if (ni.getData() instanceof CAContainer
            && ((CAContainer) ni.getData()).getIsGroup()) {
         CAContainer c = (CAContainer) ni.getData();
         selectedContainer = c;
         assocLabel.setText("Score " + scoreInfo.getScoreName()
               + " is associated with component " + c.getId());
         DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) node
               .getParent();
         VisualCompListModel model = (VisualCompListModel) scoreNameAssocCombo
               .getModel();
         model.update(parentNode);
         model = (VisualCompListModel) scoreValueAssocCombo.getModel();
         model.update(node);

         if (scoreInfo.getScoreCodes() != null) {
            // show the score code association panel
            JPanel scoreCodeAssocPanel = createScoreCodePanel(node);
            controlPanel.add(scoreCodeAssocPanel, BorderLayout.SOUTH);
            invalidate();
         }

      } else if (mandatoryField != null
            && ni.getData() instanceof TextFieldDisplayComponent) {
         TextFieldDisplayComponent tfdc = (TextFieldDisplayComponent) ni
               .getData();
         assocLabel.setText("Mandatory Field '" + mandatoryField
               + "' is associated with component " + tfdc.getId());
         this.selectedField = tfdc;

      }
   }

   class VisualCompListModel extends AbstractListModel implements ComboBoxModel {
      private static final long serialVersionUID = 1L;
      List<String> items = new ArrayList<String>();
      Map<String, AbstractDisplayComponent> itemMap = new HashMap<String, AbstractDisplayComponent>();
      public Object selectedItem;

      public VisualCompListModel() {
         items.add("");
      }

      protected void prepare(DefaultMutableTreeNode parentNode, String indent) {
         FormNodeInfo ni = (FormNodeInfo) parentNode.getUserObject();
         AbstractDisplayComponent adc = (AbstractDisplayComponent) ni.getData();
         if (adc instanceof CAContainer) {
            CAContainer c = (CAContainer) adc;
            if (c.getIsGroup()) {
               String item = indent + ni.getLabel();
               itemMap.put(item, c);
               items.add(item);
            }
         } else {
            String item = indent + ni.getLabel();
            itemMap.put(item, adc);
            items.add(item);
         }
         for (int i = 0; i < parentNode.getChildCount(); i++) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode) parentNode
                  .getChildAt(i);
            prepare(child, indent + "  ");
         }
      }

      public void update(DefaultMutableTreeNode parentNode) {
         items.clear();
         itemMap.clear();
         items.add("");
         prepare(parentNode, "");

         fireContentsChanged(this, 0, items.size());
      }

      public Object getElementAt(int index) {
         if (index < 0 || index > items.size())
            return null;
         return items.get(index);
      }

      public int getSize() {
         return items.size();
      }

      public void setSelectedItem(Object anItem) {
         selectedItem = anItem;
      }

      public Object getSelectedItem() {
         return selectedItem;
      }
   }

   @SuppressWarnings("unchecked")
   public static DefaultMutableTreeNode findNode(DefaultMutableTreeNode parent,
         IComparable ic) {
      Enumeration enumer = parent.breadthFirstEnumeration();
      while (enumer.hasMoreElements()) {
         DefaultMutableTreeNode node = (DefaultMutableTreeNode) enumer
               .nextElement();
         if (ic.matches(node))
            return node;
      }
      return null;

   }

   public static class ScoreValueComparator implements IComparable {
      AbstractDisplayComponent adc;

      public ScoreValueComparator(AbstractDisplayComponent adc) {
         this.adc = adc;
      }

      public boolean matches(Object o) {
         DefaultMutableTreeNode node = (DefaultMutableTreeNode) o;
         log.info("userObject = " + node.getUserObject());
         if (node.getUserObject() instanceof FormNodeInfo) {
            FormNodeInfo fni = (FormNodeInfo) node.getUserObject();
            AbstractDisplayComponent dc = (AbstractDisplayComponent) fni
                  .getData();
            return dc.getId().equals(adc.getId());
         }
         return false;
      }
   }

}
