package caslayout.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import caslayout.propedit.PropertyEditorPanel;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ButtonDisplayComponentCustomizer.java,v 1.5 2007/10/08 18:00:40
 *          bozyurt Exp $
 */

public class ButtonDisplayComponentCustomizer extends JPanel implements
      Customizer, PropertyChangeListener, ItemListener {

   private static final long serialVersionUID = -6517257569348173499L;
   protected JTextField buttonLabelField;
   protected JList questionList;
   protected JCheckBox jsOnlyCB;
   protected JPanel optionsPanel;
   protected JPanel noOptionsPanel;
   protected ButtonDisplayComponent buttonComp;
   protected QuestionListSelectionHandler qlSelHandler;
   protected PropertyEditorPanel pep;
   protected String[] data;

   public ButtonDisplayComponentCustomizer() {
      setLayout(new BorderLayout(5, 5));
      setBorder(BorderFactory.createTitledBorder("Button Properties"));
      noOptionsPanel = new JPanel(new BorderLayout());
      noOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory
            .createEmptyBorder(5, 5, 5, 5), BorderFactory
            .createTitledBorder("Options")));
      noOptionsPanel.add(new JLabel("no options available"));

      prepareOptionsPanel();
      setMinimumSize(new Dimension(280, 300));
      setPreferredSize(new Dimension(280, 300));
   }

   protected void prepareOptionsPanel() {
      optionsPanel = new JPanel();
      optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory
            .createEmptyBorder(5, 5, 5, 5), BorderFactory
            .createTitledBorder("Options")));
      BoxLayout bl = new BoxLayout(optionsPanel, BoxLayout.Y_AXIS);
      optionsPanel.setLayout(bl);
      JPanel p = new JPanel(new FlowLayout());
      p.add(new JLabel("Button Label:"));
      p.add(buttonLabelField = new JTextField("Skip", 10));

      buttonLabelField.getDocument().addDocumentListener(
            new DocumentListener() {
               public void changedUpdate(DocumentEvent de) {}

               public void insertUpdate(DocumentEvent de) {
                  if (buttonLabelField.getText().trim().length() > 0) {
                     buttonComp.setLabel(buttonLabelField.getText().trim());
                  }
               }

               public void removeUpdate(DocumentEvent de) {
                  if (buttonLabelField.getText().trim().length() > 0) {
                     buttonComp.setLabel(buttonLabelField.getText().trim());
                  }
               }
            });

      optionsPanel.add(Box.createVerticalStrut(4));
      optionsPanel.add(p);
      optionsPanel.add(Box.createVerticalStrut(4));
      jsOnlyCB = new JCheckBox("JavaScript only", true);
      jsOnlyCB.addItemListener(this);
      optionsPanel.add(jsOnlyCB);

      optionsPanel.add(Box.createVerticalStrut(4));

      Map<String, String> qid2ScoreMap = QuestionGroupRepository.getInstance()
            .getQIDScoreNameMap();
      this.data = new String[qid2ScoreMap.size()];
      int idx = 0;
      for (Map.Entry<String, String> entry : qid2ScoreMap.entrySet()) {
         String label = entry.getKey() + " - " + entry.getValue();
         data[idx++] = label;
      }
      Arrays.sort(data, new Comparator<String>() {
         public int compare(String o1, String o2) {
            String s1 = o1.substring(0, o1.indexOf(' '));
            String s2 = o2.substring(0, o2.indexOf(' '));
            return Integer.parseInt(s1) - Integer.parseInt(s2);
         }
      });

      JPanel qlPanel = new JPanel(new BorderLayout(3, 3));
      qlPanel.setBorder(BorderFactory
            .createTitledBorder("Questions to be Skipped"));

      questionList = new JList(data);
      questionList
            .setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
      qlSelHandler = new QuestionListSelectionHandler();
      questionList.getSelectionModel().addListSelectionListener(qlSelHandler);
      JScrollPane sp = new JScrollPane(questionList);
      sp.setPreferredSize(new Dimension(100, 70));
      qlPanel.add(sp);

      optionsPanel.add(qlPanel);
   }

   public void propertyChange(PropertyChangeEvent pce) {
      if (pce.getPropertyName() != null
            && pce.getPropertyName().equals("action")) {
         showOptionsPanel();
      }
   }

   private void showOptionsPanel() {
      if (buttonComp != null) {
         ButtonType bt = buttonComp.getAction();
         if (bt == ButtonType.SKIP_BUTTON) {
            remove(noOptionsPanel);
            add(optionsPanel);
            setQuestionListSelection();

            this.validate();
            this.repaint();
         } else {
            remove(this.optionsPanel);
            setQuestionListSelection();

            add(this.noOptionsPanel);
            this.validate();
            this.repaint();
         }
      }
   }

   private Integer extractQuestionID(String label) {
      int idx = label.indexOf(" ");
      assert (idx > 0);
      return new Integer(label.substring(0, idx));
   }

   private void setQuestionListSelection() {
      questionList.clearSelection();
      Map<Integer, Integer> qidMap = new HashMap<Integer, Integer>(17);
      for (Integer qid : buttonComp.getQuestionIDs()) {
         qidMap.put(qid, qid);
      }

      List<Integer> selIdxList = new ArrayList<Integer>();
      for (int i = 0; i < data.length; i++) {
         Integer qid = extractQuestionID(data[i]);
         if (qidMap.containsKey(qid)) {
            selIdxList.add(new Integer(i));
         }
      }

      int[] selIdxArr = new int[selIdxList.size()];
      for (int i = 0; i < selIdxArr.length; i++) {
         selIdxArr[i] = selIdxList.get(i).intValue();
      }

      questionList.setSelectedIndices(selIdxArr);

      jsOnlyCB.setSelected(buttonComp.getJavascriptOnly());
      buttonLabelField.setText(buttonComp.getLabel());
   }

   /**
    * Set the object to be customized.
    *
    * @param bean
    *           The object to be customized.
    * @todo Implement this java.beans.Customizer method
    */
   public void setObject(Object bean) {
      this.buttonComp = (ButtonDisplayComponent) bean;

      try {
         pep = new PropertyEditorPanel(this.buttonComp, false);
         this.add(pep, BorderLayout.NORTH);
         pep.addPropertyChangeListener(this);
         showOptionsPanel();
      } catch (Exception ex) {
         ex.printStackTrace();
      }
   }

   /**
    * Register a listener for the PropertyChange event.
    *
    * @param listener
    *           An object to be invoked when a PropertyChange event is fired.
    * @todo Implement this java.beans.Customizer method
    */
   public void addPropertyChangeListener(PropertyChangeListener listener) {}

   /**
    * Remove a listener for the PropertyChange event.
    *
    * @param listener
    *           The PropertyChange listener to be removed.
    * @todo Implement this java.beans.Customizer method
    */
   public void removePropertyChangeListener(PropertyChangeListener listener) {}

   class QuestionListSelectionHandler implements ListSelectionListener {
      List<Object> qidList = new ArrayList<Object>();

      public List<Object> getQidList() {
         return qidList;
      }

      public void valueChanged(ListSelectionEvent e) {
         if (e.getValueIsAdjusting()) {
            return;
         }
         ListSelectionModel lsm = (ListSelectionModel) e.getSource();
         if (!lsm.isSelectionEmpty()) {
            qidList.clear();
            int minIdx = lsm.getMinSelectionIndex();
            int maxIdx = lsm.getMaxSelectionIndex();
            ButtonDisplayComponentCustomizer.this.buttonComp.clearQuestionIDs();
            for (int i = minIdx; i <= maxIdx; i++) {
               if (lsm.isSelectedIndex(i)) {
                  String label = (String) ButtonDisplayComponentCustomizer.this.questionList
                        .getModel().getElementAt(i);
                  Integer qid = extractQuestionID(label);
                  ButtonDisplayComponentCustomizer.this.buttonComp
                        .addQuestionID(qid);

                  qidList
                        .add(ButtonDisplayComponentCustomizer.this.questionList
                              .getModel().getElementAt(i));
               }
            }
         }
      }
   } // ;

   /**
    * Invoked when an item has been selected or deselected by the user.
    *
    * @param e
    *           ItemEvent
    * @todo Implement this java.awt.event.ItemListener method
    */
   public void itemStateChanged(ItemEvent e) {
      if (e.getSource() == jsOnlyCB) {
         this.buttonComp.setJavascriptOnly(jsOnlyCB.isSelected());
         System.out.println("javascriptOnly = "
               + this.buttonComp.getJavascriptOnly());
      }
   }

}
