package caslayout.ui;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ButtonType.java,v 1.5 2006/04/05 00:56:43 bozyurt Exp $
 */
public class ButtonType
{
  protected String value;
  public final static ButtonType SUBMIT_BUTTON = new ButtonType("Submit");
  public final static ButtonType PREVIOUS_BUTTON = new ButtonType("Previous");
  public final static ButtonType NEXT_BUTTON = new ButtonType("Next");
  public final static ButtonType ADD_BUTTON = new ButtonType("Add");
  public final static ButtonType REMOVE_BUTTON = new ButtonType("Remove");
  public final static ButtonType REMOVE_LAST_BUTTON = new ButtonType("Remove Last");
  public final static ButtonType SKIP_BUTTON = new ButtonType("Skip");


  public ButtonType(String value) {
      this.value = value;
  }

  public String getValue() { return value; }

  public String toString() { return value; }

  public static ButtonType findButtonType(String value) {
    if ( SUBMIT_BUTTON.getValue().equals(value) )
      return SUBMIT_BUTTON;
    if ( NEXT_BUTTON.getValue().equals(value) )
      return NEXT_BUTTON;
    if ( PREVIOUS_BUTTON.getValue().equals(value) )
      return PREVIOUS_BUTTON;
    if ( ADD_BUTTON.getValue().equals(value) )
      return ADD_BUTTON;
    if ( REMOVE_LAST_BUTTON.getValue().equals(value)) 
    	return REMOVE_LAST_BUTTON;
    if ( REMOVE_BUTTON.getValue().equals(value) )
      return REMOVE_BUTTON;
    if ( SKIP_BUTTON.getValue().equals(value) )
      return SKIP_BUTTON;

    return null;
  }

}
